/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.ontologymatcher;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.tupletable.TupleTable;
import org.molgenis.omx.biobankconnect.ontologymatcher.OntologyMatcher;
import org.molgenis.omx.biobankconnect.utils.StoreMappingTable;
import org.molgenis.omx.observ.Characteristic;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.omx.observ.ObservationSet;
import org.molgenis.omx.observ.ObservedValue;
import org.molgenis.omx.observ.Protocol;
import org.molgenis.omx.observ.target.OntologyTerm;
import org.molgenis.omx.observ.value.BoolValue;
import org.molgenis.omx.observ.value.DecimalValue;
import org.molgenis.omx.observ.value.Value;
import org.molgenis.omx.observ.value.XrefValue;
import org.molgenis.search.Hit;
import org.molgenis.search.SearchRequest;
import org.molgenis.search.SearchResult;
import org.molgenis.search.SearchService;
import org.molgenis.util.Entity;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;

public class AsyncOntologyMatcher
implements OntologyMatcher,
InitializingBean {
    private static final Logger logger = Logger.getLogger(AsyncOntologyMatcher.class);
    private static final String PROTOCOL_IDENTIFIER = "store_mapping";
    private static final String STORE_MAPPING_FEATURE = "store_mapping_feature";
    private static final String STORE_MAPPING_MAPPED_FEATURE = "store_mapping_mapped_feature";
    private static final String STORE_MAPPING_CONFIRM_MAPPING = "store_mapping_confirm_mapping";
    private static final String STORE_MAPPING_SCORE = "store_mapping_score";
    private static final String STORE_MAPPING_ABSOLUTE_SCORE = "store_mapping_absolute_score";
    private static final String CATALOGUE_PREFIX = "protocolTree-";
    private static final String BOOST = "boost";
    private static final String ONTOLOGYTERM_SYNONYM = "ontologyTermSynonym";
    private static final String ONTOLOGY_TERM_IRI = "ontologyTermIRI";
    private static final String NODE_PATH = "nodePath";
    private static final String ENTITY_ID = "id";
    private static final String LUCENE_SCORE = "score";
    private static final String ENTITY_TYPE = "type";
    private static final AtomicInteger runningProcesses = new AtomicInteger();
    private static long totalNumber = 0L;
    private static int finishedNumber = 0;
    @Autowired
    @Qualifier(value="unsecuredDatabase")
    private Database database;
    private SearchService searchService;

    @Autowired
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.searchService == null) {
            throw new IllegalArgumentException("Missing bean of type SearchService");
        }
    }

    @Override
    public boolean isRunning() {
        return runningProcesses.get() != 0;
    }

    @Override
    public Integer matchPercentage() {
        DecimalFormat df = new DecimalFormat("#.##");
        Double percentage = totalNumber == 0L ? new Double(0.0) : (double)finishedNumber / (double)totalNumber;
        percentage = Double.parseDouble(df.format(percentage * 100.0));
        return percentage.intValue();
    }

    @Override
    public void deleteDocumentByIds(String documentType, List<String> documentIds) {
        this.searchService.deleteDocumentByIds(documentType, documentIds);
    }

    private void preprocessing(Integer selectedDataSet, List<Integer> dataSetsToMatch, Database db) throws DatabaseException {
        this.createMappingStore(selectedDataSet, dataSetsToMatch, db);
        for (Integer catalogueId : dataSetsToMatch) {
            StringBuilder dataSetIdentifier = new StringBuilder();
            dataSetIdentifier.append(selectedDataSet).append('-').append(catalogueId);
            this.deleteExistingRecords(dataSetIdentifier.toString(), db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async
    public void match(Integer selectedDataSet, List<Integer> dataSetsToMatch) throws DatabaseException {
        runningProcesses.incrementAndGet();
        ArrayList<ObservationSet> listOfNewObservationSets = new ArrayList<ObservationSet>();
        ArrayList<ObservedValue> listOfNewObservedValues = new ArrayList<ObservedValue>();
        try {
            this.preprocessing(selectedDataSet, dataSetsToMatch, this.database);
            ArrayList<QueryRule> queryRules = new ArrayList<QueryRule>();
            queryRules.add(new QueryRule(ENTITY_TYPE, QueryRule.Operator.SEARCH, ObservableFeature.class.getSimpleName().toLowerCase()));
            queryRules.add(new QueryRule(QueryRule.Operator.LIMIT, (Object)100000));
            SearchResult result = this.searchService.search(new SearchRequest(CATALOGUE_PREFIX + selectedDataSet, queryRules, null));
            totalNumber = result.getTotalHitCount();
            for (Hit hit : result.getSearchHits()) {
                Map columnValueMap = hit.getColumnValueMap();
                ObservableFeature feature = (ObservableFeature)this.database.findById(ObservableFeature.class, columnValueMap.get(ENTITY_ID.toString()));
                if (feature == null) continue;
                Map<Integer, Set<String>> position = null;
                ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
                String description = feature.getDescription() == null || feature.getDescription().isEmpty() ? feature.getName() : feature.getDescription();
                rules.add(new QueryRule("description".toLowerCase(), QueryRule.Operator.SEARCH, description));
                if (feature.getDefinitions() != null && feature.getDefinitions().size() > 0) {
                    position = this.createQueryRules(description, feature.getDefinitions());
                    rules.addAll(this.makeQueryForOntologyTerms(position));
                }
                QueryRule finalQuery = new QueryRule(rules);
                finalQuery.setOperator(QueryRule.Operator.DIS_MAX);
                for (Integer catalogueId : dataSetsToMatch) {
                    StringBuilder dataSetIdentifier = new StringBuilder();
                    dataSetIdentifier.append(selectedDataSet).append('-').append(catalogueId);
                    Iterator<Hit> mappedFeatureHits = this.searchDisMaxQuery(CATALOGUE_PREFIX + catalogueId, finalQuery);
                    while (mappedFeatureHits.hasNext()) {
                        Hit mappedFeatureHit = mappedFeatureHits.next();
                        Map columValueMap = mappedFeatureHit.getColumnValueMap();
                        Integer mappedId = Integer.parseInt(columValueMap.get(ENTITY_ID).toString());
                        Double score = Double.parseDouble(columValueMap.get(LUCENE_SCORE).toString());
                        ObservationSet observation = new ObservationSet();
                        observation.setPartOfDataSet_Identifier(dataSetIdentifier.toString());
                        listOfNewObservationSets.add(observation);
                        XrefValue xrefForFeature = new XrefValue();
                        xrefForFeature.setValue((Characteristic)this.database.findById(Characteristic.class, (Object)feature.getId()));
                        ObservedValue valueForFeature = new ObservedValue();
                        valueForFeature.setObservationSet(observation);
                        valueForFeature.setFeature_Identifier(STORE_MAPPING_FEATURE);
                        valueForFeature.setValue((Value)xrefForFeature);
                        listOfNewObservedValues.add(valueForFeature);
                        XrefValue xrefForMappedFeature = new XrefValue();
                        xrefForMappedFeature.setValue((Characteristic)this.database.findById(Characteristic.class, (Object)mappedId));
                        ObservedValue valueForMappedFeature = new ObservedValue();
                        valueForMappedFeature.setFeature_Identifier(STORE_MAPPING_MAPPED_FEATURE);
                        valueForMappedFeature.setObservationSet(observation);
                        valueForMappedFeature.setValue((Value)xrefForMappedFeature);
                        listOfNewObservedValues.add(valueForMappedFeature);
                        DecimalValue decimalForScore = new DecimalValue();
                        decimalForScore.setValue(score);
                        ObservedValue valueForMappedFeatureScore = new ObservedValue();
                        valueForMappedFeatureScore.setFeature_Identifier(STORE_MAPPING_SCORE);
                        valueForMappedFeatureScore.setObservationSet(observation);
                        valueForMappedFeatureScore.setValue((Value)decimalForScore);
                        listOfNewObservedValues.add(valueForMappedFeatureScore);
                        BoolValue boolValue = new BoolValue();
                        boolValue.setValue(Boolean.valueOf(false));
                        ObservedValue confirmMappingValue = new ObservedValue();
                        confirmMappingValue.setFeature_Identifier(STORE_MAPPING_CONFIRM_MAPPING);
                        confirmMappingValue.setObservationSet(observation);
                        confirmMappingValue.setValue((Value)boolValue);
                        listOfNewObservedValues.add(confirmMappingValue);
                    }
                }
                ++finishedNumber;
            }
            this.database.add(listOfNewObservationSets);
            this.database.add(listOfNewObservedValues);
            for (Integer catalogueId : dataSetsToMatch) {
                StringBuilder dataSetIdentifier = new StringBuilder();
                dataSetIdentifier.append(selectedDataSet).append('-').append(catalogueId);
                this.searchService.indexTupleTable(dataSetIdentifier.toString(), (TupleTable)new StoreMappingTable(dataSetIdentifier.toString(), this.database));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception the matching process has failed!", (Throwable)e);
        }
        finally {
            runningProcesses.decrementAndGet();
            totalNumber = 0L;
            finishedNumber = 0;
        }
    }

    private List<QueryRule> makeQueryForOntologyTerms(Map<Integer, Set<String>> nameTokens) {
        ArrayList<QueryRule> subQueries = new ArrayList<QueryRule>();
        ArrayList<QueryRule> allQueries = new ArrayList<QueryRule>();
        for (Map.Entry<Integer, Set<String>> entries : nameTokens.entrySet()) {
            ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
            Integer index = entries.getKey();
            if (index != -1) {
                for (String term : entries.getValue()) {
                    rules.add(new QueryRule("description".toLowerCase(), QueryRule.Operator.SEARCH, term));
                }
                QueryRule queryRule = new QueryRule(rules);
                queryRule.setOperator(QueryRule.Operator.DIS_MAX);
                subQueries.add(queryRule);
                continue;
            }
            for (String term : entries.getValue()) {
                allQueries.add(new QueryRule("description".toLowerCase(), QueryRule.Operator.SEARCH, term));
            }
        }
        QueryRule combinedQuery = new QueryRule(subQueries);
        combinedQuery.setOperator(QueryRule.Operator.SHOULD);
        allQueries.add(combinedQuery);
        return allQueries;
    }

    private Iterator<Hit> searchDisMaxQuery(String documentType, QueryRule disMaxQuery) {
        SearchResult result = null;
        try {
            ArrayList<QueryRule> finalQuery = new ArrayList<QueryRule>();
            finalQuery.add(new QueryRule(ENTITY_TYPE, QueryRule.Operator.EQUALS, ObservableFeature.class.getSimpleName().toLowerCase()));
            finalQuery.add(new QueryRule(QueryRule.Operator.AND));
            finalQuery.add(disMaxQuery);
            finalQuery.add(new QueryRule(QueryRule.Operator.LIMIT, (Object)50));
            SearchRequest request = new SearchRequest(documentType, finalQuery, null);
            result = this.searchService.search(request);
        }
        catch (Exception e) {
            result = new SearchResult(e.getMessage());
            logger.error((Object)("Exception failed to search the request " + result), (Throwable)e);
        }
        return result.iterator();
    }

    private Map<Integer, Set<String>> createQueryRules(String dataItem, List<OntologyTerm> definitions) {
        HashMap<Integer, Set<String>> position = new HashMap<Integer, Set<String>>();
        HashMap pathToSynonyms = new HashMap();
        HashMap<String, Boolean> allPaths = new HashMap<String, Boolean>();
        ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
        for (OntologyTerm ot : definitions) {
            if (rules.size() != 0) {
                rules.add(new QueryRule(QueryRule.Operator.OR));
            }
            rules.add(new QueryRule(ONTOLOGY_TERM_IRI, QueryRule.Operator.EQUALS, ot.getTermAccession()));
        }
        rules.add(new QueryRule(QueryRule.Operator.LIMIT, (Object)10000));
        SearchRequest request = new SearchRequest(null, rules, null);
        SearchResult result = this.searchService.search(request);
        for (Hit hit : result) {
            Map columnValueMap = hit.getColumnValueMap();
            Boolean boost = (Boolean)columnValueMap.get(BOOST);
            String nodePath = columnValueMap.get(NODE_PATH).toString();
            allPaths.put(nodePath, boost);
            if (!pathToSynonyms.containsKey(nodePath)) {
                pathToSynonyms.put(nodePath, new HashSet());
            }
            ((Set)pathToSynonyms.get(nodePath)).add(columnValueMap.get(ONTOLOGYTERM_SYNONYM).toString().trim().toLowerCase());
        }
        for (Map.Entry entry : allPaths.entrySet()) {
            String parentNodePath = (String)entry.getKey();
            Boolean boost = (Boolean)entry.getValue();
            Integer finalIndexPosition = -1;
            ArrayList<QueryRule> queryRules = new ArrayList<QueryRule>();
            queryRules.add(new QueryRule(NODE_PATH, QueryRule.Operator.LIKE, (String)entry.getKey()));
            queryRules.add(new QueryRule(QueryRule.Operator.LIMIT, (Object)5000));
            SearchResult result2 = this.searchService.search(new SearchRequest(null, queryRules, null));
            Iterator iterator = result2.iterator();
            HashSet<String> existingPaths = new HashSet<String>();
            HashSet<String> terms = new HashSet<String>();
            Pattern pattern = Pattern.compile("[0-9]+");
            Matcher matcher = null;
            while (iterator.hasNext()) {
                String ontologyTermSynonym;
                Hit hit = (Hit)iterator.next();
                Map columnValueMap = hit.getColumnValueMap();
                String nodePath = columnValueMap.get(NODE_PATH).toString();
                if (existingPaths.contains(nodePath)) continue;
                existingPaths.add(nodePath);
                if (!nodePath.startsWith(parentNodePath + ".") && !nodePath.equals(parentNodePath) || (matcher = pattern.matcher(ontologyTermSynonym = columnValueMap.get(ONTOLOGYTERM_SYNONYM).toString().trim().toLowerCase())).find() || ontologyTermSynonym.equals("")) continue;
                String boostNumber = "^3";
                if (boost.booleanValue() && pathToSynonyms.containsKey(parentNodePath)) {
                    boostNumber = "^6";
                }
                ArrayList listOfSynonyms = new ArrayList((Collection)pathToSynonyms.get(parentNodePath));
                Collections.sort(listOfSynonyms, new MyComparator());
                for (String boostedTerm : listOfSynonyms) {
                    if (!ontologyTermSynonym.contains(boostedTerm)) continue;
                    String orignalTerm = ontologyTermSynonym;
                    String replacement = boostedTerm + boostNumber;
                    if (boostedTerm.split(" +").length > 1) {
                        replacement = "\"" + boostedTerm + "\"" + boostNumber;
                    }
                    terms.add(orignalTerm.replaceAll(boostedTerm, replacement));
                    break;
                }
                if (ontologyTermSynonym.toString().equals("")) continue;
                terms.add(ontologyTermSynonym);
            }
            if (!position.containsKey(finalIndexPosition)) {
                position.put(finalIndexPosition, new HashSet());
            }
            ((Set)position.get(finalIndexPosition)).addAll(terms);
        }
        return position;
    }

    private void deleteExistingRecords(String dataSetIdentifier, Database db) throws DatabaseException {
        List listOfObservationSets = db.find(ObservationSet.class, new QueryRule[]{new QueryRule("partOfDataSet_Identifier", QueryRule.Operator.EQUALS, dataSetIdentifier)});
        if (listOfObservationSets.size() > 0) {
            ArrayList<String> listOfObservationIdentifiers = new ArrayList<String>();
            for (ObservationSet observation : listOfObservationSets) {
                listOfObservationIdentifiers.add(observation.getIdentifier());
            }
            List listOfObservedValues = db.find(ObservedValue.class, new QueryRule[]{new QueryRule("ObservationSet_Identifier", QueryRule.Operator.IN, listOfObservationIdentifiers)});
            if (listOfObservedValues.size() > 0) {
                db.remove(listOfObservedValues);
            }
            db.remove(listOfObservationSets);
            this.searchService.deleteDocumentsByType(dataSetIdentifier);
        }
    }

    private void createMappingStore(Integer selectedDataSet, List<Integer> dataSetsToMatch, Database db) throws DatabaseException {
        boolean ifProtocolExists;
        boolean isConfirmMappingExists;
        boolean isMappedFetureAbsoluteScore;
        boolean isMappedFetureScore;
        boolean isMappedFeatureExists;
        boolean isFeatureExists;
        boolean bl = isFeatureExists = db.find(ObservableFeature.class, new QueryRule[]{new QueryRule("Identifier", QueryRule.Operator.EQUALS, STORE_MAPPING_FEATURE)}).size() == 0;
        if (isFeatureExists) {
            ObservableFeature feature = new ObservableFeature();
            feature.setIdentifier(STORE_MAPPING_FEATURE);
            feature.setDataType("xref");
            feature.setName("Features");
            db.add((Entity)feature);
        }
        boolean bl2 = isMappedFeatureExists = db.find(ObservableFeature.class, new QueryRule[]{new QueryRule("Identifier", QueryRule.Operator.EQUALS, STORE_MAPPING_MAPPED_FEATURE)}).size() == 0;
        if (isMappedFeatureExists) {
            ObservableFeature mappedFeature = new ObservableFeature();
            mappedFeature.setIdentifier(STORE_MAPPING_MAPPED_FEATURE);
            mappedFeature.setDataType("xref");
            mappedFeature.setName("Mapped features");
            db.add((Entity)mappedFeature);
        }
        boolean bl3 = isMappedFetureScore = db.find(ObservableFeature.class, new QueryRule[]{new QueryRule("Identifier", QueryRule.Operator.EQUALS, STORE_MAPPING_SCORE)}).size() == 0;
        if (isMappedFetureScore) {
            ObservableFeature mappedFeatureScore = new ObservableFeature();
            mappedFeatureScore.setIdentifier(STORE_MAPPING_SCORE);
            mappedFeatureScore.setDataType("decimal");
            mappedFeatureScore.setName(STORE_MAPPING_SCORE);
            db.add((Entity)mappedFeatureScore);
        }
        boolean bl4 = isMappedFetureAbsoluteScore = db.find(ObservableFeature.class, new QueryRule[]{new QueryRule("Identifier", QueryRule.Operator.EQUALS, STORE_MAPPING_ABSOLUTE_SCORE)}).size() == 0;
        if (isMappedFetureAbsoluteScore) {
            ObservableFeature mappedFeatureAbsoluteScore = new ObservableFeature();
            mappedFeatureAbsoluteScore.setIdentifier(STORE_MAPPING_ABSOLUTE_SCORE);
            mappedFeatureAbsoluteScore.setDataType("decimal");
            mappedFeatureAbsoluteScore.setName(STORE_MAPPING_ABSOLUTE_SCORE);
            db.add((Entity)mappedFeatureAbsoluteScore);
        }
        boolean bl5 = isConfirmMappingExists = db.find(ObservableFeature.class, new QueryRule[]{new QueryRule("Identifier", QueryRule.Operator.EQUALS, STORE_MAPPING_CONFIRM_MAPPING)}).size() == 0;
        if (isConfirmMappingExists) {
            ObservableFeature confirmMapping = new ObservableFeature();
            confirmMapping.setIdentifier(STORE_MAPPING_CONFIRM_MAPPING);
            confirmMapping.setDataType("bool");
            confirmMapping.setName("Mapping confirmed");
            db.add((Entity)confirmMapping);
        }
        boolean bl6 = ifProtocolExists = db.find(Protocol.class, new QueryRule[]{new QueryRule("Identifier", QueryRule.Operator.EQUALS, PROTOCOL_IDENTIFIER)}).size() == 0;
        if (ifProtocolExists) {
            Protocol protocol = new Protocol();
            protocol.setIdentifier(PROTOCOL_IDENTIFIER);
            protocol.setName(PROTOCOL_IDENTIFIER);
            protocol.setFeatures_Identifier(Arrays.asList(STORE_MAPPING_FEATURE, STORE_MAPPING_MAPPED_FEATURE, STORE_MAPPING_SCORE, STORE_MAPPING_ABSOLUTE_SCORE, STORE_MAPPING_CONFIRM_MAPPING));
            db.add((Entity)protocol);
        }
        for (Integer dataSetId : dataSetsToMatch) {
            String identifier = selectedDataSet + "-" + dataSetId;
            boolean ifDataSetExists = db.find(DataSet.class, new QueryRule[]{new QueryRule("Identifier", QueryRule.Operator.EQUALS, identifier)}).size() == 0;
            if (!ifDataSetExists) continue;
            DataSet dataSet = new DataSet();
            dataSet.setIdentifier(identifier);
            dataSet.setName(identifier);
            dataSet.setProtocolUsed_Identifier(PROTOCOL_IDENTIFIER);
            db.add((Entity)dataSet);
        }
    }

    @Override
    public boolean checkExistingMappings(String dataSetIdentifier, Database db) throws DatabaseException {
        List listOfObservationSets = db.find(ObservationSet.class, new QueryRule[]{new QueryRule("partOfDataSet_Identifier", QueryRule.Operator.EQUALS, dataSetIdentifier)});
        return listOfObservationSets.size() > 0;
    }

    class MyComparator
    implements Comparator<String> {
        MyComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.length() > o2.length()) {
                return -1;
            }
            if (o1.length() < o2.length()) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }
}

