/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.utils;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OntologyLoader {
    private String ontologyIRI = null;
    private String ontologyName = null;
    private File ontologyFile = null;
    private OWLDataFactory factory = null;
    private OWLOntology ontology = null;
    private OWLOntologyManager manager = null;
    private Set<String> synonymsProperties = new HashSet<String>(Arrays.asList("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#FULL_SYN", "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P90"));
    private Set<String> owlObjectProperties = new HashSet<String>(Arrays.asList("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#is_associated_with"));
    private Map<String, OWLClass> hashToRetrieveClass = new HashMap<String, OWLClass>();

    public OntologyLoader(OWLOntologyManager manager, OWLDataFactory factory) {
        this.manager = manager;
        this.factory = factory;
    }

    public OntologyLoader(String ontologyName, File ontologyFile) throws OWLOntologyCreationException {
        this.ontologyFile = ontologyFile;
        this.manager = OWLManager.createOWLOntologyManager();
        this.factory = this.manager.getOWLDataFactory();
        this.ontologyName = ontologyName;
        this.ontology = this.manager.loadOntologyFromOntologyDocument(ontologyFile);
        this.ontologyIRI = this.ontology.getOntologyID().getOntologyIRI().toString();
    }

    public void loadOntology(String ontologyName, File ontologyFile) throws OWLOntologyCreationException {
        this.ontologyName = ontologyName;
        this.ontologyFile = ontologyFile;
        this.ontology = this.manager.loadOntologyFromOntologyDocument(ontologyFile);
        this.ontologyIRI = this.ontology.getOntologyID().getOntologyIRI().toString();
    }

    public void preProcessing() {
        for (OWLClass cls : this.ontology.getClassesInSignature()) {
            this.hashToRetrieveClass.put(this.getLabel((OWLEntity)cls).trim().toLowerCase(), cls);
        }
    }

    public Set<OWLAnnotationAssertionAxiom> getAllAnnotationAxiom(OWLClass cls) {
        HashSet<OWLAnnotationAssertionAxiom> axioms = new HashSet<OWLAnnotationAssertionAxiom>();
        for (OWLAnnotation annotation : cls.getAnnotations(this.ontology)) {
            axioms.add(this.factory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)cls.getIRI(), annotation));
        }
        return axioms == null ? new HashSet<OWLAnnotationAssertionAxiom>() : axioms;
    }

    public Set<OWLClass> getTopClasses() {
        HashSet<OWLClass> listOfTopClasses = new HashSet<OWLClass>();
        for (OWLClass cls : this.ontology.getClassesInSignature()) {
            if (this.ontology.getSubClassAxiomsForSubClass(cls).size() != 0 || this.ontology.getEquivalentClassesAxioms(cls).size() != 0) continue;
            listOfTopClasses.add(cls);
        }
        return listOfTopClasses;
    }

    public Set<OWLClass> getAssociatedClasses(OWLClass cls) {
        HashSet<OWLClass> associatedTerms = new HashSet<OWLClass>();
        for (OWLSubClassOfAxiom axiom : this.ontology.getSubClassAxiomsForSubClass(cls)) {
            OWLClassExpression expression = axiom.getSuperClass();
            if (!expression.isAnonymous()) continue;
            for (OWLObjectProperty property : expression.getObjectPropertiesInSignature()) {
                if (!this.owlObjectProperties.contains(property.getIRI().toString())) continue;
                for (OWLClass associatedClass : expression.getClassesInSignature()) {
                    associatedTerms.add(associatedClass);
                }
            }
        }
        return associatedTerms;
    }

    public Set<String> getSynonyms(OWLClass cls) {
        HashSet<String> listOfSynonyms = new HashSet<String>();
        for (String eachSynonymProperty : this.synonymsProperties) {
            OWLAnnotationProperty property = this.factory.getOWLAnnotationProperty(IRI.create((String)eachSynonymProperty));
            for (OWLAnnotation annotation : cls.getAnnotations(this.ontology, property)) {
                OWLLiteral val = (OWLLiteral)annotation.getValue();
                listOfSynonyms.add(val.getLiteral());
            }
        }
        return listOfSynonyms;
    }

    public Set<OWLClass> getChildClass(OWLClass cls) {
        HashSet<OWLClass> listOfClasses = new HashSet<OWLClass>();
        for (OWLSubClassOfAxiom axiom : this.ontology.getSubClassAxiomsForSuperClass(cls)) {
            OWLClassExpression expression = axiom.getSubClass();
            if (expression.isAnonymous()) continue;
            listOfClasses.add(expression.asOWLClass());
        }
        return listOfClasses;
    }

    public String getLabel(OWLEntity cls) {
        String labelValue = "";
        try {
            OWLAnnotationProperty label = this.factory.getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_LABEL.getIRI());
            for (OWLAnnotation annotation : cls.getAnnotations(this.ontology, label)) {
                if (!(annotation.getValue() instanceof OWLLiteral)) continue;
                OWLLiteral val = (OWLLiteral)annotation.getValue();
                labelValue = val.getLiteral().toString();
            }
        }
        catch (Exception e) {
            new RuntimeException(e);
        }
        return labelValue;
    }

    public String getOntologyLabel() {
        OWLAnnotationProperty labelProperty = this.factory.getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_LABEL.getIRI());
        String ontologyLabel = "";
        for (OWLAnnotation annotation : this.ontology.getAnnotations()) {
            if (!annotation.getProperty().equals(labelProperty) || !(annotation.getValue() instanceof OWLLiteral)) continue;
            OWLLiteral val = (OWLLiteral)annotation.getValue();
            ontologyLabel = val.getLiteral();
        }
        return ontologyLabel;
    }

    public String getOntologyIRI() {
        return this.ontologyIRI;
    }

    public String getOntologyName() {
        return this.ontologyName;
    }

    public String getOntologyFilePath() {
        return this.ontologyFile.getAbsolutePath();
    }

    public Map<String, OWLClass> getHashToRetrieveClass() {
        return this.hashToRetrieveClass;
    }

    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSuperClass(OWLClass cls) {
        return this.ontology.getSubClassAxiomsForSuperClass(cls);
    }

    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSubClass(OWLClass cls) {
        return this.ontology.getSubClassAxiomsForSubClass(cls);
    }
}

