/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.bind.JAXBException;
import org.molgenis.io.csv.CsvReader;
import org.molgenis.omx.biobankconnect.utils.OntologyManager;
import org.molgenis.util.tuple.Tuple;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;

public class OntologyLoaderApp {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws OWLOntologyCreationException, FileNotFoundException, IOException, OWLOntologyStorageException, JAXBException {
        if (args.length > 1) {
            String inputFileName = args[0];
            String variableList = args[1];
            File file = new File(inputFileName);
            System.out.println("start loading");
            OntologyManager manager = new OntologyManager();
            manager.loadExistingOntology(file);
            HashSet<String> terms = new HashSet<String>();
            CsvReader reader = null;
            try {
                reader = new CsvReader(new File(variableList));
                Iterator iterator = reader.iterator();
                while (iterator.hasNext()) {
                    terms.add(((Tuple)iterator.next()).getString("name"));
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            File outputFile = new File(file.getAbsoluteFile().getParent() + "/" + file.getName() + "_subset.owl");
            manager.copyOntologyContent(terms);
            manager.saveOntology(outputFile);
            System.out.println("finish loading");
        }
    }
}

