/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.tupletable.AbstractFilterableTupleTable;
import org.molgenis.framework.tupletable.DatabaseTupleTable;
import org.molgenis.framework.tupletable.TableException;
import org.molgenis.model.elements.Field;
import org.molgenis.omx.biobankconnect.utils.OntologyLoader;
import org.molgenis.util.tuple.KeyValueTuple;
import org.molgenis.util.tuple.Tuple;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;

public class OntologyTermTable
extends AbstractFilterableTupleTable
implements DatabaseTupleTable {
    private OntologyLoader loader;
    private Database db;
    private final String ontologyIRI;
    private final String ontologyName;
    private final String NODE_PATH = "nodePath";
    private final String BOOST = "boost";
    private final String ONTOLOGY_IRI = "ontologyIRI";
    private final String ONTOLOGY_NAME = "ontologyName";
    private final String ONTOLOGY_TERM = "ontologyTerm";
    private final String ONTOLOGY_TERM_IRI = "ontologyTermIRI";
    private final String SYNONYMS = "ontologyTermSynonym";
    private final String ONTOLOGY_LABEL = "ontologyLabel";
    private final String ENTITY_TYPE = "entity_type";

    public OntologyTermTable(OntologyLoader loader, Database db) {
        this.loader = loader;
        this.ontologyName = this.loader.getOntologyName();
        this.ontologyIRI = this.loader.getOntologyIRI();
        this.setDb(db);
    }

    public Iterator<Tuple> iterator() {
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        this.createOntologyTable(tuples, this.loader);
        return tuples.iterator();
    }

    private void createOntologyTable(List<Tuple> tuples, OntologyLoader model) {
        int count = 0;
        for (OWLClass subClass : model.getTopClasses()) {
            this.recursiveAddTuple("0." + count, subClass, model, tuples);
            ++count;
        }
    }

    private void recursiveAddTuple(String termPath, OWLClass cls, OntologyLoader model, List<Tuple> tuples) {
        String label = model.getLabel((OWLEntity)cls).replaceAll("[^a-zA-Z0-9 ]", " ");
        HashSet<String> synonyms = new HashSet<String>();
        synonyms.add(label);
        synonyms.addAll(model.getSynonyms(cls));
        for (String synonym : synonyms) {
            KeyValueTuple tuple = new KeyValueTuple();
            tuple.set("nodePath", (Object)termPath);
            tuple.set("boost", (Object)false);
            tuple.set("ontologyIRI", (Object)this.ontologyIRI);
            tuple.set("ontologyName", (Object)this.ontologyName);
            tuple.set("ontologyTerm", (Object)label);
            tuple.set("ontologyTermIRI", (Object)cls.getIRI().toString());
            tuple.set("ontologyLabel", (Object)model.getOntologyName());
            tuple.set("entity_type", (Object)"ontologyTerm");
            tuple.set("ontologyTermSynonym", (Object)synonym.replaceAll("[^a-zA-Z0-9 ]", " "));
            tuples.add((Tuple)tuple);
        }
        Set<OWLClass> listOfChildren = model.getChildClass(cls);
        listOfChildren.addAll(model.getAssociatedClasses(cls));
        if (listOfChildren.size() > 0) {
            int i = 0;
            for (OWLClass childClass : listOfChildren) {
                String childTermPath = termPath + "." + i;
                this.recursiveAddTuple(childTermPath, childClass, model, tuples);
                ++i;
            }
        }
    }

    public Database getDb() {
        return this.db;
    }

    public void setDb(Database db) {
        this.db = db;
    }

    public List<Field> getAllColumns() throws TableException {
        ArrayList<Field> columns = new ArrayList<Field>();
        columns.add(new Field("nodePath"));
        columns.add(new Field("boost"));
        columns.add(new Field("ontologyIRI"));
        columns.add(new Field("ontologyTerm"));
        columns.add(new Field("ontologyTermIRI"));
        columns.add(new Field("ontologyLabel"));
        columns.add(new Field("ontologyTermSynonym"));
        columns.add(new Field("entity_type"));
        return columns;
    }

    public int getCount() {
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        this.createOntologyTable(tuples, this.loader);
        return tuples.size();
    }
}

