/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.molgenis.io.excel.ExcelReader;
import org.molgenis.io.excel.ExcelSheetReader;
import org.molgenis.io.excel.ExcelSheetWriter;
import org.molgenis.io.excel.ExcelWriter;
import org.molgenis.util.tuple.KeyValueTuple;
import org.molgenis.util.tuple.Tuple;

public class OpalToOmxConvertor {
    private Map<String, List<UniqueCategory>> categoryInfo = new LinkedHashMap<String, List<UniqueCategory>>();
    private Map<String, UniqueVariable> variableInfo = new LinkedHashMap<String, UniqueVariable>();
    private String studyName = null;

    public OpalToOmxConvertor(String studyName, String filePath) throws IOException {
        this.studyName = studyName;
        this.start(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(String fileString) throws IOException {
        File file = new File(fileString);
        if (file.exists()) {
            ExcelReader reader = null;
            try {
                reader = new ExcelReader(file, true);
                this.collectCategoryInfo(reader);
                this.collectVariableInfo(reader);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            ExcelWriter writer = null;
            try {
                writer = new ExcelWriter(new File(file.getAbsolutePath() + ".OPAL.xls"));
                this.writeToPhenoFormat(writer);
            }
            finally {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToPhenoFormat(ExcelWriter writer) throws IOException {
        String protocolIdentifier = this.studyName + "-protocol";
        String listOfFeatureIdentifier = "";
        ExcelSheetWriter dataSet = null;
        try {
            dataSet = (ExcelSheetWriter)writer.createTupleWriter("dataset");
            dataSet.writeColNames(Arrays.asList("identifier", "name", "protocolUsed_identifier"));
            KeyValueTuple row = new KeyValueTuple();
            row.set("identifier", (Object)this.studyName);
            row.set("name", (Object)this.studyName);
            row.set("protocolUsed_identifier", (Object)protocolIdentifier);
            dataSet.write((Tuple)row);
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
        }
        ExcelSheetWriter categorySheet = null;
        try {
            categorySheet = (ExcelSheetWriter)writer.createTupleWriter("category");
            categorySheet.writeColNames(Arrays.asList("identifier", "name", "valueCode", "observablefeature_identifier"));
            for (Map.Entry<String, List<UniqueCategory>> entry : this.categoryInfo.entrySet()) {
                String featureIdentifier = this.studyName + "-feature-" + entry.getKey();
                List<UniqueCategory> categoriesPerFeature = entry.getValue();
                for (UniqueCategory eachCategory : categoriesPerFeature) {
                    KeyValueTuple eachRow = new KeyValueTuple();
                    eachRow.set("identifier", (Object)(this.studyName + "-category-" + eachCategory.getName()));
                    eachRow.set("name", (Object)eachCategory.getLabel());
                    eachRow.set("valueCode", (Object)eachCategory.getCode());
                    eachRow.set("observablefeature_identifier", (Object)featureIdentifier);
                    categorySheet.write((Tuple)eachRow);
                }
            }
        }
        finally {
            if (categorySheet != null) {
                categorySheet.close();
            }
        }
        ExcelSheetWriter featureWriter = null;
        try {
            featureWriter = (ExcelSheetWriter)writer.createTupleWriter("observablefeature");
            featureWriter.writeColNames(Arrays.asList("identifier", "name", "description", "description", "dataType", "unit_Identifier"));
            for (UniqueVariable eachVariable : this.variableInfo.values()) {
                KeyValueTuple eachRow = new KeyValueTuple();
                String name = eachVariable.getVariable();
                String dataType = eachVariable.getDataType();
                StringBuilder categoriesName = new StringBuilder();
                if (this.categoryInfo.containsKey(name)) {
                    for (UniqueCategory eachCategory : this.categoryInfo.get(name)) {
                        categoriesName.append(eachCategory.getName()).append(',');
                    }
                    dataType = "categorical";
                } else {
                    dataType = dataType != null && dataType.equals("integer") ? "int" : (dataType != null && dataType.equals("decimal") ? "decimal" : "string");
                }
                String featureIdentifier = this.studyName + "-feature-" + name;
                listOfFeatureIdentifier = listOfFeatureIdentifier + featureIdentifier + ",";
                eachRow.set("identifier", (Object)featureIdentifier);
                eachRow.set("name", (Object)name);
                eachRow.set("description", (Object)eachVariable.getLabel());
                eachRow.set("dataType", (Object)dataType);
                featureWriter.write((Tuple)eachRow);
            }
        }
        finally {
            if (featureWriter != null) {
                featureWriter.close();
            }
        }
        ExcelSheetWriter protocolSheet = null;
        try {
            protocolSheet = (ExcelSheetWriter)writer.createTupleWriter("protocol");
            protocolSheet.writeColNames(Arrays.asList("identifier", "name", "features_identifier", "subprotocols_identifier"));
            KeyValueTuple protocol = new KeyValueTuple();
            protocol.set("identifier", (Object)protocolIdentifier);
            protocol.set("name", (Object)protocolIdentifier);
            protocol.set("features_identifier", (Object)listOfFeatureIdentifier.substring(0, listOfFeatureIdentifier.length() - 1));
            protocolSheet.write((Tuple)protocol);
        }
        finally {
            if (protocolSheet != null) {
                protocolSheet.close();
            }
        }
    }

    private void collectVariableInfo(ExcelReader reader) throws IOException {
        ExcelSheetReader variableSheet = reader.getSheet(0);
        Iterator colNamesIterator = variableSheet.colNamesIterator();
        ArrayList<String> colNamesList = new ArrayList<String>();
        while (colNamesIterator.hasNext()) {
            colNamesList.add(colNamesIterator.next().toString());
        }
        for (Tuple eachRow : variableSheet) {
            String variableID = eachRow.getString("name");
            String label = eachRow.getString("label:en");
            String dataType = eachRow.getString("valueType");
            if (variableID != null) {
                variableID = variableID.trim();
            }
            if (label != null) {
                label = label.trim();
            }
            if (this.variableInfo.containsKey(variableID)) continue;
            UniqueVariable newVariable = new UniqueVariable(variableID, label, dataType);
            this.variableInfo.put(variableID, newVariable);
        }
    }

    private void collectCategoryInfo(ExcelReader reader) throws IOException {
        ExcelSheetReader categoryReader = reader.getSheet(1);
        Iterator iterator = categoryReader.colNamesIterator();
        ArrayList<String> listOfColumnHeaders = new ArrayList<String>();
        while (iterator.hasNext()) {
            listOfColumnHeaders.add(iterator.next().toString());
        }
        for (Tuple eachRow : categoryReader) {
            String featureID = eachRow.getString("variable");
            if (featureID == null) continue;
            featureID = featureID.trim();
            String code = eachRow.getString("name");
            String categoryDescription = eachRow.getString("label:en");
            List<UniqueCategory> listOfCategoriesPerVariable = null;
            listOfCategoriesPerVariable = this.categoryInfo.containsKey(featureID) ? this.categoryInfo.get(featureID) : new ArrayList<UniqueCategory>();
            listOfCategoriesPerVariable.add(new UniqueCategory(this.studyName + "_" + featureID + "_" + code, code, categoryDescription));
            this.categoryInfo.put(featureID, listOfCategoriesPerVariable);
        }
    }

    public static void main(String[] args) throws IOException {
        new OpalToOmxConvertor(args[0], args[1]);
    }

    class UniqueCategory {
        private final String code;
        private final String label;
        private final String name;

        public UniqueCategory(String code, String label) {
            this.code = code.trim();
            this.label = label != null ? label.trim() : "";
            StringBuilder name = new StringBuilder();
            this.name = name.append(OpalToOmxConvertor.this.studyName).append('_').append(code).append('_').append(label).toString().replaceAll("[^a-zA-Z0-9_]", "_").toLowerCase();
        }

        public UniqueCategory(String name, String code, String label) {
            this.code = code.trim();
            this.label = label != null ? label.trim() : "";
            this.name = name.replaceAll("[^a-zA-Z0-9_]", "_");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UniqueCategory other = (UniqueCategory)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String getName() {
            return this.name;
        }

        public String getCode() {
            return this.code;
        }

        public String getLabel() {
            return this.label;
        }

        private OpalToOmxConvertor getOuterType() {
            return OpalToOmxConvertor.this;
        }
    }

    class UniqueVariable {
        private final String variable;
        private final String label;
        private final String dataType;

        public UniqueVariable(String variable, String label, String dataType) {
            this.variable = variable;
            this.label = label;
            this.dataType = dataType;
        }

        public String getVariable() {
            return this.variable;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDataType() {
            return this.dataType;
        }
    }
}

