/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.fieldtypes.FieldType;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.tupletable.AbstractFilterableTupleTable;
import org.molgenis.framework.tupletable.DatabaseTupleTable;
import org.molgenis.framework.tupletable.TableException;
import org.molgenis.model.elements.Field;
import org.molgenis.omx.converters.ValueConverter;
import org.molgenis.omx.observ.Category;
import org.molgenis.omx.observ.Characteristic;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.omx.observ.ObservationSet;
import org.molgenis.omx.observ.ObservedValue;
import org.molgenis.omx.observ.Protocol;
import org.molgenis.omx.observ.value.XrefValue;
import org.molgenis.util.tuple.KeyValueTuple;
import org.molgenis.util.tuple.Tuple;

public class StoreMappingTable
extends AbstractFilterableTupleTable
implements DatabaseTupleTable {
    private Database db;
    private static final String OBSERVATION_SET = "observation_set";
    private static final String STORE_MAPPING_CONFIRM_MAPPING = "store_mapping_confirm_mapping";
    private static final String STORE_MAPPING_SCORE = "store_mapping_score";
    private static final String STORE_MAPPING_ABSOLUTE_SCORE = "store_mapping_absolute_score";
    private static final List<String> NON_XREF_FIELDS = Arrays.asList("store_mapping_absolute_score", "store_mapping_score", "store_mapping_confirm_mapping");
    private final ValueConverter valueConverter;
    private Integer numberOfRows = null;
    private final DataSet dataSet;
    private List<Field> columns;

    public StoreMappingTable(String dataSetIdentifier, Database db) throws DatabaseException {
        this.dataSet = (DataSet)db.find(DataSet.class, new QueryRule[]{new QueryRule("Identifier", QueryRule.Operator.EQUALS, dataSetIdentifier)}).get(0);
        this.valueConverter = new ValueConverter(db);
        this.setDb(db);
    }

    public Iterator<Tuple> iterator() {
        ArrayList<KeyValueTuple> tuples = new ArrayList<KeyValueTuple>();
        try {
            ArrayList<String> observationSetIdentifiers = new ArrayList<String>();
            HashMap<Integer, KeyValueTuple> storeMapping = new HashMap<Integer, KeyValueTuple>();
            for (ObservationSet observation : this.db.find(ObservationSet.class, new QueryRule[]{new QueryRule("partOfDataSet_Identifier", QueryRule.Operator.EQUALS, this.dataSet.getIdentifier())})) {
                observationSetIdentifiers.add(observation.getIdentifier());
            }
            for (ObservedValue ov : this.db.find(ObservedValue.class, new QueryRule[]{new QueryRule("ObservationSet_Identifier", QueryRule.Operator.IN, observationSetIdentifiers)})) {
                KeyValueTuple tuple = null;
                Integer observationId = ov.getObservationSet_Id();
                tuple = storeMapping.containsKey(observationId) ? (KeyValueTuple)storeMapping.get(observationId) : new KeyValueTuple();
                if (NON_XREF_FIELDS.contains(ov.getFeature_Identifier())) {
                    tuple.set(ov.getFeature_Identifier(), (Object)this.valueConverter.toCell(ov.getValue()));
                } else {
                    Characteristic xrefCharacteristic = ((XrefValue)ov.getValue()).getValue();
                    tuple.set(ov.getFeature_Identifier(), (Object)xrefCharacteristic.getId());
                }
                if (tuple.get(OBSERVATION_SET) == null) {
                    tuple.set(OBSERVATION_SET, (Object)observationId);
                }
                storeMapping.put(observationId, tuple);
            }
            for (KeyValueTuple tuple : storeMapping.values()) {
                tuples.add(tuple);
            }
        }
        catch (Exception e) {
            new RuntimeException(e);
        }
        return tuples.iterator();
    }

    public Database getDb() {
        return this.db;
    }

    public void setDb(Database db) {
        this.db = db;
    }

    public List<Field> getAllColumns() throws TableException {
        if (this.columns == null) {
            this.initColumnsFromDb();
        }
        this.columns.add(new Field(OBSERVATION_SET));
        return Collections.unmodifiableList(this.columns);
    }

    private void initColumnsFromDb() throws TableException {
        try {
            Protocol protocol = this.dataSet.getProtocolUsed();
            if (protocol != null) {
                ArrayList<ObservableFeature> features = new ArrayList<ObservableFeature>();
                this.getFeatures(protocol, features);
                if (features != null && !features.isEmpty()) {
                    this.columns = new ArrayList<Field>(features.size());
                    for (ObservableFeature feature : features) {
                        FieldType fieldType = MolgenisFieldTypes.getType((String)feature.getDataType());
                        Field field = new Field(feature.getIdentifier());
                        field.setEntity(this.db.getMetaData().getEntity(ObservableFeature.class.getSimpleName()));
                        field.setLabel(feature.getName());
                        field.setType(fieldType);
                        field.setName(feature.getIdentifier());
                        MolgenisFieldTypes.FieldTypeEnum enumType = fieldType.getEnumType();
                        if (enumType.equals((Object)MolgenisFieldTypes.FieldTypeEnum.XREF) || enumType.equals((Object)MolgenisFieldTypes.FieldTypeEnum.MREF)) {
                            field.setXRefEntity(Characteristic.class.getSimpleName());
                            field.setXrefField("Name");
                        } else if (enumType.equals((Object)MolgenisFieldTypes.FieldTypeEnum.CATEGORICAL)) {
                            field.setXRefEntity(Category.class.getSimpleName());
                            field.setXrefField("Name");
                        }
                        this.columns.add(field);
                    }
                } else {
                    this.columns = Collections.emptyList();
                }
            }
        }
        catch (Exception e) {
            throw new TableException((Throwable)e);
        }
    }

    private void getFeatures(Protocol protocol, List<ObservableFeature> features) throws DatabaseException {
        features.addAll(protocol.getFeatures());
        for (Protocol subProtocol : protocol.getSubprotocols()) {
            this.getFeatures(subProtocol, features);
        }
    }

    public int getCount() throws TableException {
        if (this.numberOfRows == null) {
            try {
                List observationSets = this.db.find(ObservationSet.class, new QueryRule[]{new QueryRule("partOfDataSet_Identifier", QueryRule.Operator.EQUALS, this.dataSet.getIdentifier())});
                this.numberOfRows = observationSets.size();
            }
            catch (Exception e) {
                new RuntimeException(e);
            }
        }
        return this.numberOfRows;
    }
}

