/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.utils;

import java.util.ArrayList;
import java.util.Collections;

class TermComparison
implements Comparable<TermComparison> {
    private String ontologyTermSynonym;
    private String ontologyTerm;
    private Integer synonymLength;
    private Integer termLength;

    public static void main(String[] args) {
        ArrayList<TermComparison> lists = new ArrayList<TermComparison>();
        lists.add(new TermComparison("Total cholesterol", "Total Serum Cholesterol Measurement"));
        lists.add(new TermComparison("Total cholesterol", "Total cholesterol"));
        Collections.sort(lists);
        for (TermComparison term : lists) {
            System.out.println(term.getOntologyTermSynonym() + " : " + term.getOntologyTerm());
        }
    }

    public TermComparison(String ontologyTermSynonym, String ontologyTerm) {
        this.ontologyTermSynonym = ontologyTermSynonym;
        this.ontologyTerm = ontologyTerm;
        this.synonymLength = this.ontologyTermSynonym.split(" +").length;
        this.termLength = this.ontologyTerm.split(" +").length;
    }

    public String getOntologyTermSynonym() {
        return this.ontologyTermSynonym;
    }

    public String getOntologyTerm() {
        return this.ontologyTerm;
    }

    public Integer getLength() {
        return this.synonymLength;
    }

    public Integer getTermLength() {
        return this.termLength;
    }

    @Override
    public int compareTo(TermComparison other) {
        if (this.synonymLength.compareTo(other.getLength()) == 0) {
            return this.termLength.compareTo(other.getTermLength()) * -1;
        }
        return this.synonymLength.compareTo(other.getLength()) * -1;
    }
}

