/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.evaluation;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.Repository;
import org.molgenis.data.excel.ExcelRepositoryCollection;
import org.molgenis.data.excel.ExcelSheetWriter;
import org.molgenis.data.excel.ExcelWriter;
import org.molgenis.data.processor.CellProcessor;
import org.molgenis.data.processor.LowerCaseProcessor;
import org.molgenis.data.processor.TrimProcessor;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.framework.ui.MolgenisPluginController;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.search.Hit;
import org.molgenis.search.SearchRequest;
import org.molgenis.search.SearchResult;
import org.molgenis.search.SearchService;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.util.FileStore;
import org.molgenis.util.FileUploadUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/plugin/evaluation"})
public class EvaluationController
extends MolgenisPluginController {
    public static final String ID = "evaluation";
    public static final String URI = "/plugin/evaluation";
    private static final String PROTOCOL_IDENTIFIER = "store_mapping";
    private final SearchService searchService;
    private final DataService dataService;
    @Autowired
    private FileStore fileStore;

    @Autowired
    public EvaluationController(SearchService searchService, DataService dataService) {
        super(URI);
        if (searchService == null) {
            throw new IllegalArgumentException("SearchService is null");
        }
        if (dataService == null) {
            throw new IllegalArgumentException("Dataservice is null");
        }
        this.searchService = searchService;
        this.dataService = dataService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String init(@RequestParam(value="selectedDataSet", required=false) String selectedDataSetId, Model model) {
        Iterable allDataSets = this.dataService.findAll("DataSet", (Query)new QueryImpl(), DataSet.class);
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        for (DataSet dataSet : allDataSets) {
            if (selectedDataSetId == null) {
                selectedDataSetId = dataSet.getId().toString();
            }
            if (dataSet.getProtocolUsed().getIdentifier().equals(PROTOCOL_IDENTIFIER)) continue;
            dataSets.add(dataSet);
        }
        model.addAttribute("dataSets", dataSets);
        ArrayList<String> mappedDataSets = new ArrayList<String>();
        if (selectedDataSetId != null) {
            model.addAttribute("selectedDataSet", (Object)selectedDataSetId);
            Iterable it = this.dataService.findAll("DataSet", new QueryImpl().like("Identifier", (Object)selectedDataSetId), DataSet.class);
            for (DataSet dataSet : it) {
                String[] dataSetIds;
                if (!dataSet.getIdentifier().startsWith(SecurityUtils.getCurrentUsername() + "-" + selectedDataSetId) || (dataSetIds = dataSet.getIdentifier().toString().split("-")).length <= 1) continue;
                mappedDataSets.add(dataSetIds[2]);
            }
        }
        model.addAttribute("mappedDataSets", mappedDataSets);
        return "EvaluationPlugin";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/verify"}, method={RequestMethod.POST}, headers={"Content-Type=multipart/form-data"})
    public void verify(@RequestParam(value="selectedDataSet", required=false) String selectedDataSetId, @RequestParam Part file, HttpServletResponse response, Model model) throws IOException, InvalidFormatException {
        block35: {
            ExcelWriter excelWriterRanks = null;
            try {
                if (selectedDataSetId == null) break block35;
                String origFileName = FileUploadUtils.getOriginalFileName((Part)file);
                File uploadFile = this.fileStore.store(file.getInputStream(), origFileName);
                response.setContentType("application/vnd.ms-excel");
                response.addHeader("Content-Disposition", "attachment; filename=" + this.getCsvFileName(file.getName() + "-ranks"));
                excelWriterRanks = new ExcelWriter((OutputStream)response.getOutputStream());
                excelWriterRanks.addCellProcessor((CellProcessor)new LowerCaseProcessor(true, false));
                ExcelSheetWriter sheetWriterRank = null;
                ExcelSheetWriter sheetWriterRankStatistics = null;
                ExcelSheetWriter sheetWriteBiobankRanks = null;
                ExcelSheetWriter sheetWriteSpssInput = null;
                ExcelRepositoryCollection repositoryCollection = new ExcelRepositoryCollection(uploadFile, new CellProcessor[]{new TrimProcessor()});
                Repository inputSheet = repositoryCollection.getRepositoryByEntityName("Sheet1");
                try {
                    ArrayList<String> biobankNames = new ArrayList<String>();
                    for (AttributeMetaData attr : inputSheet.getEntityMetaData().getAttributes()) {
                        biobankNames.add(attr.getName());
                    }
                    String firstColumn = (String)biobankNames.get(0);
                    biobankNames.remove(0);
                    DataSet ds = (DataSet)this.dataService.findOne("DataSet", Integer.valueOf(Integer.parseInt(selectedDataSetId)), DataSet.class);
                    if (ds.getName().equalsIgnoreCase(firstColumn)) {
                        HashMap maunalMappings = new HashMap();
                        for (Entity row : inputSheet) {
                            String variableName = row.getString(firstColumn);
                            if (!maunalMappings.containsKey(variableName)) {
                                maunalMappings.put(variableName, new HashMap());
                            }
                            for (String biobank : biobankNames) {
                                if (row.get(biobank) == null) continue;
                                String mappingString = row.get(biobank).toString();
                                if (!maunalMappings.containsKey(variableName)) {
                                    maunalMappings.put(variableName, new HashMap());
                                }
                                if (!((Map)maunalMappings.get(variableName)).containsKey(biobank.toLowerCase())) {
                                    ((Map)maunalMappings.get(variableName)).put(biobank.toLowerCase(), new ArrayList());
                                }
                                ((List)((Map)maunalMappings.get(variableName)).get(biobank.toLowerCase())).addAll(Arrays.asList(mappingString.split(",")));
                            }
                        }
                        ArrayList<String> lowerCaseBiobankNames = new ArrayList<String>();
                        for (String element : biobankNames) {
                            lowerCaseBiobankNames.add(element.toLowerCase());
                        }
                        Iterable dataSets = this.dataService.findAll("DataSet", new QueryImpl().in("Name", lowerCaseBiobankNames), DataSet.class);
                        lowerCaseBiobankNames.add(0, firstColumn.toLowerCase());
                        sheetWriterRank = excelWriterRanks.createWritable("result", lowerCaseBiobankNames);
                        HashMap rankCollection = new HashMap();
                        ArrayList<Object> allRanks = new ArrayList<Object>();
                        for (Map.Entry entry : maunalMappings.entrySet()) {
                            String description;
                            String string = (String)entry.getKey();
                            ArrayList<String> ranks = new ArrayList<String>();
                            ranks.add(string);
                            Map mappingDetail = (Map)entry.getValue();
                            ObservableFeature feature = (ObservableFeature)this.dataService.findOne("ObservableFeature", new QueryImpl().eq("Name", (Object)string), ObservableFeature.class);
                            String string2 = description = feature == null ? "" : feature.getDescription();
                            if (!rankCollection.containsKey(description)) {
                                rankCollection.put(description, new HashMap());
                            }
                            if (feature == null) continue;
                            MapEntity row = new MapEntity();
                            row.set(firstColumn.toLowerCase(), (Object)description);
                            for (DataSet dataSet : dataSets) {
                                ArrayList<Integer> ranksBiobank = new ArrayList<Integer>();
                                if (mappingDetail.containsKey(dataSet.getName().toLowerCase())) {
                                    Map<String, Hit> mappedFeatureIds = this.findFeaturesFromIndex("name", (List)mappingDetail.get(dataSet.getName().toLowerCase()), dataSet.getId());
                                    String mappingDataSetIdentifier = SecurityUtils.getCurrentUsername() + "-" + selectedDataSetId + "-" + dataSet.getId();
                                    Query q = new QueryImpl().eq("store_mapping_feature", (Object)feature.getId()).pageSize(50).sort(new Sort(Sort.Direction.DESC, new String[]{"store_mapping_score"}));
                                    SearchRequest searchRequest = new SearchRequest(mappingDataSetIdentifier, q, null);
                                    SearchResult result = this.searchService.search(searchRequest);
                                    if (mappedFeatureIds.size() == 0) {
                                        row.set(dataSet.getName().toLowerCase(), (Object)"N/A2");
                                        continue;
                                    }
                                    ArrayList<String> ids = new ArrayList<String>();
                                    for (Hit hit : result.getSearchHits()) {
                                        Map columnValueMap = hit.getColumnValueMap();
                                        ids.add(columnValueMap.get("store_mapping_mapped_feature").toString());
                                    }
                                    Map<String, Hit> featureInfos = this.findFeaturesFromIndex("id", ids, dataSet.getId());
                                    String previousDescription = null;
                                    int rank = 0;
                                    for (Hit hit : result.getSearchHits()) {
                                        Map columnValueMap = hit.getColumnValueMap();
                                        String mappedFeatureId = columnValueMap.get("store_mapping_mapped_feature").toString();
                                        String mappedFeatureDescription = featureInfos.get(mappedFeatureId).getColumnValueMap().get("description").toString().replaceAll("[^0-9a-zA-Z ]", " ");
                                        ++rank;
                                        if (previousDescription != null && previousDescription.equalsIgnoreCase(mappedFeatureDescription)) {
                                            --rank;
                                        }
                                        if (mappedFeatureIds.containsKey(mappedFeatureId)) {
                                            ranksBiobank.add(rank);
                                            allRanks.add(rank);
                                            mappedFeatureIds.remove(mappedFeatureId);
                                        }
                                        previousDescription = mappedFeatureDescription;
                                    }
                                    if (mappedFeatureIds.size() == 0) {
                                        String output = StringUtils.join(ranksBiobank, (char)',');
                                        if (ranksBiobank.size() > 1) {
                                            output = output + " (" + this.averageRank(ranksBiobank) + ")";
                                        }
                                        row.set(dataSet.getName().toLowerCase(), (Object)output);
                                    } else {
                                        for (int i = 0; i < mappedFeatureIds.size(); ++i) {
                                            allRanks.add("Not mapped");
                                        }
                                        row.set(dataSet.getName().toLowerCase(), (Object)"Not mapped");
                                        ranksBiobank.clear();
                                    }
                                } else {
                                    row.set(dataSet.getName().toLowerCase(), (Object)"N/A1");
                                }
                                ((Map)rankCollection.get(description)).put(dataSet.getName().toLowerCase(), ranksBiobank);
                            }
                            sheetWriterRank.add((Entity)row);
                        }
                        HashMap rankCollectionPerBiobank = new HashMap();
                        sheetWriterRankStatistics = excelWriterRanks.createWritable("rank statistics", Arrays.asList(firstColumn.toLowerCase(), "average rank", "round-up rank", "median rank", "minium", "maximum"));
                        for (Map.Entry entry : rankCollection.entrySet()) {
                            String variableName = (String)entry.getKey();
                            MapEntity row = new MapEntity();
                            row.set(firstColumn.toLowerCase(), (Object)variableName);
                            ArrayList<Integer> rankAllBiobanks = new ArrayList<Integer>();
                            for (Map.Entry rankBiobanks : ((Map)entry.getValue()).entrySet()) {
                                if (!rankCollectionPerBiobank.containsKey(rankBiobanks.getKey())) {
                                    rankCollectionPerBiobank.put(rankBiobanks.getKey(), new ArrayList());
                                }
                                ((List)rankCollectionPerBiobank.get(rankBiobanks.getKey())).addAll((Collection)rankBiobanks.getValue());
                                rankAllBiobanks.addAll((Collection)rankBiobanks.getValue());
                            }
                            row.set("average rank", (Object)this.averageRank(rankAllBiobanks));
                            row.set("round-up rank", (Object)Math.ceil(this.averageRank(rankAllBiobanks)));
                            Collections.sort(rankAllBiobanks);
                            if (!rankAllBiobanks.isEmpty()) {
                                row.set("minium", rankAllBiobanks.get(0));
                                row.set("maximum", rankAllBiobanks.get(rankAllBiobanks.size() - 1));
                                double medianRank = 0.0;
                                medianRank = rankAllBiobanks.size() % 2 == 0 ? (double)((Integer)rankAllBiobanks.get(rankAllBiobanks.size() / 2 - 1) + (Integer)rankAllBiobanks.get(rankAllBiobanks.size() / 2)) / 2.0 : (double)((Integer)rankAllBiobanks.get(rankAllBiobanks.size() / 2)).intValue();
                                row.set("median rank", (Object)medianRank);
                            }
                            sheetWriterRankStatistics.add((Entity)row);
                        }
                        lowerCaseBiobankNames.remove(0);
                        sheetWriteBiobankRanks = excelWriterRanks.createWritable("biobank average ranks", lowerCaseBiobankNames);
                        MapEntity entity = new MapEntity();
                        for (Map.Entry entry : rankCollectionPerBiobank.entrySet()) {
                            entity.set((String)entry.getKey(), (Object)this.averageRank((List)entry.getValue()));
                        }
                        sheetWriteBiobankRanks.add((Entity)entity);
                        sheetWriteSpssInput = excelWriterRanks.createWritable("spss ranks", Arrays.asList("rank"));
                        for (Map.Entry entry : allRanks) {
                            MapEntity entity2 = new MapEntity("rank", entry);
                            sheetWriteSpssInput.add((Entity)entity2);
                        }
                    }
                }
                finally {
                    inputSheet.close();
                }
            }
            finally {
                if (excelWriterRanks != null) {
                    IOUtils.closeQuietly(excelWriterRanks);
                }
            }
        }
    }

    private double averageRank(List<Integer> ranks) {
        double result = 0.0;
        for (Integer rank : ranks) {
            result += (double)rank.intValue();
        }
        DecimalFormat df = new DecimalFormat("#0.0");
        return ranks.size() == 0 ? -1.0 : Double.parseDouble(df.format(result / (double)ranks.size()));
    }

    private Map<String, Hit> findFeaturesFromIndex(String field, List<String> featureNames, Integer dataSetId) {
        QueryImpl q = new QueryImpl();
        q.pageSize(10000);
        for (String featureName : featureNames) {
            if (q.getRules().size() > 0) {
                q.addRule(new QueryRule(QueryRule.Operator.OR));
            }
            q.addRule(new QueryRule(field, QueryRule.Operator.EQUALS, featureName));
        }
        SearchResult result = this.searchService.search(new SearchRequest("protocolTree-" + dataSetId, (Query)q, null));
        HashMap<String, Hit> featureIds = new HashMap<String, Hit>();
        for (Hit hit : result.getSearchHits()) {
            featureIds.put(hit.getColumnValueMap().get("id").toString(), hit);
        }
        return featureIds;
    }

    private String getCsvFileName(String dataSetName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dataSetName + "_" + dateFormat.format(new Date()) + ".xls";
    }
}

