/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.mesh;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.molgenis.omx.biobankconnect.mesh.Concept;
import org.molgenis.omx.biobankconnect.mesh.DescriptorRecord;
import org.molgenis.omx.biobankconnect.mesh.DescriptorRecordSet;
import org.molgenis.omx.biobankconnect.mesh.MeshTerm;
import org.molgenis.omx.biobankconnect.mesh.Term;

public class MeshLoader {
    private MeshTerm topNode = new MeshTerm("Thing", null);

    public MeshLoader(File meshFile) throws JAXBException {
        HashMap map = new HashMap();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DescriptorRecordSet.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        DescriptorRecordSet descriptorRecordSet = (DescriptorRecordSet)jaxbUnmarshaller.unmarshal(meshFile);
        for (DescriptorRecord descriptor : descriptorRecordSet.getDescriptorRecords()) {
            for (String path : descriptor.getTreeNumberList().getTreeNumbers()) {
                String[] nodes = path.split("\\.");
                if (!map.containsKey(nodes.length)) {
                    map.put(nodes.length, new HashSet());
                }
                ((Set)map.get(nodes.length)).add(descriptor);
            }
        }
        HashSet<String> paths = new HashSet<String>();
        for (Map.Entry entry : map.entrySet()) {
            for (DescriptorRecord descriptor : (Set)entry.getValue()) {
                String descriptorLabel = descriptor.getDescriptorName().getName();
                for (String path : descriptor.getTreeNumberList().getTreeNumbers()) {
                    HashSet<String> synonyms = new HashSet<String>();
                    for (Concept concept : descriptor.getConceptList().getConcepts()) {
                        for (Term term : concept.getTermList().getTerms()) {
                            synonyms.add(term.getName());
                        }
                    }
                    synonyms.remove(descriptorLabel);
                    MeshTerm parentNode = null;
                    String[] nodes = path.split("\\.");
                    if (nodes.length == 1) {
                        if (!paths.contains(path)) {
                            parentNode = this.topNode;
                        }
                    } else if (nodes.length == (Integer)entry.getKey()) {
                        StringBuilder oldPath = new StringBuilder();
                        for (int i = 0; i < nodes.length - 1; ++i) {
                            oldPath.append(nodes[i]).append('.');
                        }
                        oldPath.delete(oldPath.length() - 1, oldPath.length());
                        parentNode = paths.contains(oldPath.toString()) ? (MeshTerm)this.topNode.get(oldPath.toString()) : this.topNode;
                    }
                    MeshTerm subTerm = new MeshTerm(path, descriptorLabel, parentNode);
                    subTerm.setDefinition(descriptor.getAnnotation());
                    subTerm.setSynonyms(synonyms);
                    paths.add(path);
                }
            }
        }
    }

    public MeshTerm getTopNode() {
        return this.topNode;
    }
}

