/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.ontologyindexer;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.elasticsearch.common.collect.Iterables;
import org.molgenis.data.DataService;
import org.molgenis.data.Repository;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.omx.biobankconnect.ontologyindexer.OntologyIndexer;
import org.molgenis.omx.biobankconnect.utils.OntologyLoader;
import org.molgenis.omx.biobankconnect.utils.OntologyRepository;
import org.molgenis.omx.biobankconnect.utils.OntologyTermRepository;
import org.molgenis.omx.observ.target.Ontology;
import org.molgenis.omx.observ.target.OntologyTerm;
import org.molgenis.search.SearchService;
import org.molgenis.security.runas.RunAsSystem;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;

public class AsyncOntologyIndexer
implements OntologyIndexer,
InitializingBean {
    @Autowired
    private DataService dataService;
    private SearchService searchService;
    private String ontologyUri = null;
    private boolean isCorrectOntology = true;
    private static final Logger logger = Logger.getLogger(AsyncOntologyIndexer.class);
    private final AtomicInteger runningIndexProcesses = new AtomicInteger();

    @Autowired
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.searchService == null) {
            throw new IllegalArgumentException("Missing bean of type SearchService");
        }
    }

    @Override
    public boolean isIndexingRunning() {
        return this.runningIndexProcesses.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async
    @RunAsSystem
    public void index(String ontologyName, File ontologyFile) {
        this.isCorrectOntology = true;
        this.runningIndexProcesses.incrementAndGet();
        try {
            OntologyLoader model = new OntologyLoader(ontologyName, ontologyFile);
            this.ontologyUri = model.getOntologyIRI() == null ? "" : model.getOntologyIRI();
            this.searchService.indexRepository((Repository)new OntologyRepository(model, "ontology-" + this.ontologyUri));
            this.searchService.indexRepository((Repository)new OntologyTermRepository(model, "ontologyTerm-" + this.ontologyUri));
        }
        catch (OWLOntologyCreationException e) {
            this.isCorrectOntology = false;
            logger.error((Object)"Exception imported file is not a valid ontology", (Throwable)e);
        }
        finally {
            this.runningIndexProcesses.decrementAndGet();
            this.ontologyUri = null;
        }
    }

    @Override
    @RunAsSystem
    public void removeOntology(String ontologyURI) {
        Iterable ontologies = this.dataService.findAll("Ontology", new QueryImpl().eq("Identifier", (Object)ontologyURI), Ontology.class);
        if (Iterables.size((Iterable)ontologies) > 0) {
            for (Ontology ontology : ontologies) {
                Iterable ontologyTerms = this.dataService.findAll("OntologyTerm", new QueryImpl().eq("ontology", (Object)ontology), OntologyTerm.class);
                if (Iterables.size((Iterable)ontologyTerms) <= 0) continue;
                this.dataService.delete("OntologyTerm", ontologyTerms);
            }
            this.dataService.delete("Ontology", ontologies);
        }
        this.searchService.deleteDocumentsByType("ontology-" + ontologyURI);
        this.searchService.deleteDocumentsByType("ontologyTerm-" + ontologyURI);
    }

    @Override
    public String getOntologyUri() {
        return this.ontologyUri;
    }

    @Override
    public boolean isCorrectOntology() {
        return this.isCorrectOntology;
    }
}

