/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.ontologymatcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.collect.Lists;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.DataConverter;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.Repository;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.omx.biobankconnect.ontologymatcher.OntologyMatcher;
import org.molgenis.omx.biobankconnect.utils.NGramMatchingModel;
import org.molgenis.omx.biobankconnect.utils.StoreMappingRepository;
import org.molgenis.omx.biobankconnect.wizard.CurrentUserStatus;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.omx.observ.ObservationSet;
import org.molgenis.omx.observ.ObservedValue;
import org.molgenis.omx.observ.Protocol;
import org.molgenis.omx.observ.target.OntologyTerm;
import org.molgenis.omx.observ.value.BoolValue;
import org.molgenis.omx.observ.value.DecimalValue;
import org.molgenis.omx.observ.value.IntValue;
import org.molgenis.omx.observ.value.Value;
import org.molgenis.search.Hit;
import org.molgenis.search.MultiSearchRequest;
import org.molgenis.search.SearchRequest;
import org.molgenis.search.SearchResult;
import org.molgenis.search.SearchService;
import org.molgenis.security.runas.RunAsSystem;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.transaction.annotation.Transactional;
import org.tartarus.snowball.ext.PorterStemmer;

public class AsyncOntologyMatcher
implements OntologyMatcher,
InitializingBean {
    private static final Logger logger = Logger.getLogger(AsyncOntologyMatcher.class);
    private static final String PROTOCOL_IDENTIFIER = "store_mapping";
    private static final String STORE_MAPPING_FEATURE = "store_mapping_feature";
    private static final String STORE_MAPPING_MAPPED_FEATURE = "store_mapping_mapped_feature";
    private static final String STORE_MAPPING_CONFIRM_MAPPING = "store_mapping_confirm_mapping";
    private static final String STORE_MAPPING_SCORE = "store_mapping_score";
    private static final String STORE_MAPPING_ABSOLUTE_SCORE = "store_mapping_absolute_score";
    private static final String CATALOGUE_PREFIX = "protocolTree-";
    private static final String FEATURE_CATEGORY = "featureCategory-";
    private static final String FIELD_DESCRIPTION_STOPWORDS = "descriptionStopwords";
    private static final String FIELD_BOOST_ONTOLOGYTERM = "boostOntologyTerms";
    private static final String ONTOLOGY_IRI = "ontologyIRI";
    private static final String ONTOLOGY_LABEL = "ontologyLabel";
    private static final String OBSERVATION_SET = "observation_set";
    private static final String ONTOLOGYTERM_SYNONYM = "ontologyTermSynonym";
    private static final String ONTOLOGY_TERM = "ontologyTerm";
    private static final String ONTOLOGY_TERM_IRI = "ontologyTermIRI";
    private static final String ALTERNATIVE_DEFINITION = "alternativeDefinition";
    private static final String NODE_PATH = "nodePath";
    private static final String ENTITY_ID = "id";
    private static final String LUCENE_SCORE = "score";
    private static final String ENTITY_TYPE = "type";
    private static final AtomicInteger runningProcesses = new AtomicInteger();
    private static final PorterStemmer stemmer = new PorterStemmer();
    @Autowired
    private DataService dataService;
    @Autowired
    private CurrentUserStatus currentUserStatus;
    private SearchService searchService;

    @Autowired
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.searchService == null) {
            throw new IllegalArgumentException("Missing bean of type SearchService");
        }
    }

    @Override
    public boolean isRunning() {
        return runningProcesses.get() != 0;
    }

    @Override
    public Integer matchPercentage(String currentUserName) {
        return this.currentUserStatus.getPercentageOfProcessForUser(currentUserName);
    }

    @Override
    public void deleteDocumentByIds(String documentType, List<String> documentIds) {
        this.searchService.deleteDocumentByIds(documentType, documentIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RunAsSystem
    @Async
    @Transactional
    public void match(String userName, Integer selectedDataSet, List<Integer> dataSetsToMatch, Integer featureId) {
        runningProcesses.incrementAndGet();
        this.currentUserStatus.setUserIsRunning(userName, true);
        dataSetsToMatch.remove(selectedDataSet);
        ArrayList<ObservationSet> listOfNewObservationSets = new ArrayList<ObservationSet>();
        ArrayList<Object> listOfNewObservedValues = new ArrayList<Object>();
        HashMap observationValuesPerDataSet = new HashMap();
        try {
            QueryImpl q = new QueryImpl();
            q.pageSize(100001);
            if (featureId == null) {
                q.addRule(new QueryRule(ENTITY_TYPE, QueryRule.Operator.SEARCH, ObservableFeature.class.getSimpleName().toLowerCase()));
            } else {
                q.addRule(new QueryRule(ENTITY_ID, QueryRule.Operator.EQUALS, (Object)featureId));
            }
            SearchResult result = this.searchService.search(new SearchRequest(CATALOGUE_PREFIX + selectedDataSet, (Query)q, null));
            this.currentUserStatus.setUserCurrentStage(userName, CurrentUserStatus.STAGE.DeleteMapping);
            this.preprocessing(userName, featureId, selectedDataSet, dataSetsToMatch);
            this.currentUserStatus.setUserCurrentStage(userName, CurrentUserStatus.STAGE.CreateMapping);
            this.currentUserStatus.setUserTotalNumberOfQueries(userName, result.getTotalHitCount());
            for (Hit hit : result.getSearchHits()) {
                Map columnValueMap = hit.getColumnValueMap();
                Integer n = DataConverter.toInt(columnValueMap.get(ENTITY_ID));
                ObservableFeature feature = (ObservableFeature)this.dataService.findOne("ObservableFeature", n, ObservableFeature.class);
                if (feature == null) continue;
                HashSet<String> boostedOntologyTermUris = new HashSet<String>();
                for (String ontolgoyTermUri : columnValueMap.get(FIELD_BOOST_ONTOLOGYTERM).toString().split(",")) {
                    boostedOntologyTermUris.add(ontolgoyTermUri);
                }
                String description = feature.getDescription() == null || feature.getDescription().isEmpty() ? feature.getName() : feature.getDescription();
                description = description.replaceAll("[^a-zA-Z0-9 ]", " ");
                List definitions = feature.getDefinitions();
                ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
                if (definitions != null && definitions.size() > 0) {
                    Map<String, OntologyTermContainer> ontologyTermContainers = this.collectOntologyTermInfo(definitions, boostedOntologyTermUris);
                    rules.addAll(this.makeQueryForOntologyTerms(this.createQueryRules(description, ontologyTermContainers)));
                    for (Map<Integer, List<BoostTermContainer>> alternativeDefinition : this.addAlternativeDefinition(ontologyTermContainers)) {
                        QueryRule queryRule = new QueryRule(this.makeQueryForOntologyTerms(alternativeDefinition));
                        queryRule.setOperator(QueryRule.Operator.DIS_MAX);
                        queryRule.setValue((Object)0.6);
                        rules.add(queryRule);
                    }
                } else {
                    rules.add(new QueryRule(FIELD_DESCRIPTION_STOPWORDS, QueryRule.Operator.SEARCH, description));
                }
                QueryRule finalQueryRule = new QueryRule(rules);
                finalQueryRule.setOperator(QueryRule.Operator.DIS_MAX);
                QueryImpl finalQuery = new QueryImpl();
                finalQuery.addRule(finalQueryRule);
                HashSet<Integer> mappedFeatureIds = new HashSet<Integer>();
                for (Integer dataSetId : dataSetsToMatch) {
                    StringBuilder dataSetIdentifier = new StringBuilder();
                    dataSetIdentifier.append(userName).append('-').append(selectedDataSet).append('-').append(dataSetId);
                    if (featureId != null) {
                        observationValuesPerDataSet.put(dataSetIdentifier.toString(), new ArrayList());
                    }
                    Iterator<Hit> mappedFeatureHits = this.searchDisMaxQuery(dataSetId.toString(), (Query)finalQuery);
                    while (mappedFeatureHits.hasNext()) {
                        Hit mappedFeatureHit = mappedFeatureHits.next();
                        Map columValueMap = mappedFeatureHit.getColumnValueMap();
                        Integer mappedId = Integer.parseInt(columValueMap.get(ENTITY_ID).toString());
                        Double score = Double.parseDouble(columValueMap.get(LUCENE_SCORE).toString());
                        if (mappedFeatureIds.contains(mappedId)) continue;
                        mappedFeatureIds.add(mappedId);
                        ObservationSet observation = new ObservationSet();
                        observation.setIdentifier(userName + "-" + feature.getId() + "-" + mappedId + "-identifier");
                        DataSet ds = (DataSet)this.dataService.findOne("DataSet", new QueryImpl().eq("Identifier", (Object)dataSetIdentifier.toString()), DataSet.class);
                        observation.setPartOfDataSet(ds);
                        listOfNewObservationSets.add(observation);
                        IntValue xrefForFeature = new IntValue();
                        xrefForFeature.setValue(feature.getId());
                        this.dataService.add("IntValue", (Entity)xrefForFeature);
                        ObservedValue valueForFeature = new ObservedValue();
                        valueForFeature.setObservationSet(observation);
                        ObservableFeature smf = (ObservableFeature)this.dataService.findOne("ObservableFeature", new QueryImpl().eq("Identifier", (Object)STORE_MAPPING_FEATURE), ObservableFeature.class);
                        valueForFeature.setFeature(smf);
                        valueForFeature.setValue((Value)xrefForFeature);
                        listOfNewObservedValues.add(valueForFeature);
                        if (featureId != null) {
                            ((List)observationValuesPerDataSet.get(dataSetIdentifier.toString())).add(valueForFeature);
                        }
                        IntValue xrefForMappedFeature = new IntValue();
                        xrefForMappedFeature.setValue(mappedId);
                        this.dataService.add("IntValue", (Entity)xrefForMappedFeature);
                        ObservedValue valueForMappedFeature = new ObservedValue();
                        ObservableFeature smmf = (ObservableFeature)this.dataService.findOne("ObservableFeature", new QueryImpl().eq("Identifier", (Object)STORE_MAPPING_MAPPED_FEATURE), ObservableFeature.class);
                        valueForMappedFeature.setFeature(smmf);
                        valueForMappedFeature.setObservationSet(observation);
                        valueForMappedFeature.setValue((Value)xrefForMappedFeature);
                        listOfNewObservedValues.add(valueForMappedFeature);
                        if (featureId != null) {
                            ((List)observationValuesPerDataSet.get(dataSetIdentifier.toString())).add(valueForMappedFeature);
                        }
                        DecimalValue decimalForScore = new DecimalValue();
                        decimalForScore.setValue(score);
                        this.dataService.add("DecimalValue", (Entity)decimalForScore);
                        ObservedValue valueForMappedFeatureScore = new ObservedValue();
                        ObservableFeature smc = (ObservableFeature)this.dataService.findOne("ObservableFeature", new QueryImpl().eq("Identifier", (Object)STORE_MAPPING_SCORE), ObservableFeature.class);
                        valueForMappedFeatureScore.setFeature(smc);
                        valueForMappedFeatureScore.setObservationSet(observation);
                        valueForMappedFeatureScore.setValue((Value)decimalForScore);
                        listOfNewObservedValues.add(valueForMappedFeatureScore);
                        if (featureId != null) {
                            ((List)observationValuesPerDataSet.get(dataSetIdentifier.toString())).add(valueForMappedFeatureScore);
                        }
                        BoolValue boolValue = new BoolValue();
                        boolValue.setValue(Boolean.valueOf(false));
                        this.dataService.add("BoolValue", (Entity)boolValue);
                        ObservedValue confirmMappingValue = new ObservedValue();
                        ObservableFeature scm = (ObservableFeature)this.dataService.findOne("ObservableFeature", new QueryImpl().eq("Identifier", (Object)STORE_MAPPING_CONFIRM_MAPPING), ObservableFeature.class);
                        confirmMappingValue.setFeature(scm);
                        confirmMappingValue.setObservationSet(observation);
                        confirmMappingValue.setValue((Value)boolValue);
                        listOfNewObservedValues.add(confirmMappingValue);
                        if (featureId == null) continue;
                        ((List)observationValuesPerDataSet.get(dataSetIdentifier.toString())).add(confirmMappingValue);
                    }
                }
                this.currentUserStatus.incrementFinishedNumberOfQueries(userName);
            }
            this.dataService.add("ObservationSet", listOfNewObservationSets);
            HashSet<Integer> processedObservationSets = new HashSet<Integer>();
            ArrayList<ObservedValue> valuesForObservationSets = new ArrayList<ObservedValue>();
            for (ObservedValue observedValue : listOfNewObservedValues) {
                ObservationSet observationSet = observedValue.getObservationSet();
                Integer observationSetId = observationSet.getId();
                if (processedObservationSets.contains(observationSetId)) continue;
                processedObservationSets.add(observationSetId);
                IntValue observationSetIntValue = new IntValue();
                observationSetIntValue.setValue(observationSetId);
                this.dataService.add("IntValue", (Entity)observationSetIntValue);
                ObservedValue valueForObservationSet = new ObservedValue();
                ObservableFeature observationSetFeature = (ObservableFeature)this.dataService.findOne("ObservableFeature", new QueryImpl().eq("Identifier", (Object)OBSERVATION_SET), ObservableFeature.class);
                valueForObservationSet.setFeature(observationSetFeature);
                valueForObservationSet.setObservationSet(observationSet);
                valueForObservationSet.setValue((Value)observationSetIntValue);
                valuesForObservationSets.add(valueForObservationSet);
                if (!observationValuesPerDataSet.containsKey(observationSet.getPartOfDataSet().getIdentifier())) continue;
                ((List)observationValuesPerDataSet.get(observationSet.getPartOfDataSet().getIdentifier())).add(valueForObservationSet);
            }
            listOfNewObservedValues.addAll(valuesForObservationSets);
            this.dataService.add("ObservedValue", listOfNewObservedValues);
            this.currentUserStatus.setUserCurrentStage(userName, CurrentUserStatus.STAGE.StoreMapping);
            this.currentUserStatus.setUserTotalNumberOfQueries(userName, Long.valueOf(dataSetsToMatch.size()));
            this.dataService.getCrudRepository("DataSet").flush();
            if (featureId != null) {
                for (Map.Entry entry : observationValuesPerDataSet.entrySet()) {
                    DataSet dataSet = (DataSet)this.dataService.findOne("DataSet", new QueryImpl().eq("Identifier", entry.getKey()), DataSet.class);
                    this.searchService.updateRepositoryIndex((Repository)new StoreMappingRepository(dataSet, (List)entry.getValue(), this.dataService));
                    this.currentUserStatus.incrementFinishedNumberOfQueries(userName);
                }
            } else {
                for (Integer n : dataSetsToMatch) {
                    StringBuilder dataSetIdentifier = new StringBuilder();
                    dataSetIdentifier.append(userName).append('-').append(selectedDataSet).append('-').append(n);
                    DataSet dataSet = (DataSet)this.dataService.findOne("DataSet", new QueryImpl().eq("Identifier", (Object)dataSetIdentifier), DataSet.class);
                    this.searchService.indexRepository((Repository)new StoreMappingRepository(dataSet, this.dataService));
                    this.currentUserStatus.incrementFinishedNumberOfQueries(userName);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception the matching process has failed!", (Throwable)e);
        }
        finally {
            runningProcesses.decrementAndGet();
            this.currentUserStatus.setUserIsRunning(userName, false);
        }
    }

    private void preprocessing(String userName, Integer featureId, Integer selectedDataSet, List<Integer> dataSetsToMatch) {
        ArrayList<String> dataSetsForMapping = new ArrayList<String>();
        for (Integer catalogueId : dataSetsToMatch) {
            StringBuilder dataSetIdentifier = new StringBuilder();
            dataSetIdentifier.append(userName).append('-').append(selectedDataSet).append('-').append(catalogueId);
            dataSetsForMapping.add(dataSetIdentifier.toString());
        }
        if (featureId == null) {
            this.createMappingStore(userName, selectedDataSet, dataSetsToMatch);
            this.deleteExistingRecords(userName, dataSetsForMapping);
        } else {
            this.removeExistingMappings(featureId, dataSetsForMapping);
        }
    }

    private void deleteExistingRecords(String userName, List<String> dataSetsForMapping) {
        this.currentUserStatus.setUserTotalNumberOfQueries(userName, Long.valueOf(dataSetsForMapping.size()));
        Iterable dataSets = this.dataService.findAll("DataSet", new QueryImpl().in("Identifier", dataSetsForMapping), DataSet.class);
        for (DataSet dataSet : dataSets) {
            Iterable listOfObservationSets = this.dataService.findAll("ObservationSet", new QueryImpl().eq("partOfDataSet", (Object)dataSet), ObservationSet.class);
            if (Iterables.size((Iterable)listOfObservationSets) > 0) {
                Iterable listOfObservedValues = this.dataService.findAll("ObservedValue", new QueryImpl().in("ObservationSet", (Iterable)Lists.newArrayList((Iterable)listOfObservationSets)), ObservedValue.class);
                if (Iterables.size((Iterable)listOfObservedValues) > 0) {
                    this.dataService.delete("ObservedValue", listOfObservedValues);
                }
                this.dataService.delete("ObservationSet", listOfObservationSets);
            }
            this.currentUserStatus.incrementFinishedNumberOfQueries(userName);
        }
    }

    private void removeExistingMappings(Integer featureId, List<String> dataSetsForMapping) {
        ArrayList<Integer> observationSets = new ArrayList<Integer>();
        for (String dataSet : dataSetsForMapping) {
            QueryImpl q = new QueryImpl();
            q.pageSize(100000);
            q.addRule(new QueryRule(STORE_MAPPING_FEATURE, QueryRule.Operator.EQUALS, (Object)featureId));
            SearchRequest request = new SearchRequest(dataSet, (Query)q, null);
            SearchResult searchResult = this.searchService.search(request);
            ArrayList<String> indexIds = new ArrayList<String>();
            for (Hit hit : searchResult.getSearchHits()) {
                Map columnValueMap = hit.getColumnValueMap();
                indexIds.add(hit.getId());
                observationSets.add(Integer.parseInt(columnValueMap.get(OBSERVATION_SET).toString()));
            }
            this.searchService.deleteDocumentByIds(dataSet, indexIds);
        }
        if (observationSets.size() > 0) {
            Iterable existingObservationSets = this.dataService.findAll("ObservationSet", new QueryImpl().in(ENTITY_ID, observationSets), ObservationSet.class);
            Iterable existingObservedValues = this.dataService.findAll("ObservedValue", new QueryImpl().in("ObservationSet", (Iterable)Lists.newArrayList((Iterable)existingObservationSets)), ObservedValue.class);
            if (Iterables.size((Iterable)existingObservedValues) > 0) {
                this.dataService.delete("ObservedValue", existingObservedValues);
            }
            if (Iterables.size((Iterable)existingObservationSets) > 0) {
                this.dataService.delete("ObservationSet", existingObservationSets);
            }
        }
    }

    private List<QueryRule> makeQueryForOntologyTerms(Map<Integer, List<BoostTermContainer>> position) {
        boolean boostDesccription = false;
        ArrayList<QueryRule> allQueries = new ArrayList<QueryRule>();
        ArrayList<QueryRule> queryRules = new ArrayList<QueryRule>();
        HashMap<Integer, Boolean> boostIndex = new HashMap<Integer, Boolean>();
        for (Map.Entry<Integer, List<BoostTermContainer>> entry : position.entrySet()) {
            Integer index = entry.getKey();
            if (index >= 0) {
                boolean boost = false;
                ArrayList<QueryRule> subQueries = new ArrayList<QueryRule>();
                for (BoostTermContainer boostTermContainer : entry.getValue()) {
                    ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
                    for (String term : boostTermContainer.getTerms()) {
                        rules.add(new QueryRule(FIELD_DESCRIPTION_STOPWORDS, QueryRule.Operator.SEARCH, term.trim()));
                        rules.add(new QueryRule("description", QueryRule.Operator.SEARCH, term.trim()));
                    }
                    if (!boost) {
                        boost = boostTermContainer.isBoost();
                    }
                    QueryRule queryRule = new QueryRule(rules);
                    queryRule.setOperator(QueryRule.Operator.DIS_MAX);
                    queryRule.setValue((Object)(boostTermContainer.isBoost() ? Integer.valueOf(10) : null));
                    subQueries.add(queryRule);
                }
                if (!boostIndex.containsKey(index)) {
                    boostIndex.put(index, boost);
                } else if (!((Boolean)boostIndex.get(index)).booleanValue()) {
                    boostIndex.put(index, boost);
                }
                QueryRule queryRule = null;
                if (subQueries.size() == 1) {
                    queryRule = (QueryRule)subQueries.get(0);
                } else {
                    queryRule = new QueryRule(subQueries);
                    queryRule.setOperator(QueryRule.Operator.DIS_MAX);
                    queryRule.setValue((Object)(boost ? Integer.valueOf(10) : null));
                }
                queryRules.add(queryRule);
                if (boostDesccription) continue;
                boostDesccription = boost;
                continue;
            }
            if (index == -1) {
                for (BoostTermContainer boostTermContainer : entry.getValue()) {
                    if (boostTermContainer.getTerms().size() <= 0) continue;
                    ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
                    for (String term : boostTermContainer.getTerms()) {
                        if (term.isEmpty()) continue;
                        rules.add(new QueryRule(FIELD_DESCRIPTION_STOPWORDS, QueryRule.Operator.SEARCH, term.trim()));
                        rules.add(new QueryRule("description", QueryRule.Operator.SEARCH, term.trim()));
                    }
                    QueryRule queryRule = new QueryRule(rules);
                    queryRule.setOperator(QueryRule.Operator.DIS_MAX);
                    queryRule.setValue((Object)(boostTermContainer.isBoost() ? Integer.valueOf(10) : null));
                    allQueries.add(queryRule);
                    if (boostDesccription) continue;
                    boostDesccription = boostTermContainer.isBoost();
                }
                continue;
            }
            for (BoostTermContainer boostTermContainer : entry.getValue()) {
                StringBuilder boostedSynonym = new StringBuilder();
                ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
                for (String term : boostTermContainer.getTerms()) {
                    if (term.isEmpty()) continue;
                    int count = 0;
                    if (boostDesccription) {
                        for (String eachToken : term.split(" +")) {
                            if (boostedSynonym.length() != 0) {
                                boostedSynonym.append(' ');
                            }
                            boostedSynonym.append(eachToken);
                            if (boostIndex.containsKey(count) && ((Boolean)boostIndex.get(count)).booleanValue()) {
                                boostedSynonym.append('^').append(10);
                            }
                            ++count;
                        }
                    } else {
                        boostedSynonym.append(term);
                    }
                    rules.add(new QueryRule(FIELD_DESCRIPTION_STOPWORDS, QueryRule.Operator.SEARCH, boostedSynonym.toString()));
                    rules.add(new QueryRule("description", QueryRule.Operator.SEARCH, boostedSynonym.toString()));
                }
                QueryRule queryRule = new QueryRule(rules);
                queryRule.setOperator(QueryRule.Operator.DIS_MAX);
                queryRule.setValue((Object)(boostDesccription || boostTermContainer.isBoost() ? Double.valueOf(1.5) : null));
                allQueries.add(queryRule);
            }
        }
        if (queryRules.size() > 0) {
            QueryRule combinedQuery = null;
            if (queryRules.size() != 1) {
                combinedQuery = new QueryRule(queryRules);
                combinedQuery.setOperator(QueryRule.Operator.SHOULD);
                allQueries.add(combinedQuery);
            } else {
                allQueries.add((QueryRule)queryRules.get(0));
            }
        }
        return allQueries;
    }

    private Iterator<Hit> searchDisMaxQuery(String dataSetId, Query q) {
        SearchResult result = null;
        try {
            q.pageSize(50);
            MultiSearchRequest request = new MultiSearchRequest(Arrays.asList(CATALOGUE_PREFIX + dataSetId, FEATURE_CATEGORY + dataSetId), q, null);
            result = this.searchService.multiSearch(request);
        }
        catch (Exception e) {
            result = new SearchResult(e.getMessage());
            logger.error((Object)("Exception failed to search the request " + result), (Throwable)e);
        }
        return result.iterator();
    }

    private Map<String, OntologyTermContainer> collectOntologyTermInfo(List<OntologyTerm> definitions, Set<String> boostedOntologyTermUris) {
        HashMap<String, String> validOntologyTerm = new HashMap<String, String>();
        HashMap<String, OntologyTermContainer> totalHits = new HashMap<String, OntologyTermContainer>();
        ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
        for (OntologyTerm ot : definitions) {
            if (rules.size() != 0) {
                rules.add(new QueryRule(QueryRule.Operator.OR));
            }
            rules.add(new QueryRule(ONTOLOGY_TERM_IRI, QueryRule.Operator.EQUALS, ot.getTermAccession()));
            validOntologyTerm.put(ot.getTermAccession(), ot.getName());
        }
        QueryImpl q = new QueryImpl();
        q.pageSize(10000);
        for (QueryRule rule : rules) {
            q.addRule(rule);
        }
        SearchRequest request = new SearchRequest(null, (Query)q, null);
        SearchResult result = this.searchService.search(request);
        for (Hit hit : result) {
            Map columnValueMap = hit.getColumnValueMap();
            String ontologyIRI = columnValueMap.get(ONTOLOGY_IRI).toString();
            String ontologyTermUri = columnValueMap.get(ONTOLOGY_TERM_IRI).toString();
            String ontologyTermName = columnValueMap.get(ONTOLOGY_LABEL) + ":" + columnValueMap.get(ONTOLOGYTERM_SYNONYM).toString();
            Boolean boost = boostedOntologyTermUris.contains(ontologyTermUri);
            if (!validOntologyTerm.containsKey(ontologyTermUri) || !((String)validOntologyTerm.get(ontologyTermUri)).equalsIgnoreCase(ontologyTermName)) continue;
            String alternativeDefinitions = columnValueMap.get(ALTERNATIVE_DEFINITION) == null ? "" : columnValueMap.get(ALTERNATIVE_DEFINITION).toString();
            String nodePath = columnValueMap.get(NODE_PATH).toString();
            if (!totalHits.containsKey(ontologyIRI)) {
                totalHits.put(ontologyIRI, new OntologyTermContainer(ontologyIRI));
            }
            ((OntologyTermContainer)totalHits.get(ontologyIRI)).getAllPaths().put(nodePath, boost);
            ((OntologyTermContainer)totalHits.get(ontologyIRI)).getAlternativeDefinitions().put(nodePath, alternativeDefinitions);
            ((OntologyTermContainer)totalHits.get(ontologyIRI)).getSelectedOntologyTerms().add(hit.getId());
        }
        return totalHits;
    }

    private List<Map<Integer, List<BoostTermContainer>>> addAlternativeDefinition(Map<String, OntologyTermContainer> ontologyTermContainers) {
        ArrayList<Map<Integer, List<BoostTermContainer>>> positions = new ArrayList<Map<Integer, List<BoostTermContainer>>>();
        for (Map.Entry<String, OntologyTermContainer> entry : ontologyTermContainers.entrySet()) {
            String ontologyIRI = entry.getKey();
            OntologyTermContainer container = entry.getValue();
            if (container.getAlternativeDefinitions().size() <= 0) continue;
            for (Map.Entry<String, String> entryForAlterDefinition : container.getAlternativeDefinitions().entrySet()) {
                String definitionString = entryForAlterDefinition.getValue();
                if (definitionString.isEmpty()) continue;
                Boolean boost = container.getAllPaths().get(entryForAlterDefinition.getKey());
                for (String definition : definitionString.split("&&&")) {
                    HashMap<String, OntologyTermContainer> totalHits = new HashMap<String, OntologyTermContainer>();
                    HashSet<String> ontologyTerms = new HashSet<String>();
                    ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
                    for (String relatedOntologyTermUri : definition.split(",")) {
                        if (rules.size() != 0) {
                            rules.add(new QueryRule(QueryRule.Operator.OR));
                        }
                        rules.add(new QueryRule(ONTOLOGY_TERM_IRI, QueryRule.Operator.EQUALS, relatedOntologyTermUri));
                    }
                    QueryImpl q = new QueryImpl();
                    q.pageSize(10000);
                    for (QueryRule rule : rules) {
                        q.addRule(rule);
                    }
                    SearchRequest request = new SearchRequest(null, (Query)q, null);
                    SearchResult result = this.searchService.search(request);
                    for (Hit hit : result) {
                        Map columnValueMap = hit.getColumnValueMap();
                        if (!columnValueMap.get(ONTOLOGY_IRI).toString().equals(ontologyIRI)) continue;
                        String nodePath = columnValueMap.get(NODE_PATH).toString();
                        String ontologyTerm = columnValueMap.get(ONTOLOGY_TERM).toString().trim().toLowerCase();
                        if (!ontologyTerms.contains(ontologyTerm)) {
                            ontologyTerms.add(ontologyTerm);
                        }
                        if (!totalHits.containsKey(ontologyIRI)) {
                            totalHits.put(ontologyIRI, new OntologyTermContainer(ontologyIRI));
                        }
                        ((OntologyTermContainer)totalHits.get(ontologyIRI)).getAllPaths().put(nodePath, boost);
                    }
                    positions.add(this.createQueryRules(StringUtils.join((Object[])ontologyTerms.toArray(), (char)' '), totalHits));
                }
            }
        }
        return positions;
    }

    private Map<Integer, List<BoostTermContainer>> createQueryRules(String description, Map<String, OntologyTermContainer> totalHits) {
        HashMap<Integer, List<BoostTermContainer>> position = new HashMap<Integer, List<BoostTermContainer>>();
        List<String> uniqueTokens = this.stemMembers(Arrays.asList(description.split(" +")));
        for (OntologyTermContainer ontologyTermContainer : totalHits.values()) {
            HashSet<String> existingQueryStrings = new HashSet<String>();
            for (Map.Entry<String, Boolean> entry : ontologyTermContainer.getAllPaths().entrySet()) {
                String documentType = "ontologyTerm-" + ontologyTermContainer.getOntologyIRI();
                String parentNodePath = entry.getKey();
                int parentNodeLevel = parentNodePath.split("\\.").length;
                Boolean boost = entry.getValue();
                Query q = new QueryImpl().like(NODE_PATH, (Object)entry.getKey()).pageSize(5000);
                SearchResult result = this.searchService.search(new SearchRequest(documentType, q, null));
                Iterator iterator = result.iterator();
                Pattern pattern = Pattern.compile("[0-9]+");
                Matcher matcher = null;
                BoostTermContainer boostTermContainer = new BoostTermContainer(parentNodePath, new LinkedHashSet<String>(), boost);
                int finalIndexPosition = -1;
                while (iterator.hasNext()) {
                    Hit hit = (Hit)iterator.next();
                    Map columnValueMap = hit.getColumnValueMap();
                    String nodePath = columnValueMap.get(NODE_PATH).toString();
                    String ontologyTermSynonym = columnValueMap.get(ONTOLOGYTERM_SYNONYM).toString().trim().toLowerCase();
                    if (existingQueryStrings.contains(ontologyTermSynonym)) continue;
                    existingQueryStrings.add(ontologyTermSynonym);
                    if (nodePath.equals(parentNodePath)) {
                        if (finalIndexPosition == -1) {
                            finalIndexPosition = this.locateTermInDescription(uniqueTokens, ontologyTermSynonym);
                        }
                        if (ontologyTermSynonym.toString().equals("")) continue;
                        boostTermContainer.getTerms().add(ontologyTermSynonym);
                        continue;
                    }
                    if (!nodePath.startsWith(parentNodePath + ".")) continue;
                    matcher = pattern.matcher(ontologyTermSynonym);
                    if (!matcher.find() && !ontologyTermSynonym.equals("")) {
                        int levelDown = nodePath.split("\\.").length - parentNodeLevel;
                        double boostedNumber = Math.pow(0.5, levelDown);
                        if (finalIndexPosition == -1) {
                            finalIndexPosition = this.locateTermInDescription(uniqueTokens, ontologyTermSynonym);
                        }
                        StringBuilder boostedSynonym = new StringBuilder();
                        for (String eachToken : ontologyTermSynonym.split(" +")) {
                            if (eachToken.length() != 0) {
                                boostedSynonym.append(' ');
                            }
                            boostedSynonym.append(eachToken).append('^').append(boostedNumber);
                        }
                        ontologyTermSynonym = boostedSynonym.toString();
                    }
                    if (ontologyTermSynonym.toString().equals("")) continue;
                    boostTermContainer.getTerms().add(ontologyTermSynonym);
                }
                if (!position.containsKey(finalIndexPosition)) {
                    position.put(finalIndexPosition, new ArrayList());
                }
                ((List)position.get(finalIndexPosition)).add(boostTermContainer);
            }
        }
        if (!position.containsKey(-2)) {
            position.put(-2, new ArrayList());
        }
        BoostTermContainer descriptionBoostTermContainer = new BoostTermContainer(null, new LinkedHashSet<String>(), false);
        descriptionBoostTermContainer.getTerms().add(this.removeStopWords(description));
        ((List)position.get(-2)).add(descriptionBoostTermContainer);
        return position;
    }

    private String removeStopWords(String originalTerm) {
        LinkedHashSet<String> tokens = new LinkedHashSet<String>(Arrays.asList(originalTerm.trim().toLowerCase().split(" +")));
        tokens.removeAll(NGramMatchingModel.STOPWORDSLIST);
        return StringUtils.join((Object[])tokens.toArray(), (char)' ');
    }

    private Integer locateTermInDescription(List<String> uniqueSets, String ontologyTermSynonym) {
        int finalIndex = -1;
        List<String> termsFromDescription = this.stemMembers(Arrays.asList(ontologyTermSynonym.split(" +")));
        for (String eachTerm : termsFromDescription) {
            if (!uniqueSets.contains(eachTerm)) {
                return -1;
            }
            int currentIndex = uniqueSets.indexOf(eachTerm);
            if (finalIndex == -1) {
                finalIndex = currentIndex;
                continue;
            }
            finalIndex = finalIndex < currentIndex ? finalIndex : currentIndex;
        }
        return finalIndex;
    }

    private List<String> stemMembers(List<String> originalList) {
        ArrayList<String> newList = new ArrayList<String>();
        for (String eachTerm : originalList) {
            if (NGramMatchingModel.STOPWORDSLIST.contains(eachTerm = eachTerm.toLowerCase().trim())) continue;
            try {
                stemmer.setCurrent(eachTerm);
                stemmer.stem();
                eachTerm = stemmer.getCurrent().toLowerCase();
            }
            catch (RuntimeException e) {
                logger.error((Object)("Could not stem word : " + eachTerm), (Throwable)e);
            }
            newList.add(eachTerm);
        }
        return newList;
    }

    private void createMappingStore(String userName, Integer selectedDataSet, List<Integer> dataSetsToMatch) {
        ObservableFeature f = (ObservableFeature)this.dataService.findOne("ObservableFeature", new QueryImpl().eq("Identifier", (Object)STORE_MAPPING_FEATURE), ObservableFeature.class);
        if (f == null) {
            ArrayList<ObservableFeature> features = new ArrayList<ObservableFeature>();
            ObservableFeature feature = new ObservableFeature();
            feature.setIdentifier(STORE_MAPPING_FEATURE);
            feature.setDataType(MolgenisFieldTypes.FieldTypeEnum.INT.toString().toLowerCase());
            feature.setName("Features");
            features.add(feature);
            ObservableFeature mappedFeature = new ObservableFeature();
            mappedFeature.setIdentifier(STORE_MAPPING_MAPPED_FEATURE);
            mappedFeature.setDataType(MolgenisFieldTypes.FieldTypeEnum.INT.toString().toLowerCase());
            mappedFeature.setName("Mapped features");
            features.add(mappedFeature);
            ObservableFeature mappedFeatureScore = new ObservableFeature();
            mappedFeatureScore.setIdentifier(STORE_MAPPING_SCORE);
            mappedFeatureScore.setDataType(MolgenisFieldTypes.FieldTypeEnum.DECIMAL.toString().toLowerCase());
            mappedFeatureScore.setName(STORE_MAPPING_SCORE);
            features.add(mappedFeatureScore);
            ObservableFeature observationSetFeature = new ObservableFeature();
            observationSetFeature.setIdentifier(OBSERVATION_SET);
            observationSetFeature.setDataType(MolgenisFieldTypes.FieldTypeEnum.INT.toString().toLowerCase());
            observationSetFeature.setName(OBSERVATION_SET);
            features.add(observationSetFeature);
            ObservableFeature mappedFeatureAbsoluteScore = new ObservableFeature();
            mappedFeatureAbsoluteScore.setIdentifier(STORE_MAPPING_ABSOLUTE_SCORE);
            mappedFeatureAbsoluteScore.setDataType(MolgenisFieldTypes.FieldTypeEnum.DECIMAL.toString().toLowerCase());
            mappedFeatureAbsoluteScore.setName(STORE_MAPPING_ABSOLUTE_SCORE);
            features.add(mappedFeatureAbsoluteScore);
            ObservableFeature confirmMapping = new ObservableFeature();
            confirmMapping.setIdentifier(STORE_MAPPING_CONFIRM_MAPPING);
            confirmMapping.setDataType(MolgenisFieldTypes.FieldTypeEnum.BOOL.toString().toLowerCase());
            confirmMapping.setName("Mapping confirmed");
            features.add(confirmMapping);
            this.dataService.add("ObservableFeature", features);
            Protocol protocol = new Protocol();
            protocol.setIdentifier(PROTOCOL_IDENTIFIER);
            protocol.setName(PROTOCOL_IDENTIFIER);
            protocol.setFeatures(features);
            this.dataService.add("Protocol", (Entity)protocol);
            this.dataService.getCrudRepository("Protocol").flush();
        }
        for (Integer dataSetId : dataSetsToMatch) {
            String identifier = userName + "-" + selectedDataSet + "-" + dataSetId;
            DataSet existing = (DataSet)this.dataService.findOne("DataSet", new QueryImpl().eq("Identifier", (Object)identifier), DataSet.class);
            if (existing != null) continue;
            DataSet dataSet = new DataSet();
            dataSet.setIdentifier(identifier);
            dataSet.setName(identifier);
            Protocol protocol = (Protocol)this.dataService.findOne("Protocol", new QueryImpl().eq("Identifier", (Object)PROTOCOL_IDENTIFIER), Protocol.class);
            dataSet.setProtocolUsed(protocol);
            dataSet.setDescription("");
            this.dataService.add("DataSet", (Entity)dataSet);
        }
        this.dataService.getCrudRepository("Protocol").flush();
    }

    @Override
    @RunAsSystem
    public boolean checkExistingMappings(String dataSetIdentifier, DataService dataService) {
        DataSet dataSet = (DataSet)dataService.findOne("DataSet", new QueryImpl().eq("Identifier", (Object)dataSetIdentifier), DataSet.class);
        if (dataSet == null) {
            throw new MolgenisDataException("Unknown DataSet [" + dataSetIdentifier + "]");
        }
        Iterable listOfObservationSets = dataService.findAll("ObservationSet", new QueryImpl().eq("partOfDataSet", (Object)dataSet), ObservationSet.class);
        return Iterables.size((Iterable)listOfObservationSets) > 0;
    }

    public class OntologyTermContainer {
        private final String ontologyIRI;
        private final HashMap<String, String> alternativeDefinitions;
        private final Map<String, Boolean> allPaths;
        private final Set<String> selectedOntologyTerms;

        public OntologyTermContainer(String ontologyIRI) {
            this.ontologyIRI = ontologyIRI;
            this.alternativeDefinitions = new HashMap();
            this.allPaths = new HashMap<String, Boolean>();
            this.selectedOntologyTerms = new HashSet<String>();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.ontologyIRI == null ? 0 : this.ontologyIRI.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OntologyTermContainer other = (OntologyTermContainer)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.ontologyIRI == null ? other.ontologyIRI != null : !this.ontologyIRI.equals(other.ontologyIRI));
        }

        private AsyncOntologyMatcher getOuterType() {
            return AsyncOntologyMatcher.this;
        }

        public String getOntologyIRI() {
            return this.ontologyIRI;
        }

        public Map<String, Boolean> getAllPaths() {
            return this.allPaths;
        }

        public HashMap<String, String> getAlternativeDefinitions() {
            return this.alternativeDefinitions;
        }

        public Set<String> getSelectedOntologyTerms() {
            return this.selectedOntologyTerms;
        }
    }

    public class BoostTermContainer {
        private final String parentNodePath;
        private boolean boost;
        private final LinkedHashSet<String> terms;

        public BoostTermContainer(String parentNodePath, LinkedHashSet<String> terms, boolean boost) {
            this.parentNodePath = parentNodePath;
            this.terms = terms;
            this.boost = boost;
        }

        public LinkedHashSet<String> getTerms() {
            return this.terms;
        }

        public void setBoost(boolean boost) {
            if (!this.boost) {
                this.boost = boost;
            }
        }

        public boolean isBoost() {
            return this.boost;
        }

        public String getParentNodePath() {
            return this.parentNodePath;
        }
    }
}

