/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.Countable;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.support.AbstractRepository;
import org.molgenis.data.support.DefaultAttributeMetaData;
import org.molgenis.data.support.DefaultEntityMetaData;
import org.molgenis.data.support.MapEntity;
import org.molgenis.omx.biobankconnect.utils.OntologyLoader;

public class OntologyRepository
extends AbstractRepository
implements Countable {
    private final OntologyLoader loader;
    private static final String ONTOLOGY_URL = "url";
    private static final String ENTITY_TYPE = "entity_type";
    private static final String ONTOLOGY_LABEL = "ontologyLabel";
    private final String name;

    public OntologyRepository(OntologyLoader loader, String name) {
        super("ontology://" + name);
        this.loader = loader;
        this.name = name;
    }

    public long count() {
        return 1L;
    }

    public Class<? extends Entity> getEntityClass() {
        return MapEntity.class;
    }

    public Iterator<Entity> iterator() {
        ArrayList<MapEntity> entities = new ArrayList<MapEntity>();
        MapEntity entity = new MapEntity();
        entity.set(ONTOLOGY_URL, (Object)this.loader.getOntologyIRI());
        entity.set(ONTOLOGY_LABEL, (Object)this.loader.getOntologyName());
        entity.set(ENTITY_TYPE, (Object)"indexedOntology");
        entities.add(entity);
        return entities.iterator();
    }

    public void close() throws IOException {
    }

    public EntityMetaData getEntityMetaData() {
        DefaultEntityMetaData metaData = new DefaultEntityMetaData(this.name);
        metaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(ONTOLOGY_URL, MolgenisFieldTypes.FieldTypeEnum.STRING));
        metaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(ONTOLOGY_LABEL, MolgenisFieldTypes.FieldTypeEnum.STRING));
        metaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(ENTITY_TYPE, MolgenisFieldTypes.FieldTypeEnum.STRING));
        return metaData;
    }
}

