/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.utils;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.support.AbstractRepository;
import org.molgenis.data.support.DefaultAttributeMetaData;
import org.molgenis.data.support.DefaultEntityMetaData;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.omx.converters.ValueConverter;
import org.molgenis.omx.converters.ValueConverterException;
import org.molgenis.omx.observ.CategoryMetaData;
import org.molgenis.omx.observ.CharacteristicMetaData;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.omx.observ.ObservationSet;
import org.molgenis.omx.observ.ObservedValue;
import org.molgenis.omx.observ.Protocol;

public class StoreMappingRepository
extends AbstractRepository {
    private final Iterable<ObservedValue> observedValues;
    private final ValueConverter valueConverter;
    private final DataSet dataSet;
    private DefaultEntityMetaData metaData = null;

    public StoreMappingRepository(DataSet dataSet, DataService dataService) {
        super("mapping://" + dataSet.getIdentifier());
        this.dataSet = dataSet;
        Iterable observationSets = dataService.findAll("ObservationSet", new QueryImpl().eq("partOfDataSet", (Object)dataSet), ObservationSet.class);
        this.observedValues = dataService.findAll("ObservedValue", new QueryImpl().in("ObservationSet", (Iterable)Lists.newArrayList((Iterable)observationSets)), ObservedValue.class);
        this.valueConverter = new ValueConverter(dataService);
    }

    public StoreMappingRepository(DataSet dataSet, List<ObservedValue> observedValues, DataService dataService) {
        super("mapping://" + dataSet.getIdentifier());
        this.dataSet = dataSet;
        this.observedValues = observedValues;
        this.valueConverter = new ValueConverter(dataService);
    }

    public Class<? extends Entity> getEntityClass() {
        return MapEntity.class;
    }

    public Iterator<Entity> iterator() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        try {
            HashMap<Integer, MapEntity> storeMapping = new HashMap<Integer, MapEntity>();
            for (ObservedValue ov : this.observedValues) {
                Object entity = null;
                Integer observationId = ov.getObservationSet().getId();
                entity = storeMapping.containsKey(observationId) ? (Entity)storeMapping.get(observationId) : new MapEntity();
                entity.set(ov.getFeature().getIdentifier(), (Object)this.valueConverter.toCell(ov.getValue()));
                storeMapping.put(observationId, (MapEntity)entity);
            }
            for (Entity entity : storeMapping.values()) {
                entities.add(entity);
            }
        }
        catch (ValueConverterException e) {
            throw new RuntimeException("Failed to index mapping table : " + this.dataSet.getName() + " error : " + e.getMessage());
        }
        return entities.iterator();
    }

    public void close() throws IOException {
    }

    public EntityMetaData getEntityMetaData() {
        if (this.metaData == null) {
            this.metaData = new DefaultEntityMetaData(this.dataSet.getIdentifier());
            this.metaData.setLabel(this.dataSet.getLabelValue());
            Protocol protocol = this.dataSet.getProtocolUsed();
            if (protocol != null) {
                ArrayList<ObservableFeature> features = new ArrayList<ObservableFeature>();
                this.getFeatures(protocol, features);
                for (ObservableFeature feature : features) {
                    MolgenisFieldTypes.FieldTypeEnum fieldType = MolgenisFieldTypes.getType((String)feature.getDataType()).getEnumType();
                    DefaultAttributeMetaData attr = new DefaultAttributeMetaData(feature.getIdentifier(), fieldType);
                    attr.setDescription(feature.getDescription());
                    attr.setLabel(feature.getName());
                    attr.setIdAttribute(false);
                    attr.setLabelAttribute(false);
                    if (fieldType.equals((Object)MolgenisFieldTypes.FieldTypeEnum.XREF) || fieldType.equals((Object)MolgenisFieldTypes.FieldTypeEnum.MREF)) {
                        attr.setRefEntity((EntityMetaData)new CharacteristicMetaData());
                    } else if (fieldType.equals((Object)MolgenisFieldTypes.FieldTypeEnum.CATEGORICAL)) {
                        attr.setRefEntity((EntityMetaData)new CategoryMetaData());
                    }
                    this.metaData.addAttributeMetaData((AttributeMetaData)attr);
                }
            }
        }
        return this.metaData;
    }

    private void getFeatures(Protocol protocol, List<ObservableFeature> features) {
        features.addAll(protocol.getFeatures());
        for (Protocol subProtocol : protocol.getSubprotocols()) {
            this.getFeatures(subProtocol, features);
        }
    }
}

