/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.wizard;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.log4j.Logger;
import org.molgenis.data.DataService;
import org.molgenis.omx.biobankconnect.ontologyannotator.OntologyAnnotator;
import org.molgenis.omx.biobankconnect.ontologyannotator.UpdateIndexRequest;
import org.molgenis.omx.biobankconnect.ontologymatcher.OntologyMatcher;
import org.molgenis.omx.biobankconnect.ontologymatcher.OntologyMatcherRequest;
import org.molgenis.omx.biobankconnect.ontologymatcher.OntologyMatcherResponse;
import org.molgenis.omx.biobankconnect.wizard.BiobankConnectWizard;
import org.molgenis.omx.biobankconnect.wizard.ChooseCataloguePage;
import org.molgenis.omx.biobankconnect.wizard.CurrentUserStatus;
import org.molgenis.omx.biobankconnect.wizard.MappingManagerPage;
import org.molgenis.omx.biobankconnect.wizard.OntologyAnnotatorPage;
import org.molgenis.omx.biobankconnect.wizard.OntologyMatcherPage;
import org.molgenis.omx.biobankconnect.wizard.ProgressingBarPage;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.search.SearchService;
import org.molgenis.security.user.UserAccountService;
import org.molgenis.ui.wizard.AbstractWizardController;
import org.molgenis.ui.wizard.Wizard;
import org.molgenis.ui.wizard.WizardPage;
import org.molgenis.util.FileUploadUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/plugin/biobankconnect"})
public class BiobankConnectController
extends AbstractWizardController {
    private static final Logger logger = Logger.getLogger(BiobankConnectController.class);
    public static final String ID = "biobankconnect";
    public static final String URI = "/plugin/biobankconnect";
    private final ChooseCataloguePage chooseCataloguePager;
    private final OntologyAnnotatorPage ontologyAnnotatorPager;
    private final OntologyMatcherPage ontologyMatcherPager;
    private final MappingManagerPage mappingManagerPager;
    private final ProgressingBarPage progressingBarPager;
    private BiobankConnectWizard wizard;
    private static final String PROTOCOL_IDENTIFIER = "store_mapping";
    @Autowired
    private DataService dataService;
    @Autowired
    private UserAccountService userAccountService;
    @Autowired
    private OntologyAnnotator ontologyAnnotator;
    @Autowired
    private OntologyMatcher ontologyMatcher;
    @Autowired
    private SearchService searchService;
    @Autowired
    private CurrentUserStatus currentUserStatus;

    @Autowired
    public BiobankConnectController(ChooseCataloguePage chooseCataloguePager, OntologyAnnotatorPage ontologyAnnotatorPager, OntologyMatcherPage ontologyMatcherPager, MappingManagerPage mappingManagerPager, ProgressingBarPage progressingBarPager) {
        super(URI, ID);
        if (chooseCataloguePager == null) {
            throw new IllegalArgumentException("ChooseCataloguePager is null");
        }
        if (ontologyAnnotatorPager == null) {
            throw new IllegalArgumentException("OntologyAnnotatorPager is null");
        }
        if (ontologyMatcherPager == null) {
            throw new IllegalArgumentException("OntologyMatcherPager is null");
        }
        if (mappingManagerPager == null) {
            throw new IllegalArgumentException("MappingManagerPager is null");
        }
        if (progressingBarPager == null) {
            throw new IllegalArgumentException("ProgressingBarPager is null");
        }
        this.chooseCataloguePager = chooseCataloguePager;
        this.ontologyAnnotatorPager = ontologyAnnotatorPager;
        this.ontologyMatcherPager = ontologyMatcherPager;
        this.mappingManagerPager = mappingManagerPager;
        this.progressingBarPager = progressingBarPager;
        this.wizard = new BiobankConnectWizard();
    }

    public void onInit(HttpServletRequest request) {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        Iterable allDataSets = this.dataService.findAll("DataSet", DataSet.class);
        for (DataSet dataSet : allDataSets) {
            if (dataSet.getProtocolUsed().getIdentifier().equals(PROTOCOL_IDENTIFIER)) continue;
            dataSets.add(dataSet);
        }
        this.wizard.setDataSets(dataSets);
        this.currentUserStatus.setUserLoggedIn(this.userAccountService.getCurrentUser().getUsername(), request.getRequestedSessionId());
    }

    protected Wizard createWizard() {
        this.wizard = new BiobankConnectWizard();
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        Iterable allDataSets = this.dataService.findAll("DataSet", DataSet.class);
        for (DataSet dataSet : allDataSets) {
            if (dataSet.getProtocolUsed().getIdentifier().equals(PROTOCOL_IDENTIFIER)) continue;
            dataSets.add(dataSet);
        }
        this.wizard.setDataSets(dataSets);
        this.wizard.setUserName(this.userAccountService.getCurrentUser().getUsername());
        this.wizard.addPage((WizardPage)this.chooseCataloguePager);
        this.wizard.addPage((WizardPage)this.ontologyAnnotatorPager);
        this.wizard.addPage((WizardPage)this.ontologyMatcherPager);
        this.wizard.addPage((WizardPage)this.progressingBarPager);
        this.wizard.addPage((WizardPage)this.mappingManagerPager);
        return this.wizard;
    }

    @RequestMapping(value={"/uploadfeatures"}, method={RequestMethod.POST}, headers={"Content-Type=multipart/form-data"})
    public String importFeatures(@RequestParam String dataSetName, @RequestParam Part file, @ModelAttribute(value="wizard") BiobankConnectWizard biobankConnectWizard, HttpServletRequest request, Model model) throws IOException {
        File uploadFile = FileUploadUtils.saveToTempFolder((Part)file);
        String message = this.ontologyAnnotator.uploadFeatures(uploadFile, dataSetName);
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        Iterable allDataSets = this.dataService.findAll("DataSet", DataSet.class);
        for (DataSet dataSet : allDataSets) {
            if (dataSet.getProtocolUsed().getIdentifier().equals(PROTOCOL_IDENTIFIER)) continue;
            dataSets.add(dataSet);
        }
        biobankConnectWizard.setDataSets(dataSets);
        logger.error((Object)message);
        if (message.length() > 0) {
            model.addAttribute("message", (Object)message);
        }
        return this.init(request);
    }

    @RequestMapping(value={"/annotate"}, method={RequestMethod.POST})
    public String annotate(HttpServletRequest request) {
        this.ontologyAnnotator.removeAnnotations(this.wizard.getSelectedDataSet().getId());
        if (request.getParameter("selectedOntologies") != null) {
            ArrayList<String> documentTypes = new ArrayList<String>();
            for (String ontologyUri : request.getParameter("selectedOntologies").split(",")) {
                documentTypes.add("ontologyTerm-" + ontologyUri);
            }
            this.ontologyAnnotator.annotate(this.wizard.getSelectedDataSet().getId(), documentTypes);
        }
        return this.init(request);
    }

    @RequestMapping(value={"/annotate/remove"}, method={RequestMethod.POST})
    public String removeAnnotations(HttpServletRequest request) throws Exception {
        this.ontologyAnnotator.removeAnnotations(this.wizard.getSelectedDataSet().getId());
        return this.init(request);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/annotate/update"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDocument(@RequestBody UpdateIndexRequest request) {
        this.ontologyAnnotator.updateIndex(request);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/rematch"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public OntologyMatcherResponse rematch(@RequestBody OntologyMatcherRequest request) {
        String userName = this.userAccountService.getCurrentUser().getUsername();
        this.ontologyMatcher.match(userName, request.getSourceDataSetId(), request.getSelectedDataSetIds(), request.getFeatureId());
        OntologyMatcherResponse response = new OntologyMatcherResponse(null, this.ontologyMatcher.isRunning(), this.ontologyMatcher.matchPercentage(userName), null);
        return response;
    }

    @RequestMapping(value={"/running"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, Boolean> isRunning(HttpServletRequest request) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("isRunning", this.currentUserStatus.isUserLoggedIn(this.userAccountService.getCurrentUser().getUsername(), request.getRequestedSessionId()));
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/match/status"}, produces={"application/json"})
    @ResponseBody
    public OntologyMatcherResponse checkMatch() {
        String userName = this.userAccountService.getCurrentUser().getUsername();
        OntologyMatcherResponse response = new OntologyMatcherResponse(this.currentUserStatus.getUserCurrentStage(userName), this.currentUserStatus.isUserMatching(userName), this.ontologyMatcher.matchPercentage(userName), this.currentUserStatus.getTotalNumberOfUsers());
        return response;
    }

    @ModelAttribute(value="javascripts")
    public List<String> getJavascripts() {
        return Arrays.asList("bootstrap-fileupload.min.js", "jquery-ui-1.9.2.custom.min.js", "common-component.js", "catalogue-chooser.js", "ontology-annotator.js", "ontology-matcher.js", "mapping-manager.js", "simple_statistics.js", "biobank-connect.js");
    }

    @ModelAttribute(value="stylesheets")
    public List<String> getStylesheets() {
        return Arrays.asList("bootstrap-fileupload.min.css", "jquery-ui-1.9.2.custom.min.css", "biobank-connect.css", "catalogue-chooser.css", "ontology-matcher.css", "mapping-manager.css", "ontology-annotator.css");
    }
}

