/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.mappingmanager;

import java.io.IOException;
import java.io.Writer;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.csv.CsvWriter;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.framework.ui.MolgenisPluginController;
import org.molgenis.omx.biobankconnect.ontologyannotator.UpdateIndexRequest;
import org.molgenis.omx.biobankconnect.ontologymatcher.OntologyMatcher;
import org.molgenis.omx.biobankconnect.wizard.CurrentUserStatus;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.search.Hit;
import org.molgenis.search.SearchRequest;
import org.molgenis.search.SearchResult;
import org.molgenis.search.SearchService;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.security.user.UserAccountService;
import org.molgenis.util.FileStore;
import org.molgenis.util.GsonHttpMessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/plugin/mappingmanager"})
public class MappingManagerController
extends MolgenisPluginController {
    private static final Logger logger = Logger.getLogger(MappingManagerController.class);
    public static final String ID = "mappingmanager";
    public static final String URI = "/plugin/mappingmanager";
    private static final String FEATURE_ID = "id";
    private static final String FEATURE_NAME = "name";
    private static final String PROTOCOL_IDENTIFIER = "store_mapping";
    private static final String STORE_MAPPING_FEATURE = "store_mapping_feature";
    private static final String STORE_MAPPING_MAPPED_FEATURE = "store_mapping_mapped_feature";
    private static final String STORE_MAPPING_CONFIRM_MAPPING = "store_mapping_confirm_mapping";
    private final OntologyMatcher ontologyMatcher;
    private final SearchService searchService;
    private final DataService dataService;
    private final UserAccountService userAccountService;
    @Autowired
    private CurrentUserStatus currentUserStatus;
    @Autowired
    private FileStore fileStore;

    @Autowired
    public MappingManagerController(OntologyMatcher ontologyMatcher, SearchService searchService, UserAccountService userAccountService, DataService dataService) {
        super(URI);
        if (ontologyMatcher == null) {
            throw new IllegalArgumentException("OntologyMatcher is null");
        }
        if (searchService == null) {
            throw new IllegalArgumentException("SearchService is null");
        }
        if (dataService == null) {
            throw new IllegalArgumentException("DataService is null");
        }
        if (userAccountService == null) {
            throw new IllegalArgumentException("userAccountService is null");
        }
        this.userAccountService = userAccountService;
        this.ontologyMatcher = ontologyMatcher;
        this.searchService = searchService;
        this.dataService = dataService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String init(@RequestParam(value="selectedDataSet", required=false) String selectedDataSetId, HttpServletRequest request, Model model) {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        Iterable allDataSets = this.dataService.findAll("DataSet", (Query)new QueryImpl(), DataSet.class);
        for (DataSet dataSet : allDataSets) {
            if (dataSet.getProtocolUsed().getIdentifier().equals(PROTOCOL_IDENTIFIER)) continue;
            dataSets.add(dataSet);
        }
        model.addAttribute("dataSets", dataSets);
        model.addAttribute("userName", (Object)SecurityUtils.getCurrentUsername());
        if (selectedDataSetId != null) {
            model.addAttribute("selectedDataSet", (Object)selectedDataSetId);
        }
        model.addAttribute("isRunning", (Object)this.ontologyMatcher.isRunning());
        this.currentUserStatus.setUserLoggedIn(this.userAccountService.getCurrentUser().getUsername(), request.getRequestedSessionId());
        return "MappingManagerPlugin";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/delete"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDocuments(@RequestBody UpdateIndexRequest request) {
        try {
            this.searchService.deleteDocumentByIds(request.getDocumentType(), request.getDocumentIds());
        }
        catch (Exception e) {
            logger.error((Object)("Exception calling searchservice for request [" + request + "]"), (Throwable)e);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/update"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDocument(@RequestBody UpdateIndexRequest request) {
        try {
            this.searchService.updateDocumentById(request.getDocumentType(), request.getDocumentIds().get(0), request.getUpdateScript());
        }
        catch (Exception e) {
            logger.error((Object)("Exception calling searchservice for request [" + request + "]"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/download"}, method={RequestMethod.POST})
    public void download(@RequestParam(value="request") String requestString, HttpServletResponse response) throws IOException {
        requestString = URLDecoder.decode(requestString, "UTF-8");
        logger.info((Object)("Download request: [" + requestString + "]"));
        UpdateIndexRequest request = (UpdateIndexRequest)new GsonHttpMessageConverter().getGson().fromJson(requestString, UpdateIndexRequest.class);
        response.setContentType("text/csv");
        response.addHeader("Content-Disposition", "attachment; filename=" + this.getCsvFileName(request.getDocumentType()));
        CsvWriter writer = null;
        try {
            HashSet<Integer> featureIds = new HashSet<Integer>();
            Integer selectedDataSetId = request.getDataSetId();
            DataSet mappingDataSet = (DataSet)this.dataService.findOne("DataSet", (Object)selectedDataSetId, DataSet.class);
            List storeMappingDataSet = this.dataService.findAllAsList("DataSet", new QueryImpl().like("Identifier", (Object)selectedDataSetId.toString()));
            ArrayList<String> dataSetNames = new ArrayList<String>();
            dataSetNames.add(mappingDataSet.getName());
            HashMap dataSetMappings = new HashMap();
            if (storeMappingDataSet.size() > 0) {
                for (DataSet dataSet : storeMappingDataSet) {
                    Integer mappedDataSetId = Integer.parseInt(dataSet.getIdentifier().split("-")[2]);
                    if (!dataSet.getIdentifier().startsWith(this.userAccountService.getCurrentUser().getUsername() + "-" + selectedDataSetId) || mappedDataSetId.equals(selectedDataSetId)) continue;
                    DataSet mappedDataSet = (DataSet)this.dataService.findOne("DataSet", (Object)mappedDataSetId, DataSet.class);
                    dataSetNames.add(mappedDataSet.getName());
                    SearchRequest searchRequest = new SearchRequest(dataSet.getIdentifier(), new QueryImpl().pageSize(1000000), null);
                    SearchResult result = this.searchService.search(searchRequest);
                    HashMap<Integer, MappingClass> storeMappings = new HashMap<Integer, MappingClass>();
                    for (Hit hit : result.getSearchHits()) {
                        Map map = hit.getColumnValueMap();
                        Integer storeMappingFeatureId = Integer.parseInt(map.get(STORE_MAPPING_FEATURE).toString());
                        Integer storeMappingMappedFeatureId = Integer.parseInt(map.get(STORE_MAPPING_MAPPED_FEATURE).toString());
                        boolean confirmation = (Boolean)map.get(STORE_MAPPING_CONFIRM_MAPPING);
                        if (!storeMappings.containsKey(storeMappingFeatureId)) {
                            storeMappings.put(storeMappingFeatureId, new MappingClass());
                        }
                        ((MappingClass)storeMappings.get(storeMappingFeatureId)).addMapping(storeMappingFeatureId, storeMappingMappedFeatureId, confirmation);
                        featureIds.add(storeMappingFeatureId);
                        featureIds.add(storeMappingMappedFeatureId);
                    }
                    dataSetMappings.put(mappedDataSetId, storeMappings);
                }
                HashMap<Integer, ObservableFeature> featureMap = new HashMap<Integer, ObservableFeature>();
                Iterable features = this.dataService.findAll("ObservableFeature", new QueryImpl().in(FEATURE_ID, new ArrayList(featureIds)), ObservableFeature.class);
                for (ObservableFeature feature : features) {
                    featureMap.put(feature.getId(), feature);
                }
                writer = new CsvWriter((Writer)response.getWriter(), dataSetNames);
                QueryImpl q = new QueryImpl();
                q.pageSize(1000000);
                q.addRule(new QueryRule("type", QueryRule.Operator.SEARCH, ObservableFeature.class.getSimpleName().toLowerCase()));
                SearchRequest searchFeatures = new SearchRequest("protocolTree-" + selectedDataSetId, (Query)q, null);
                SearchResult featureSearchResult = this.searchService.search(searchFeatures);
                for (Hit hit : featureSearchResult.getSearchHits()) {
                    MapEntity entity = new MapEntity();
                    Map map = hit.getColumnValueMap();
                    String featureName = map.get(FEATURE_NAME).toString();
                    Integer featureId = Integer.parseInt(map.get(FEATURE_ID).toString());
                    entity.set((String)dataSetNames.get(0), (Object)featureName);
                    int i = 1;
                    for (DataSet dataSet : storeMappingDataSet) {
                        Integer mappedDataSetId = Integer.parseInt(dataSet.getIdentifier().split("-")[2]);
                        if (mappedDataSetId.equals(selectedDataSetId)) continue;
                        StringBuilder value = new StringBuilder();
                        Map storeMappings = (Map)dataSetMappings.get(mappedDataSetId);
                        if (storeMappings.containsKey(featureId)) {
                            List<Integer> candidateIds = null;
                            MappingClass mappingClass = (MappingClass)storeMappings.get(featureId);
                            candidateIds = mappingClass.isConfirmation() ? mappingClass.getFinalizedMapping() : mappingClass.getCandidateMappings();
                            for (Integer id : candidateIds) {
                                if (!featureMap.containsKey(id)) continue;
                                if (value.length() > 0) {
                                    value.append(';').append('\r');
                                }
                                value.append(((ObservableFeature)featureMap.get(id)).getName()).append(':').append(((ObservableFeature)featureMap.get(id)).getDescription());
                            }
                        }
                        entity.set((String)dataSetNames.get(i++), (Object)value.toString());
                    }
                    writer.add((Entity)entity);
                }
            }
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    private String getCsvFileName(String dataSetName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dataSetName + "_" + dateFormat.format(new Date()) + ".csv";
    }

    static class MappingClass {
        private Integer featureId = null;
        private List<Integer> finalizedMapping = null;
        private List<Integer> candidateMappings = null;

        MappingClass() {
        }

        public void addMapping(Integer featureId, Integer singleMappedFeatureId, boolean confirmation) {
            if (this.featureId == null) {
                this.featureId = featureId;
            }
            if (this.finalizedMapping == null) {
                this.finalizedMapping = new ArrayList<Integer>();
            }
            if (this.candidateMappings == null) {
                this.candidateMappings = new ArrayList<Integer>();
            }
            this.candidateMappings.add(singleMappedFeatureId);
            if (confirmation) {
                this.finalizedMapping.add(singleMappedFeatureId);
            }
        }

        public Integer getFeatureId() {
            return this.featureId;
        }

        public boolean isConfirmation() {
            return this.finalizedMapping.size() > 0;
        }

        public List<Integer> getFinalizedMapping() {
            return this.finalizedMapping;
        }

        public List<Integer> getCandidateMappings() {
            return this.candidateMappings;
        }
    }
}

