/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.ontologyannotator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.elasticsearch.common.collect.Lists;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.Repository;
import org.molgenis.data.csv.CsvRepository;
import org.molgenis.data.processor.CellProcessor;
import org.molgenis.data.processor.LowerCaseProcessor;
import org.molgenis.data.processor.TrimProcessor;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.omx.biobankconnect.ontologyannotator.OntologyAnnotator;
import org.molgenis.omx.biobankconnect.ontologyannotator.UpdateIndexRequest;
import org.molgenis.omx.biobankconnect.utils.NGramMatchingModel;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.omx.observ.Protocol;
import org.molgenis.omx.observ.target.Ontology;
import org.molgenis.omx.observ.target.OntologyTerm;
import org.molgenis.omx.protocol.CategoryRepository;
import org.molgenis.omx.protocol.ProtocolTreeRepository;
import org.molgenis.search.Hit;
import org.molgenis.search.SearchRequest;
import org.molgenis.search.SearchResult;
import org.molgenis.search.SearchService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.tartarus.snowball.ext.PorterStemmer;

public class AsyncOntologyAnnotator
implements OntologyAnnotator,
InitializingBean {
    @Autowired
    private DataService dataService;
    private SearchService searchService;
    private static final AtomicInteger runningProcesses = new AtomicInteger();
    private static final Logger logger = Logger.getLogger(AsyncOntologyAnnotator.class);
    private boolean complete = false;

    @Autowired
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.searchService == null) {
            throw new IllegalArgumentException("Missing bean of type SearchService");
        }
    }

    @Override
    public boolean isRunning() {
        return runningProcesses.get() != 0;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void initComplete() {
        this.complete = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public String uploadFeatures(File uploadFile, String datasetName) throws IOException {
        try (CsvRepository csvRepository = null;){
            Object f;
            boolean existingDataSet;
            boolean bl = existingDataSet = this.dataService.findOne("DataSet", new QueryImpl().eq("Identifier", (Object)(datasetName + "_dataset" + "_identifier"))) != null;
            if (existingDataSet) {
                String string = "the dataset name has existed";
                return string;
            }
            List<CellProcessor> cellProcessors = Arrays.asList(new TrimProcessor(), new LowerCaseProcessor(true, false));
            csvRepository = new CsvRepository(uploadFile, cellProcessors);
            ArrayList<String> requiredColumns = new ArrayList<String>(Arrays.asList("Name".toLowerCase(), "description"));
            Iterator columnNamesIterator = csvRepository.getEntityMetaData().getAttributes().iterator();
            while (columnNamesIterator.hasNext()) {
                requiredColumns.remove(((AttributeMetaData)columnNamesIterator.next()).getName());
            }
            if (requiredColumns.size() > 0) {
                String string = "The header(s) " + ((Object)requiredColumns).toString() + " is missing";
                return string;
            }
            ArrayList<String> featureIdentifiers = new ArrayList<String>();
            ArrayList<ObservableFeature> fList = new ArrayList<ObservableFeature>();
            for (Object t : csvRepository) {
                f = new ObservableFeature();
                f.setName(t.getString("Name".toLowerCase()));
                f.setDescription(t.getString("description"));
                f.setIdentifier(datasetName + "_" + f.getName() + "_identifier");
                featureIdentifiers.add(f.getIdentifier());
                fList.add((ObservableFeature)f);
            }
            if (featureIdentifiers.size() == 0) {
                Object t;
                t = "Please check the uploaded file, there are no features in the file!";
                return t;
            }
            List<String> checkExistingFeatures = this.checkExistingFeatures(featureIdentifiers);
            if (checkExistingFeatures.size() > 0) {
                f = "The features : " + checkExistingFeatures + " exist in the database already! Please remove them from uploaded file!";
                return f;
            }
            Protocol prot = new Protocol();
            prot.setName(datasetName + "_protocol");
            prot.setIdentifier(datasetName + "_protocol" + "_identifier");
            prot.setFeatures(fList);
            DataSet dataSet = new DataSet();
            dataSet.setName(datasetName);
            dataSet.setIdentifier(datasetName + "_dataset" + "_identifier");
            dataSet.setProtocolUsed(prot);
            this.dataService.add("ObservableFeature", fList);
            this.dataService.add("Protocol", (Entity)prot);
            this.dataService.add("DataSet", (Entity)dataSet);
            this.searchService.indexRepository((Repository)new ProtocolTreeRepository(dataSet.getProtocolUsed(), this.dataService, "protocolTree-" + dataSet.getId()));
            this.searchService.indexRepository((Repository)new CategoryRepository(dataSet.getProtocolUsed(), dataSet.getId(), this.dataService));
        }
        return "";
    }

    private List<String> checkExistingFeatures(List<String> featureIdentifiers) {
        ArrayList<String> existingFeatures = new ArrayList<String>();
        if (featureIdentifiers.size() > 0) {
            Iterable features = this.dataService.findAll("ObservableFeature", new QueryImpl().in("Identifier", new ArrayList<String>(featureIdentifiers)), ObservableFeature.class);
            for (ObservableFeature feature : features) {
                existingFeatures.add(feature.getName());
            }
        }
        return existingFeatures;
    }

    @Override
    @Transactional
    public void removeAnnotations(Integer dataSetId) {
        DataSet dataSet = (DataSet)this.dataService.findOne("DataSet", (Object)dataSetId, DataSet.class);
        QueryImpl q = new QueryImpl();
        q.pageSize(100000);
        q.addRule(new QueryRule("type", QueryRule.Operator.SEARCH, "observablefeature"));
        SearchRequest request = new SearchRequest("protocolTree-" + dataSet.getId(), (Query)q, null);
        SearchResult result = this.searchService.search(request);
        ArrayList<Integer> listOfFeatureIds = new ArrayList<Integer>();
        for (Hit hit : result) {
            Map columnMapValues = hit.getColumnValueMap();
            Integer featureId = Integer.parseInt(columnMapValues.get("id").toString());
            listOfFeatureIds.add(featureId);
        }
        ArrayList<ObservableFeature> featuresToUpdate = new ArrayList<ObservableFeature>();
        if (!listOfFeatureIds.isEmpty()) {
            Iterable features = this.dataService.findAll("ObservableFeature", new QueryImpl().in("id", listOfFeatureIds), ObservableFeature.class);
            for (ObservableFeature feature : features) {
                List definitions = feature.getDefinitions();
                if (definitions == null || definitions.size() <= 0) continue;
                ObservableFeature newFeature = this.copyObject(feature);
                newFeature.setDefinitions(new ArrayList());
                featuresToUpdate.add(newFeature);
            }
        }
        if (!featuresToUpdate.isEmpty()) {
            this.dataService.update("ObservableFeature", featuresToUpdate);
        }
    }

    public ObservableFeature copyObject(ObservableFeature feature) {
        ObservableFeature newFeature = new ObservableFeature();
        for (String field : feature.getAttributeNames()) {
            newFeature.set(field, feature.get(field));
        }
        return newFeature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void annotate(Integer dataSetId, List<String> documentTypes) {
        runningProcesses.incrementAndGet();
        try {
            if (documentTypes == null) {
                documentTypes = this.searchAllOntologies();
            }
            PorterStemmer stemmer = new PorterStemmer();
            QueryImpl q = new QueryImpl();
            q.pageSize(100000);
            q.addRule(new QueryRule("type", QueryRule.Operator.SEARCH, "observablefeature"));
            SearchRequest request = new SearchRequest("protocolTree-" + dataSetId, (Query)q, null);
            SearchResult result = this.searchService.search(request);
            ArrayList<ObservableFeature> featuresToUpdate = new ArrayList<ObservableFeature>();
            for (Hit hit : result) {
                Integer featureId = Integer.parseInt(hit.getColumnValueMap().get("id").toString());
                ObservableFeature f = (ObservableFeature)this.dataService.findOne("ObservableFeature", (Object)featureId, ObservableFeature.class);
                ObservableFeature feature = this.toObservableFeature(f);
                String name = hit.getColumnValueMap().get("name").toString().toLowerCase().replaceAll("[^(a-zA-Z0-9\\s)]", "").trim();
                String description = hit.getColumnValueMap().get("description").toString().toLowerCase().replaceAll("[^(a-zA-Z0-9\\s)]", "").trim();
                ArrayList<OntologyTerm> definitions = new ArrayList<OntologyTerm>();
                for (String documentType : documentTypes) {
                    this.addIfNotExists(definitions, this.annotateDataItem(this.dataService, documentType, feature, name, stemmer));
                    this.addIfNotExists(definitions, this.annotateDataItem(this.dataService, documentType, feature, description, stemmer));
                }
                this.addIfNotExists(definitions, feature.getDefinitions());
                feature.setDefinitions(definitions);
                featuresToUpdate.add(feature);
            }
            this.dataService.update("ObservableFeature", featuresToUpdate);
        }
        finally {
            runningProcesses.decrementAndGet();
            this.complete = true;
        }
    }

    private void addIfNotExists(List<OntologyTerm> existing, List<OntologyTerm> toAdd) {
        for (OntologyTerm ot : toAdd) {
            if (this.contains(existing, ot)) continue;
            existing.add(ot);
        }
    }

    private boolean contains(List<OntologyTerm> ontologyTerms, OntologyTerm ontologyTerm) {
        for (OntologyTerm ot : ontologyTerms) {
            if (!ot.getIdentifier().equals(ontologyTerm.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    public List<String> searchAllOntologies() {
        ArrayList<String> ontologyUris = new ArrayList<String>();
        QueryImpl q = new QueryImpl();
        q.pageSize(100000);
        q.addRule(new QueryRule("entity_type", QueryRule.Operator.SEARCH, "indexedOntology"));
        SearchResult result = this.searchService.search(new SearchRequest(null, (Query)q, null));
        for (Hit hit : result.getSearchHits()) {
            Map columnValueMap = hit.getColumnValueMap();
            if (!columnValueMap.containsKey("url")) continue;
            ontologyUris.add("ontologyTerm-" + columnValueMap.get("url").toString());
        }
        return ontologyUris;
    }

    @Override
    public void updateIndex(UpdateIndexRequest request) {
        try {
            for (String documentId : request.getDocumentIds()) {
                this.searchService.updateDocumentById(request.getDocumentType(), documentId, request.getUpdateScript());
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception calling searchservice for request [" + request + "]"), (Throwable)e);
        }
    }

    private ObservableFeature toObservableFeature(ObservableFeature feature) {
        ObservableFeature newFeature = new ObservableFeature();
        for (String field : feature.getAttributeNames()) {
            newFeature.set(field, feature.get(field));
        }
        return newFeature;
    }

    public List<OntologyTerm> annotateDataItem(DataService dataService, String documentType, ObservableFeature feature, String description, PorterStemmer stemmer) {
        HashSet<String> uniqueTerms = new HashSet<String>();
        for (String eachTerm : Arrays.asList(description.split(" +"))) {
            if (NGramMatchingModel.STOPWORDSLIST.contains(eachTerm = eachTerm.toLowerCase()) || uniqueTerms.contains(eachTerm)) continue;
            uniqueTerms.add(eachTerm);
        }
        QueryImpl q = new QueryImpl();
        q.pageSize(100);
        boolean first = true;
        for (String term : uniqueTerms) {
            if (term.isEmpty() || term.matches(" +")) continue;
            if (!first) {
                q.addRule(new QueryRule(QueryRule.Operator.OR));
            }
            term = term.replaceAll("[^(a-zA-Z0-9 )]", "");
            q.addRule(new QueryRule("ontologyTermSynonym", QueryRule.Operator.SEARCH, term));
            first = false;
        }
        SearchRequest request = new SearchRequest(documentType, (Query)q, null);
        Iterator iterator = this.searchService.search(request).getSearchHits().iterator();
        ArrayList<TermComparison> listOfHits = new ArrayList<TermComparison>();
        while (iterator.hasNext()) {
            Hit hit = (Hit)iterator.next();
            listOfHits.add(new TermComparison(hit));
        }
        Collections.sort(listOfHits);
        HashSet<String> positionFilter = new HashSet<String>();
        HashSet<String> addedCandidates = new HashSet<String>();
        HashMap<String, Map> mapUriTerm = new HashMap<String, Map>();
        uniqueTerms = this.stemMembers(new ArrayList<String>(uniqueTerms), stemmer);
        for (TermComparison termComparision : listOfHits) {
            Hit hit = termComparision.getHit();
            Map data = hit.getColumnValueMap();
            String ontologyTermSynonym = data.get("ontologyTermSynonym").toString().toLowerCase();
            String ontologyTerm = data.get("ontologyTerm").toString().toLowerCase();
            if (!ontologyTerm.equals(ontologyTermSynonym) && addedCandidates.contains(ontologyTermSynonym) || !this.validateOntologyTerm(uniqueTerms, ontologyTermSynonym, stemmer, positionFilter)) continue;
            String uri = data.get("ontologyTermIRI").toString();
            String ontologyLabel = data.get("ontologyLabel").toString();
            String termIdentifier = ontologyLabel == null ? uri : ontologyLabel + ":" + uri;
            mapUriTerm.put(termIdentifier, data);
            addedCandidates.add(ontologyTermSynonym);
        }
        ArrayList<String> identifiers = new ArrayList<String>();
        if (feature.getDefinitions() != null) {
            for (OntologyTerm ot : feature.getDefinitions()) {
                identifiers.add(ot.getIdentifier());
            }
        }
        for (String uri : mapUriTerm.keySet()) {
            if (identifiers.contains(uri)) continue;
            identifiers.add(uri);
        }
        if (mapUriTerm.size() > 0) {
            Iterable ots = dataService.findAll("OntologyTerm", new QueryImpl().in("Identifier", new ArrayList(mapUriTerm.keySet())), OntologyTerm.class);
            for (OntologyTerm ot : ots) {
                mapUriTerm.remove(ot.getIdentifier());
            }
        }
        ArrayList<OntologyTerm> listOfOntologyTerms = new ArrayList<OntologyTerm>();
        HashMap<String, String> ontologyInfo = new HashMap<String, String>();
        for (Map data : mapUriTerm.values()) {
            String uri = data.get("ontologyTermIRI").toString();
            String ontologyUri = data.get("ontologyIRI").toString();
            String ontologyName = data.get("ontologyName").toString();
            ontologyInfo.put(ontologyUri, ontologyName);
            String ontologyLabel = data.get("ontologyLabel") == null ? "" : data.get("ontologyLabel").toString();
            String ontologyTermSynonym = data.get("ontologyTermSynonym").toString();
            String term = ontologyLabel.isEmpty() ? ontologyTermSynonym.toLowerCase() : ontologyLabel + ":" + ontologyTermSynonym.toLowerCase();
            String termIdentifier = ontologyLabel.isEmpty() ? uri : ontologyLabel + ":" + uri;
            OntologyTerm ot = new OntologyTerm();
            ot.setIdentifier(termIdentifier);
            ot.setTermAccession(uri);
            ot.setName(term);
            ot.setDefinition(ontologyTermSynonym);
            Ontology ontology = (Ontology)dataService.findOne("Ontology", new QueryImpl().eq("Identifier", (Object)ontologyUri), Ontology.class);
            ot.setOntology(ontology);
            listOfOntologyTerms.add(ot);
        }
        if (listOfOntologyTerms.size() > 0) {
            this.addOntologies(ontologyInfo);
        }
        if (listOfOntologyTerms.size() > 0) {
            dataService.add("OntologyTerm", listOfOntologyTerms);
        }
        if (identifiers.isEmpty()) {
            return Collections.emptyList();
        }
        Iterable definitions = dataService.findAll("OntologyTerm", new QueryImpl().in("Identifier", identifiers), OntologyTerm.class);
        return Lists.newArrayList((Iterable)definitions);
    }

    private void addOntologies(Map<String, String> ontologyInfo) {
        ArrayList<String> ontologyUris = new ArrayList<String>();
        ArrayList<Ontology> listOfOntologies = new ArrayList<Ontology>();
        Iterable ontologies = this.dataService.findAll("Ontology", new QueryImpl().in("ontologyURI", new ArrayList<String>(ontologyInfo.keySet())), Ontology.class);
        for (Ontology ontology : ontologies) {
            ontologyUris.add(ontology.getOntologyURI());
        }
        for (Map.Entry entry : ontologyInfo.entrySet()) {
            String ontologyUri = (String)entry.getKey();
            String ontologyName = (String)entry.getValue();
            if (ontologyUris.contains(ontologyUri)) continue;
            Ontology ontology = new Ontology();
            ontology.setName(ontologyName);
            ontology.setIdentifier(ontologyUri);
            ontology.setOntologyURI(ontologyUri);
            listOfOntologies.add(ontology);
        }
        if (listOfOntologies.size() != 0) {
            this.dataService.add("Ontology", listOfOntologies);
        }
    }

    private boolean validateOntologyTerm(Set<String> uniqueSets, String ontologyTermSynonym, PorterStemmer stemmer, Set<String> positionFilter) {
        Set<String> termsFromDescription = this.stemMembers(Arrays.asList(ontologyTermSynonym.split(" +")), stemmer);
        for (String eachTerm : termsFromDescription) {
            if (uniqueSets.contains(eachTerm)) continue;
            return false;
        }
        for (String eachTerm : termsFromDescription) {
            if (positionFilter.contains(eachTerm)) {
                return false;
            }
            positionFilter.add(eachTerm);
        }
        return true;
    }

    private Set<String> stemMembers(List<String> originalList, PorterStemmer stemmer) {
        HashSet<String> newList = new HashSet<String>();
        for (String eachTerm : originalList) {
            stemmer.setCurrent(eachTerm);
            stemmer.stem();
            eachTerm = stemmer.getCurrent();
            newList.add(eachTerm);
        }
        return newList;
    }

    public QueryRule[] toNestedQuery(List<QueryRule> rules) {
        QueryRule[] nestedQuery = new QueryRule[rules.size()];
        rules.toArray(nestedQuery);
        return nestedQuery;
    }

    @Override
    public float finishedPercentage() {
        return 0.0f;
    }

    class TermComparison
    implements Comparable<TermComparison> {
        private final Hit hit;
        private final Integer synonymLength;
        private final Integer termLength;

        public TermComparison(Hit hit) {
            Map data = hit.getColumnValueMap();
            String ontologyTermSynonym = data.get("ontologyTermSynonym").toString().toLowerCase();
            String ontologyTerm = data.get("ontologyTerm").toString().toLowerCase();
            this.hit = hit;
            this.synonymLength = ontologyTermSynonym.split(" +").length;
            this.termLength = ontologyTerm.split(" +").length;
        }

        private Integer getSynonymLength() {
            return this.synonymLength;
        }

        private Integer getTermLength() {
            return this.termLength;
        }

        public Hit getHit() {
            return this.hit;
        }

        @Override
        public int compareTo(TermComparison other) {
            if (this.synonymLength.compareTo(other.getSynonymLength()) == 0) {
                return this.termLength.compareTo(other.getTermLength());
            }
            return this.synonymLength.compareTo(other.getSynonymLength()) * -1;
        }
    }
}

