/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.Countable;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.support.AbstractRepository;
import org.molgenis.data.support.DefaultAttributeMetaData;
import org.molgenis.data.support.DefaultEntityMetaData;
import org.molgenis.data.support.MapEntity;
import org.molgenis.omx.biobankconnect.utils.OntologyLoader;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;

public class OntologyTermRepository
extends AbstractRepository
implements Countable {
    private final OntologyLoader loader;
    private final String ontologyIRI;
    private final String ontologyName;
    private final String name;
    private static final String NODE_PATH = "nodePath";
    private static final String BOOST = "boost";
    private static final String ONTOLOGY_IRI = "ontologyIRI";
    private static final String ONTOLOGY_NAME = "ontologyName";
    private static final String ONTOLOGY_TERM = "ontologyTerm";
    private static final String ONTOLOGY_TERM_IRI = "ontologyTermIRI";
    private static final String SYNONYMS = "ontologyTermSynonym";
    private static final String ALTERNATIVE_DEFINITION = "alternativeDefinition";
    private static final String ONTOLOGY_LABEL = "ontologyLabel";
    private static final String ENTITY_TYPE = "entity_type";

    public OntologyTermRepository(OntologyLoader loader, String name) {
        super("ontologyterm://" + name);
        this.loader = loader;
        this.ontologyName = this.loader.getOntologyName();
        this.ontologyIRI = this.loader.getOntologyIRI();
        this.name = name;
    }

    public long count() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        this.createOntologyTable(entities, this.loader);
        return entities.size();
    }

    public Iterator<Entity> iterator() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        this.createOntologyTable(entities, this.loader);
        return entities.iterator();
    }

    public void close() throws IOException {
    }

    public EntityMetaData getEntityMetaData() {
        DefaultEntityMetaData metaData = new DefaultEntityMetaData(this.name, MapEntity.class);
        metaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(NODE_PATH, MolgenisFieldTypes.FieldTypeEnum.STRING));
        metaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(BOOST, MolgenisFieldTypes.FieldTypeEnum.STRING));
        metaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(ONTOLOGY_IRI, MolgenisFieldTypes.FieldTypeEnum.STRING));
        metaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(ONTOLOGY_TERM, MolgenisFieldTypes.FieldTypeEnum.STRING));
        metaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(ONTOLOGY_TERM_IRI, MolgenisFieldTypes.FieldTypeEnum.STRING));
        metaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(ONTOLOGY_LABEL, MolgenisFieldTypes.FieldTypeEnum.STRING));
        metaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(SYNONYMS, MolgenisFieldTypes.FieldTypeEnum.STRING));
        metaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(ENTITY_TYPE, MolgenisFieldTypes.FieldTypeEnum.STRING));
        metaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(ALTERNATIVE_DEFINITION, MolgenisFieldTypes.FieldTypeEnum.STRING));
        return metaData;
    }

    private void createOntologyTable(List<Entity> entities, OntologyLoader model) {
        int count = 0;
        for (OWLClass subClass : model.getTopClasses()) {
            this.recursiveAddEntity("0." + count, subClass, model, entities);
            ++count;
        }
    }

    private void recursiveAddEntity(String termPath, OWLClass cls, OntologyLoader ontologyLoader, List<Entity> entities) {
        String label = ontologyLoader.getLabel((OWLEntity)cls).replaceAll("[^a-zA-Z0-9 ]", " ");
        HashSet<String> synonyms = new HashSet<String>();
        synonyms.add(label);
        synonyms.addAll(ontologyLoader.getSynonyms(cls));
        StringBuilder alternativeDefinitions = new StringBuilder();
        for (Set<OWLClass> alternativeDefinition : ontologyLoader.getAssociatedClasses(cls)) {
            StringBuilder newDefinition = new StringBuilder();
            for (OWLClass associatedClass : alternativeDefinition) {
                if (newDefinition.length() != 0) {
                    newDefinition.append(',');
                }
                newDefinition.append(associatedClass.getIRI().toString());
            }
            if (alternativeDefinitions.length() != 0 && newDefinition.length() != 0) {
                alternativeDefinitions.append("&&&");
            }
            alternativeDefinitions.append((CharSequence)newDefinition);
        }
        if (alternativeDefinitions.length() != 0) {
            System.out.println(alternativeDefinitions.toString());
        }
        for (String synonym : synonyms) {
            MapEntity entity = new MapEntity();
            entity.set(NODE_PATH, (Object)termPath);
            entity.set(BOOST, (Object)false);
            entity.set(ONTOLOGY_IRI, (Object)this.ontologyIRI);
            entity.set(ONTOLOGY_NAME, (Object)this.ontologyName);
            entity.set(ONTOLOGY_TERM, (Object)label);
            entity.set(ONTOLOGY_TERM_IRI, (Object)cls.getIRI().toString());
            entity.set(ONTOLOGY_LABEL, (Object)ontologyLoader.getOntologyName());
            entity.set(ENTITY_TYPE, (Object)ONTOLOGY_TERM);
            entity.set(SYNONYMS, (Object)synonym.replaceAll("[^a-zA-Z0-9 ]", " "));
            entity.set(ALTERNATIVE_DEFINITION, (Object)alternativeDefinitions.toString());
            entities.add((Entity)entity);
        }
        Set<OWLClass> listOfChildren = ontologyLoader.getChildClass(cls);
        if (listOfChildren.size() > 0) {
            int i = 0;
            for (OWLClass childClass : listOfChildren) {
                String childTermPath = termPath + "." + i;
                this.recursiveAddEntity(childTermPath, childClass, ontologyLoader, entities);
                ++i;
            }
        }
    }
}

