/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.algorithm;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.Repository;
import org.molgenis.data.elasticsearch.SearchService;
import org.molgenis.data.elasticsearch.util.Hit;
import org.molgenis.data.elasticsearch.util.SearchRequest;
import org.molgenis.data.elasticsearch.util.SearchResult;
import org.molgenis.data.omx.OmxRepository;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.data.validation.DefaultEntityValidator;
import org.molgenis.data.validation.EntityAttributesValidator;
import org.molgenis.data.validation.EntityValidator;
import org.molgenis.js.ScriptEvaluator;
import org.molgenis.omx.biobankconnect.wizard.CurrentUserStatus;
import org.molgenis.omx.dataset.DataSetMatrixRepository;
import org.molgenis.omx.datasetdeleter.DataSetDeleterService;
import org.molgenis.omx.observ.Category;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.omx.observ.ObservationSet;
import org.molgenis.omx.observ.ObservedValue;
import org.molgenis.omx.observ.value.CategoricalValue;
import org.molgenis.omx.observ.value.DecimalValue;
import org.molgenis.omx.observ.value.IntValue;
import org.molgenis.omx.observ.value.StringValue;
import org.molgenis.omx.observ.value.Value;
import org.molgenis.security.runas.RunAsSystem;
import org.molgenis.security.user.UserAccountService;
import org.mozilla.javascript.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.transaction.annotation.Transactional;

public class ApplyAlgorithms {
    @Autowired
    private DataService dataService;
    @Autowired
    private SearchService searchService;
    @Autowired
    private CurrentUserStatus currentUserStatus;
    @Autowired
    private UserAccountService userAccountService;
    @Autowired
    private DataSetDeleterService dataSetDeleterService;
    private static final String CATALOGUE_PREFIX = "protocolTree-";
    private static final String ENTITY_ID = "id";
    private static final String ENTITY_TYPE = "type";
    private static final String STORE_MAPPING_FEATURE = "store_mapping_feature";
    private static final String STORE_MAPPING_ALGORITHM_SCRIPT = "store_mapping_algorithm_script";
    private static final Map<String, Class<? extends Value>> entityMap = new HashMap<String, Class<? extends Value>>();

    @Async
    @RunAsSystem
    @Transactional
    public void applyAlgorithm(String userName, Integer targetDataSetId, List<Integer> sourceDataSetIds) {
        this.currentUserStatus.setUserCurrentStage(userName, CurrentUserStatus.STAGE.DeleteMapping);
        this.removeExistingDerivedDataSets(userName, targetDataSetId, sourceDataSetIds);
        this.currentUserStatus.setUserCurrentStage(userName, CurrentUserStatus.STAGE.CreateMapping);
        this.createDerivedDataSets(userName, targetDataSetId, sourceDataSetIds);
        SearchResult allFeaturesResult = this.findAllFeatures(targetDataSetId);
        this.currentUserStatus.setUserTotalNumberOfQueries(userName, allFeaturesResult.getTotalHitCount() * (long)sourceDataSetIds.size());
        QueryImpl query = new QueryImpl();
        query.pageSize(Integer.MAX_VALUE);
        for (Hit hit : allFeaturesResult.getSearchHits()) {
            if (query.getRules().size() > 0) {
                query.addRule(new QueryRule(QueryRule.Operator.OR));
            }
            query.addRule(new QueryRule(STORE_MAPPING_FEATURE, QueryRule.Operator.EQUALS, hit.getColumnValueMap().get(ENTITY_ID)));
        }
        this.generateValues(userName, query, targetDataSetId, sourceDataSetIds);
        this.currentUserStatus.setUserCurrentStage(userName, CurrentUserStatus.STAGE.StoreMapping);
        this.searchService.indexRepository((Repository)new DataSetMatrixRepository(this.dataService, ApplyAlgorithms.createDerivedDataSetIdentifier(userName, targetDataSetId.toString(), StringUtils.join(sourceDataSetIds, (char)'-'))));
        this.currentUserStatus.setUserIsRunning(userName, false);
    }

    private void generateValues(String userName, QueryImpl query, Integer targetDataSetId, List<Integer> sourceDataSetIds) {
        String derivedDataSetIdentifier = ApplyAlgorithms.createDerivedDataSetIdentifier(userName, targetDataSetId.toString(), StringUtils.join(sourceDataSetIds, (char)'-'));
        DataSet derivedDataSet = (DataSet)this.dataService.findOne("DataSet", new QueryImpl().eq("Identifier", (Object)derivedDataSetIdentifier), DataSet.class);
        HashMap<Integer, ObservationSet> observationSetMap = new HashMap<Integer, ObservationSet>();
        ArrayList<ObservedValue> listOfObservedValues = new ArrayList<ObservedValue>();
        for (Integer sourceDataSetId : sourceDataSetIds) {
            SearchResult searchResult = this.searchService.search(new SearchRequest(this.createMappingDataSetIdentifier(userName, targetDataSetId, sourceDataSetId), (Query)query, null));
            for (Hit hit : searchResult.getSearchHits()) {
                Integer featureId = Integer.parseInt(hit.getColumnValueMap().get(STORE_MAPPING_FEATURE).toString());
                ObservableFeature feature = (ObservableFeature)this.dataService.findOne("ObservableFeature", (Object)featureId, ObservableFeature.class);
                String algorithmScript = hit.getColumnValueMap().get(STORE_MAPPING_ALGORITHM_SCRIPT).toString();
                for (Map.Entry<Integer, Object> entry : this.createValueFromAlgorithm(feature.getDataType(), sourceDataSetId, algorithmScript).entrySet()) {
                    Integer observationSetId = entry.getKey();
                    if (!observationSetMap.containsKey(observationSetId)) {
                        ObservationSet observationSet = new ObservationSet();
                        observationSet.setIdentifier(this.createObservationSetIdentifier(userName, targetDataSetId, sourceDataSetId, observationSetId));
                        observationSet.setPartOfDataSet(derivedDataSet);
                        observationSetMap.put(observationSetId, observationSet);
                    }
                    ObservedValue observedValue = new ObservedValue();
                    observedValue.setFeature(feature);
                    observedValue.setObservationSet((ObservationSet)observationSetMap.get(observationSetId));
                    this.addValueByType(feature, observedValue, entry.getValue());
                    listOfObservedValues.add(observedValue);
                }
                this.currentUserStatus.incrementFinishedNumbersByOne(userName);
            }
        }
        this.dataService.add("ObservationSet", observationSetMap.values());
        this.dataService.add("ObservedValue", listOfObservedValues);
        this.dataService.getCrudRepository("ObservedValue").flush();
    }

    private void addValueByType(ObservableFeature feature, ObservedValue observedValue, Object value) {
        if (feature.getDataType().equalsIgnoreCase(MolgenisFieldTypes.FieldTypeEnum.INT.toString())) {
            IntValue intValue = new IntValue();
            intValue.setValue(Integer.valueOf(Integer.parseInt(value.toString())));
            this.dataService.add("IntValue", (Entity)intValue);
            observedValue.setValue((Value)intValue);
        } else if (feature.getDataType().equalsIgnoreCase(MolgenisFieldTypes.FieldTypeEnum.DECIMAL.toString())) {
            DecimalValue decimalValue = new DecimalValue();
            decimalValue.setValue(Double.valueOf(Double.parseDouble(value.toString())));
            this.dataService.add("DecimalValue", (Entity)decimalValue);
            observedValue.setValue((Value)decimalValue);
        } else if (feature.getDataType().equalsIgnoreCase(MolgenisFieldTypes.FieldTypeEnum.STRING.toString())) {
            StringValue stringValue = new StringValue();
            stringValue.setValue(value.toString());
            this.dataService.add("StringValue", (Entity)stringValue);
            observedValue.setValue((Value)stringValue);
        } else if (feature.getDataType().equalsIgnoreCase(MolgenisFieldTypes.FieldTypeEnum.CATEGORICAL.toString())) {
            Category category = (Category)this.dataService.findOne("Category", new QueryImpl().eq("observableFeature", (Object)feature).and().eq("valueCode", (Object)value.toString()), Category.class);
            CategoricalValue categoricalValue = new CategoricalValue();
            categoricalValue.setValue(category);
            this.dataService.add("CategoricalValue", (Entity)categoricalValue);
            observedValue.setValue((Value)categoricalValue);
        }
    }

    private void removeExistingDerivedDataSets(String userName, Integer targetDataSetId, List<Integer> sourceDataSetIds) {
        String dataSetIdentifier = ApplyAlgorithms.createDerivedDataSetIdentifier(userName, targetDataSetId.toString(), StringUtils.join(sourceDataSetIds, (char)'-'));
        DataSet derivedDataSet = (DataSet)this.dataService.findOne("DataSet", new QueryImpl().eq("Identifier", (Object)dataSetIdentifier), DataSet.class);
        HashMap valuesByType = new HashMap();
        if (derivedDataSet != null) {
            Iterable observationSets = this.dataService.findAll("ObservationSet", new QueryImpl().eq("partOfDataSet", (Object)derivedDataSet), ObservationSet.class);
            if (Iterables.size((Iterable)observationSets) > 0) {
                Iterable observedValues = this.dataService.findAll("ObservedValue", new QueryImpl().in("ObservationSet", observationSets), ObservedValue.class);
                this.currentUserStatus.setUserTotalNumberOfQueries(userName, Long.valueOf(Iterables.size((Iterable)observedValues) * sourceDataSetIds.size()));
                for (ObservedValue value : observedValues) {
                    String valueType = value.getValue().get__Type();
                    Integer valueId = value.getId();
                    if (!valuesByType.containsKey(valueType)) {
                        valuesByType.put(valueType, new ArrayList());
                    }
                    ((List)valuesByType.get(valueType)).add(valueId);
                }
            }
            this.dataSetDeleterService.deleteData(dataSetIdentifier, false);
            this.dataService.delete("DataSet", (Entity)derivedDataSet);
            for (Map.Entry entryValuesByType : valuesByType.entrySet()) {
                String valueType = (String)entryValuesByType.getKey();
                ArrayList ids = new ArrayList((Collection)entryValuesByType.getValue());
                this.dataService.delete(valueType, this.dataService.findAll(valueType, ids));
                this.currentUserStatus.incrementFinishedNumbers(userName, ids.size());
            }
            this.dataService.getCrudRepository("ObservedValue").flush();
        }
    }

    private DataSet createDerivedDataSets(String userName, Integer targetDataSetId, List<Integer> sourceDataSetIds) {
        DataSet targetDataSet = (DataSet)this.dataService.findOne("DataSet", (Object)targetDataSetId, DataSet.class);
        DataSet derivedDataSet = new DataSet();
        derivedDataSet.setIdentifier(ApplyAlgorithms.createDerivedDataSetIdentifier(userName, targetDataSet.getId().toString(), sourceDataSetIds));
        derivedDataSet.setName(this.createDerivedDataSetName(userName, targetDataSet.getName()));
        derivedDataSet.setProtocolUsed(targetDataSet.getProtocolUsed());
        this.dataService.add("DataSet", (Entity)derivedDataSet);
        this.dataService.getCrudRepository("DataSet").flush();
        if (!this.dataService.hasRepository(derivedDataSet.getIdentifier())) {
            this.dataService.addRepository((Repository)new OmxRepository(this.dataService, this.searchService, derivedDataSet.getIdentifier(), (EntityValidator)new DefaultEntityValidator(this.dataService, new EntityAttributesValidator())));
        }
        return derivedDataSet;
    }

    private SearchResult findAllFeatures(Integer targetDataSetId) {
        QueryImpl query = new QueryImpl();
        query.addRule(new QueryRule(ENTITY_TYPE, QueryRule.Operator.EQUALS, ObservableFeature.class.getSimpleName().toLowerCase()));
        query.pageSize(1000000);
        DataSet dataSet = (DataSet)this.dataService.findOne("DataSet", (Object)targetDataSetId, DataSet.class);
        return this.searchService.search(new SearchRequest(CATALOGUE_PREFIX + dataSet.getProtocolUsed().getId(), (Query)query, null));
    }

    public String validateAlgorithmInputs(Integer dataSetId, String algorithm) {
        if (StringUtils.isEmpty((CharSequence)algorithm)) {
            return "Algorithm is not defined!";
        }
        Iterable featureIterators = this.dataService.findAll("ObservableFeature", new QueryImpl().in("Name", ApplyAlgorithms.extractFeatureName(algorithm)), ObservableFeature.class);
        if (Iterables.size((Iterable)featureIterators) == 0) {
            return "Variables are not found! Please check the name of variables!";
        }
        DataSet sourceDataSet = (DataSet)this.dataService.findOne("DataSet", (Object)dataSetId, DataSet.class);
        Iterable observationSets = this.dataService.findAll("ObservationSet", new QueryImpl().eq("partOfDataSet", (Object)sourceDataSet), ObservationSet.class);
        if (Iterables.size((Iterable)observationSets) == 0) {
            return "There are not rows in this dataset!";
        }
        return "";
    }

    public Map<Integer, Object> createValueFromAlgorithm(String dataType, Integer sourceDataSetId, String algorithmScript) {
        if (StringUtils.isEmpty((CharSequence)algorithmScript)) {
            return Collections.emptyMap();
        }
        List<String> featureNames = ApplyAlgorithms.extractFeatureName(algorithmScript);
        Iterable featureIterators = this.dataService.findAll("ObservableFeature", new QueryImpl().in("Name", featureNames), ObservableFeature.class);
        DataSet sourceDataSet = (DataSet)this.dataService.findOne("DataSet", (Object)sourceDataSetId, DataSet.class);
        Iterable observationSets = this.dataService.findAll("ObservationSet", new QueryImpl().eq("partOfDataSet", (Object)sourceDataSet), ObservationSet.class);
        Iterable observedValueIterators = this.dataService.findAll("ObservedValue", new QueryImpl().and().in("Feature", featureIterators).and().in("ObservationSet", observationSets), ObservedValue.class);
        HashMap<Integer, MapEntity> eachIndividualValues = new HashMap<Integer, MapEntity>();
        for (ObservedValue value : observedValueIterators) {
            Object valueObject;
            ObservationSet observationSet = value.getObservationSet();
            Integer observationSetId = observationSet.getId();
            if (!eachIndividualValues.containsKey(observationSetId)) {
                eachIndividualValues.put(observationSetId, new MapEntity());
            }
            if ((valueObject = value.getValue().get("value")) instanceof String) {
                ((MapEntity)eachIndividualValues.get(observationSetId)).set(value.getFeature().getName(), (Object)value.getValue().get("value").toString());
                continue;
            }
            if (valueObject instanceof Integer) {
                ((MapEntity)eachIndividualValues.get(observationSetId)).set(value.getFeature().getName(), (Object)Integer.parseInt(value.getValue().get("value").toString()));
                continue;
            }
            if (valueObject instanceof Double) {
                ((MapEntity)eachIndividualValues.get(observationSetId)).set(value.getFeature().getName(), (Object)Double.parseDouble(value.getValue().get("value").toString()));
                continue;
            }
            if (!(valueObject instanceof Category)) continue;
            ((MapEntity)eachIndividualValues.get(observationSetId)).set(value.getFeature().getName(), (Object)Integer.parseInt(((Category)value.getValue().get("value")).getValueCode()));
        }
        HashMap<Integer, Object> calculatedResults = new HashMap<Integer, Object>();
        for (Map.Entry entry : eachIndividualValues.entrySet()) {
            if (Iterables.size((Iterable)((MapEntity)entry.getValue()).getAttributeNames()) != featureNames.size()) continue;
            Object result = ScriptEvaluator.eval((String)algorithmScript, (Entity)((Entity)entry.getValue()));
            if (dataType.equalsIgnoreCase(MolgenisFieldTypes.FieldTypeEnum.INT.toString())) {
                calculatedResults.put((Integer)entry.getKey(), Integer.parseInt(Context.toString((Object)result)));
                continue;
            }
            if (dataType.equalsIgnoreCase(MolgenisFieldTypes.FieldTypeEnum.CATEGORICAL.toString())) {
                calculatedResults.put((Integer)entry.getKey(), Integer.parseInt(Context.toString((Object)result)));
                continue;
            }
            if (dataType.equalsIgnoreCase(MolgenisFieldTypes.FieldTypeEnum.DECIMAL.toString())) {
                calculatedResults.put((Integer)entry.getKey(), Context.toNumber((Object)result));
                continue;
            }
            calculatedResults.put((Integer)entry.getKey(), Context.toString((Object)result));
        }
        return calculatedResults;
    }

    public static List<String> extractFeatureName(String algorithmScript) {
        ArrayList<String> featureNames = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\$\\('([^\\$\\(\\)]*)'\\)");
        Matcher matcher = pattern.matcher(algorithmScript);
        while (matcher.find()) {
            if (featureNames.contains(matcher.group(1))) continue;
            featureNames.add(matcher.group(1));
        }
        if (featureNames.size() > 0) {
            return featureNames;
        }
        pattern = Pattern.compile("\\$\\(([^\\$\\(\\)]*)\\)");
        matcher = pattern.matcher(algorithmScript);
        while (matcher.find()) {
            if (featureNames.contains(matcher.group(1))) continue;
            featureNames.add(matcher.group(1));
        }
        return featureNames;
    }

    private String createObservationSetIdentifier(String userName, Integer targetDataSetId, Integer sourceDataSetId, Integer observationSetId) {
        StringBuilder observationSetIdentifier = new StringBuilder();
        observationSetIdentifier.append(userName).append('-').append(targetDataSetId).append('-').append(sourceDataSetId).append('-').append(observationSetId);
        return observationSetIdentifier.toString();
    }

    public static String createDerivedDataSetIdentifier(String userName, String targetDataSetId, List<Integer> sourceDataSetIds) {
        Collections.sort(sourceDataSetIds);
        return ApplyAlgorithms.createDerivedDataSetIdentifier(userName, targetDataSetId, StringUtils.join(sourceDataSetIds, (char)'-'));
    }

    public static String createDerivedDataSetIdentifier(String userName, String targetDataSetId, String sourceDataSetId) {
        StringBuilder dataSetIdentifier = new StringBuilder();
        dataSetIdentifier.append(userName).append('-').append(targetDataSetId).append('-').append(sourceDataSetId).append("-derived");
        return dataSetIdentifier.toString();
    }

    private String createDerivedDataSetName(String userName, String targetDataSetName) {
        StringBuilder dataSetIdentifier = new StringBuilder();
        dataSetIdentifier.append(userName).append(": derived dataset for ").append(targetDataSetName);
        return dataSetIdentifier.toString();
    }

    private String createMappingDataSetIdentifier(String userName, Integer targetDataSetId, Integer sourceDataSetId) {
        StringBuilder dataSetIdentifier = new StringBuilder();
        dataSetIdentifier.append(userName).append('-').append(targetDataSetId).append('-').append(sourceDataSetId);
        return dataSetIdentifier.toString();
    }

    static {
        entityMap.put("StringValue", StringValue.class);
        entityMap.put("IntValue", IntValue.class);
        entityMap.put("DecimalValue", DecimalValue.class);
        entityMap.put("CategoricalValue", CategoricalValue.class);
    }
}

