/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.ontology.repository;

import java.util.Iterator;
import org.molgenis.data.Countable;
import org.molgenis.data.Entity;
import org.molgenis.data.elasticsearch.SearchService;
import org.molgenis.data.support.MapEntity;
import org.molgenis.omx.biobankconnect.ontology.repository.AbstractOntologyRepository;
import org.molgenis.omx.biobankconnect.utils.OntologyLoader;

public class OntologyIndexRepository
extends AbstractOntologyRepository
implements Countable {
    private final OntologyLoader ontologyLoader;
    public static final String TYPE_ONTOLOGY = "indexedOntology";

    public OntologyIndexRepository(OntologyLoader loader, String name, SearchService searchService) {
        super(name, searchService);
        if (loader == null) {
            throw new IllegalArgumentException("OntologyLoader is null!");
        }
        this.ontologyLoader = loader;
    }

    public Iterator<Entity> iterator() {
        return new Iterator<Entity>(){
            private int count = 0;

            @Override
            public boolean hasNext() {
                if ((long)this.count < OntologyIndexRepository.this.count()) {
                    ++this.count;
                    return true;
                }
                return false;
            }

            @Override
            public Entity next() {
                MapEntity entity = new MapEntity();
                entity.set("ontologyIRI", (Object)OntologyIndexRepository.this.ontologyLoader.getOntologyIRI());
                entity.set("ontologyName", (Object)OntologyIndexRepository.this.ontologyLoader.getOntologyName());
                entity.set("entity_type", (Object)OntologyIndexRepository.TYPE_ONTOLOGY);
                return entity;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public long count() {
        return 1L;
    }

    @Override
    public <E extends Entity> Iterable<E> iterator(Class<E> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getUrl() {
        throw new UnsupportedOperationException();
    }
}

