/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.ontology.repository;

import java.util.ArrayList;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.Queryable;
import org.molgenis.data.elasticsearch.SearchService;
import org.molgenis.data.elasticsearch.util.Hit;
import org.molgenis.data.elasticsearch.util.SearchRequest;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.omx.biobankconnect.ontology.repository.AbstractOntologyQueryRepository;
import org.molgenis.omx.biobankconnect.ontologyservice.OntologyService;
import org.molgenis.omx.biobankconnect.ontologytree.OntologyEntity;
import org.springframework.beans.factory.annotation.Autowired;

public class OntologyQueryRepository
extends AbstractOntologyQueryRepository {
    public static final String DEFAULT_ONTOLOGY_REPO = "ontologyindex";
    private static final String BASE_URL = "ontologyindex://";
    private final OntologyService ontologySerivce;

    @Autowired
    public OntologyQueryRepository(String entityName, OntologyService ontologyService, SearchService searchService) {
        super(entityName, searchService);
        this.ontologySerivce = ontologyService;
    }

    public Iterable<Entity> findAll(Query q) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        if (q.getRules().size() > 0) {
            q.and();
        }
        q.eq("entity_type", (Object)"indexedOntology");
        for (Hit hit : this.searchService.search(new SearchRequest(null, q, null)).getSearchHits()) {
            entities.add((Entity)new OntologyEntity(hit, this.getEntityMetaData(), this.ontologySerivce, this.searchService));
        }
        return entities;
    }

    public Entity findOne(Query q) {
        if (q.getRules().size() > 0) {
            q.and();
        }
        q.eq("entity_type", (Object)"indexedOntology");
        Hit hit = this.findOneInternal(null, q);
        if (hit != null) {
            return new OntologyEntity(hit, this.getEntityMetaData(), this.ontologySerivce, this.searchService);
        }
        return null;
    }

    public Entity findOne(Object id) {
        Hit hit = this.searchService.searchById(null, id.toString());
        if (hit != null) {
            return new OntologyEntity(hit, this.getEntityMetaData(), this.ontologySerivce, this.searchService);
        }
        return null;
    }

    public Query query() {
        return new QueryImpl((Queryable)this);
    }

    public long count(Query q) {
        if (q.getRules().size() > 0) {
            q.and();
        }
        q.eq("entity_type", (Object)"indexedOntology");
        return this.searchService.count(null, q.pageSize(Integer.MAX_VALUE).offset(Integer.MIN_VALUE));
    }

    @Override
    public String getUrl() {
        return BASE_URL + this.entityName;
    }
}

