/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.ontologymatcher;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.elasticsearch.common.collect.Iterables;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.Repository;
import org.molgenis.data.elasticsearch.SearchService;
import org.molgenis.data.elasticsearch.util.Hit;
import org.molgenis.data.elasticsearch.util.MultiSearchRequest;
import org.molgenis.data.elasticsearch.util.SearchRequest;
import org.molgenis.data.elasticsearch.util.SearchResult;
import org.molgenis.data.omx.OmxRepository;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.data.validation.DefaultEntityValidator;
import org.molgenis.data.validation.EntityAttributesValidator;
import org.molgenis.data.validation.EntityValidator;
import org.molgenis.omx.biobankconnect.algorithm.ApplyAlgorithms;
import org.molgenis.omx.biobankconnect.ontologyindexer.AsyncOntologyIndexer;
import org.molgenis.omx.biobankconnect.ontologymatcher.OntologyMatcher;
import org.molgenis.omx.biobankconnect.ontologymatcher.OntologyMatcherRequest;
import org.molgenis.omx.biobankconnect.utils.NGramMatchingModel;
import org.molgenis.omx.biobankconnect.utils.StoreMappingRepository;
import org.molgenis.omx.biobankconnect.wizard.CurrentUserStatus;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.omx.observ.ObservationSet;
import org.molgenis.omx.observ.ObservedValue;
import org.molgenis.omx.observ.Protocol;
import org.molgenis.omx.observ.target.OntologyTerm;
import org.molgenis.omx.observ.value.IntValue;
import org.molgenis.omx.observ.value.StringValue;
import org.molgenis.omx.observ.value.Value;
import org.molgenis.security.runas.RunAsSystem;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.tartarus.snowball.ext.PorterStemmer;

public class AsyncOntologyMatcher
implements OntologyMatcher,
InitializingBean {
    private static final Logger logger = Logger.getLogger(AsyncOntologyMatcher.class);
    public static final String PROTOCOL_IDENTIFIER = "store_mapping";
    public static final String STORE_MAPPING_FEATURE = "store_mapping_feature";
    public static final String STORE_MAPPING_MAPPED_FEATURE = "store_mapping_mapped_feature";
    public static final String STORE_MAPPING_CONFIRM_MAPPING = "store_mapping_confirm_mapping";
    public static final String STORE_MAPPING_SCORE = "store_mapping_score";
    public static final String STORE_MAPPING_ALGORITHM_SCRIPT = "store_mapping_algorithm_script";
    private static final String CATALOGUE_PREFIX = "protocolTree-";
    private static final String FEATURE_CATEGORY = "featureCategory-";
    private static final String FIELD_DESCRIPTION_STOPWORDS = "descriptionStopwords";
    private static final String FIELD_BOOST_ONTOLOGYTERM = "boostOntologyTerms";
    private static final String ONTOLOGY_IRI = "ontologyIRI";
    private static final String OBSERVATION_SET = "observationsetid";
    private static final String ONTOLOGYTERM_SYNONYM = "ontologyTermSynonym";
    private static final String ONTOLOGY_TERM = "ontologyTerm";
    private static final String ONTOLOGY_TERM_IRI = "ontologyTermIRI";
    private static final String ALTERNATIVE_DEFINITION = "alternativeDefinition";
    private static final String NODE_PATH = "nodePath";
    private static final String ENTITY_ID = "id";
    private static final String ENTITY_TYPE = "type";
    private static final String PATTERN_MATCH = "[^a-zA-Z0-9 ]";
    private static final String COMMON_SEPERATOR = ",";
    private static final String ALTERNATIVE_DEFINITION_SEPERATOR = "&&&";
    private static final int DEFAULT_RETRIEVAL_DOCUMENTS_SIZE = 50;
    private static final String MULTIPLE_NUMBERS_PATTERN = "[0-9]+";
    private static final String NODEPATH_SEPARATOR = "\\.";
    private static final AtomicInteger runningProcesses = new AtomicInteger();
    @Autowired
    private DataService dataService;
    @Autowired
    private CurrentUserStatus currentUserStatus;
    private SearchService searchService;

    @Autowired
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.searchService == null) {
            throw new IllegalArgumentException("Missing bean of type SearchService");
        }
    }

    @Override
    public boolean isRunning() {
        return runningProcesses.get() != 0;
    }

    @Override
    public Integer matchPercentage(String currentUserName) {
        return this.currentUserStatus.getPercentageOfProcessForUser(currentUserName);
    }

    @Override
    public void deleteDocumentByIds(String documentType, List<String> documentIds) {
        this.searchService.deleteDocumentByIds(documentType, documentIds);
    }

    @Override
    @RunAsSystem
    @Transactional
    public void match(String userName, Integer selectedDataSetId, List<Integer> dataSetIdsToMatch, Integer featureId) {
        this.createMappingStore(userName, selectedDataSetId, dataSetIdsToMatch);
    }

    @Override
    @Transactional
    public SearchResult generateMapping(String userName, Integer featureId, Integer targetDataSetId, Integer sourceDataSetId) {
        PorterStemmer stemmer = new PorterStemmer();
        DataSet sourceDataSet = (DataSet)this.dataService.findOne("DataSet", (Object)sourceDataSetId, DataSet.class);
        DataSet targetDataSet = (DataSet)this.dataService.findOne("DataSet", (Object)targetDataSetId, DataSet.class);
        SearchResult mappedFeatures = this.findMappingsByAnnotation(featureId, sourceDataSet);
        if (mappedFeatures.getTotalHitCount() > 0L) {
            return mappedFeatures;
        }
        SearchResult result = this.retrieveFeatureFromIndex(targetDataSet.getProtocolUsed().getId(), Arrays.asList(featureId));
        List searchHits = result.getSearchHits();
        if (searchHits.size() > 0) {
            Hit hit = (Hit)searchHits.get(0);
            Map columnValueMap = hit.getColumnValueMap();
            ObservableFeature feature = (ObservableFeature)this.dataService.findOne("ObservableFeature", (Object)featureId, ObservableFeature.class);
            if (feature != null) {
                List<String> boostedOntologyTermUris = Arrays.asList(columnValueMap.get(FIELD_BOOST_ONTOLOGYTERM).toString().split(COMMON_SEPERATOR));
                String description = StringUtils.isEmpty((CharSequence)feature.getDescription()) ? feature.getName().replaceAll(PATTERN_MATCH, " ") : feature.getDescription().replaceAll(PATTERN_MATCH, " ");
                List ontologyTermUris = Lists.transform((List)feature.getDefinitions(), (Function)new Function<OntologyTerm, String>(){

                    public String apply(OntologyTerm ontologyTerm) {
                        return ontologyTerm.getTermAccession();
                    }
                });
                Collection<OntologyTermContainer> ontologyTermContainers = this.collectOntologyTermInfo(ontologyTermUris, boostedOntologyTermUris);
                List<QueryRule> subQueryRules = this.createQueryRules(description, ontologyTermContainers, stemmer);
                List<QueryRule> subQueryRules_2 = this.getAlternativeOTs(description, ontologyTermContainers, stemmer);
                List<QueryRule> subQueryRules_3 = this.getExistingMappings(feature, stemmer, AsyncOntologyMatcher.createMappingDataSetIdentifier(userName, targetDataSetId, sourceDataSetId));
                QueryRule finalQueryRule = new QueryRule(new ArrayList());
                finalQueryRule.getNestedRules().add(new QueryRule(FIELD_DESCRIPTION_STOPWORDS, QueryRule.Operator.EQUALS, this.removeStopWords(description)));
                finalQueryRule.getNestedRules().add(new QueryRule("description", QueryRule.Operator.EQUALS, this.removeStopWords(description)));
                finalQueryRule.setOperator(QueryRule.Operator.DIS_MAX);
                finalQueryRule.getNestedRules().addAll(subQueryRules);
                finalQueryRule.getNestedRules().addAll(subQueryRules_2);
                finalQueryRule.getNestedRules().addAll(subQueryRules_3);
                return this.searchDisMaxQuery(sourceDataSet.getProtocolUsed().getId().toString(), (Query)new QueryImpl(finalQueryRule));
            }
        }
        return new SearchResult(0L, Collections.emptyList());
    }

    private List<QueryRule> getExistingMappings(ObservableFeature desiredDataElement, PorterStemmer stemmer, String dataSetIdentifier) {
        ArrayList<QueryRule> queryRules = new ArrayList<QueryRule>();
        SearchResult searchResult = this.searchService.search(new SearchRequest(null, new QueryImpl().eq(STORE_MAPPING_FEATURE, (Object)desiredDataElement.getId()).pageSize(Integer.MAX_VALUE), null));
        ArrayList<String> mappedFeatureIds = new ArrayList<String>();
        for (Hit hit : searchResult.getSearchHits()) {
            String mappedIds;
            Object entityID;
            if (hit.getDocumentType().equals(dataSetIdentifier) || (entityID = hit.getColumnValueMap().get(STORE_MAPPING_MAPPED_FEATURE)) == null || (mappedIds = entityID.toString()).length() <= 2) continue;
            for (String id : mappedIds.substring(1, mappedIds.length() - 1).split(COMMON_SEPERATOR)) {
                mappedFeatureIds.add(id.trim());
            }
        }
        if (mappedFeatureIds.size() > 0) {
            Iterable mappedFeatures = this.dataService.findAll("ObservableFeature", mappedFeatureIds, ObservableFeature.class);
            for (ObservableFeature feature : mappedFeatures) {
                String description = feature.getDescription();
                if (StringUtils.isEmpty((CharSequence)description)) continue;
                description = StringUtils.join(this.stemMembers(Arrays.asList(this.removeStopWords(description).split(" +")), stemmer), (String)" ");
                queryRules.add(new QueryRule("description", QueryRule.Operator.EQUALS, description));
                queryRules.add(new QueryRule(FIELD_DESCRIPTION_STOPWORDS, QueryRule.Operator.EQUALS, description));
            }
        }
        return queryRules;
    }

    private SearchResult findMappingsByAnnotation(Integer featureId, DataSet sourceDataSet) {
        ObservableFeature featureOfInterest = (ObservableFeature)this.dataService.findOne("ObservableFeature", (Object)featureId, ObservableFeature.class);
        ArrayList candidateFeatureIds = new ArrayList();
        for (Hit hit : this.retrieveFeatureFromIndex(sourceDataSet.getProtocolUsed().getId(), null)) {
            candidateFeatureIds.add(hit.getColumnValueMap().get(ENTITY_ID));
        }
        ArrayList<Integer> featureOfInterestIds = new ArrayList<Integer>();
        if (featureOfInterest.getDefinitions().size() != 0) {
            Iterable iterableObserableFeatures = this.dataService.findAll("ObservableFeature", new QueryImpl().in("definitions", (Iterable)featureOfInterest.getDefinitions()).and().in(ENTITY_ID, candidateFeatureIds), ObservableFeature.class);
            for (ObservableFeature observableFeature : iterableObserableFeatures) {
                List definitions = observableFeature.getDefinitions();
                List definitions1 = featureOfInterest.getDefinitions();
                if (definitions.size() != definitions1.size()) continue;
                definitions.removeAll(definitions1);
                if (definitions.size() != 0) continue;
                featureOfInterestIds.add(observableFeature.getId());
            }
        }
        return featureOfInterestIds.size() == 0 ? new SearchResult(0L, Collections.emptyList()) : this.retrieveFeatureFromIndex(sourceDataSet.getProtocolUsed().getId(), featureOfInterestIds);
    }

    private SearchResult retrieveFeatureFromIndex(Integer protocolId, Iterable<Integer> featureIds) {
        QueryImpl query = new QueryImpl();
        query.pageSize(Integer.MAX_VALUE);
        if (featureIds != null && Iterables.size(featureIds) > 0) {
            for (Integer featureId : featureIds) {
                if (query.getRules().size() > 0) {
                    query.addRule(new QueryRule(QueryRule.Operator.OR));
                }
                query.addRule(new QueryRule(ENTITY_ID, QueryRule.Operator.EQUALS, (Object)featureId));
            }
        } else {
            query.addRule(new QueryRule(ENTITY_TYPE, QueryRule.Operator.EQUALS, ObservableFeature.class.getSimpleName().toLowerCase()));
        }
        return this.searchService.search(new SearchRequest(CATALOGUE_PREFIX + protocolId, (Query)query, null));
    }

    private SearchResult searchDisMaxQuery(String protocolId, Query q) {
        SearchResult result = null;
        try {
            q.pageSize(50);
            MultiSearchRequest request = new MultiSearchRequest(Arrays.asList(CATALOGUE_PREFIX + protocolId, FEATURE_CATEGORY + protocolId), q, null);
            result = this.searchService.multiSearch(request);
        }
        catch (Exception e) {
            result = new SearchResult(e.getMessage());
            logger.error((Object)("Exception failed to search the request " + result), (Throwable)e);
        }
        return result;
    }

    private Collection<OntologyTermContainer> collectOntologyTermInfo(List<String> ontologyTermUris, List<String> boostedOntologyTerms) {
        if (ontologyTermUris == null || ontologyTermUris.size() == 0) {
            return Collections.emptyList();
        }
        HashMap<String, OntologyTermContainer> totalHits = new HashMap<String, OntologyTermContainer>();
        Query query = new QueryImpl().pageSize(Integer.MAX_VALUE);
        for (String ontologyTermUri : ontologyTermUris) {
            if (query.getRules().size() > 0) {
                query.or();
            }
            query.eq(ONTOLOGY_TERM_IRI, (Object)ontologyTermUri);
        }
        SearchResult result = this.searchService.search(new SearchRequest(null, query, null));
        for (Hit hit : result.getSearchHits()) {
            Map columnValueMap = hit.getColumnValueMap();
            String ontologyIRI = columnValueMap.get(ONTOLOGY_IRI).toString();
            String ontologyTermUri = columnValueMap.get(ONTOLOGY_TERM_IRI).toString();
            String ontologyTermNameSynonym = columnValueMap.get(ONTOLOGYTERM_SYNONYM).toString();
            String ontologyTermName = columnValueMap.get(ONTOLOGY_TERM).toString();
            boolean boost = boostedOntologyTerms.contains(ontologyTermUri);
            if (!ontologyTermName.equalsIgnoreCase(ontologyTermNameSynonym)) continue;
            String nodePath = columnValueMap.get(NODE_PATH).toString();
            if (!totalHits.containsKey(ontologyIRI)) {
                totalHits.put(ontologyIRI, new OntologyTermContainer(ontologyIRI));
            }
            String alternativeDefinitions = columnValueMap.get(ALTERNATIVE_DEFINITION) == null ? "" : columnValueMap.get(ALTERNATIVE_DEFINITION).toString();
            ((OntologyTermContainer)totalHits.get(ontologyIRI)).getAllPaths().put(nodePath, boost);
            ((OntologyTermContainer)totalHits.get(ontologyIRI)).getSelectedOntologyTerms().add(hit.getId());
            ((OntologyTermContainer)totalHits.get(ontologyIRI)).getAlternativeDefinitions().put(nodePath, alternativeDefinitions);
        }
        return totalHits.values();
    }

    private List<QueryRule> createQueryRules(String description, Collection<OntologyTermContainer> ontologyTermContainers, PorterStemmer stemmer) {
        Integer locationNotFound = -1;
        ArrayList<QueryRule> queryRules = new ArrayList<QueryRule>();
        ArrayList<QueryRule> shouldQueryRules = new ArrayList<QueryRule>();
        List<String> uniqueTokens = this.stemMembers(Arrays.asList(description.split(" +")), stemmer);
        for (OntologyTermContainer ontologyTermContainer : ontologyTermContainers) {
            HashSet<String> existingQueryStrings = new HashSet<String>();
            for (Map.Entry<String, Boolean> entry : ontologyTermContainer.getAllPaths().entrySet()) {
                String currentNodePath = entry.getKey();
                int parentNodeLevel = currentNodePath.split(NODEPATH_SEPARATOR).length;
                Query query = new QueryImpl().eq(NODE_PATH, (Object)entry.getKey()).pageSize(Integer.MAX_VALUE);
                SearchResult result = this.searchService.search(new SearchRequest(AsyncOntologyIndexer.createOntologyTermDocumentType(ontologyTermContainer.getOntologyIRI()), query, null));
                Pattern pattern = Pattern.compile(MULTIPLE_NUMBERS_PATTERN);
                Matcher matcher = null;
                int finalIndexPosition = locationNotFound;
                ArrayList<QueryRule> subQueryRules = new ArrayList<QueryRule>();
                QueryRule disJunctQuery = new QueryRule(subQueryRules);
                disJunctQuery.setOperator(QueryRule.Operator.DIS_MAX);
                for (Hit hit : result.getSearchHits()) {
                    String ontologyTermSynonym;
                    Map columnValueMap = hit.getColumnValueMap();
                    String nodePath = columnValueMap.get(NODE_PATH).toString();
                    if (!nodePath.startsWith(currentNodePath) || existingQueryStrings.contains(ontologyTermSynonym = columnValueMap.get(ONTOLOGYTERM_SYNONYM).toString().trim().toLowerCase())) continue;
                    existingQueryStrings.add(ontologyTermSynonym);
                    if (finalIndexPosition == locationNotFound) {
                        finalIndexPosition = this.locateTermInDescription(uniqueTokens, ontologyTermSynonym, stemmer);
                    }
                    if (!(nodePath.equals(currentNodePath) || (matcher = pattern.matcher(ontologyTermSynonym)).find() || StringUtils.isEmpty((CharSequence)ontologyTermSynonym))) {
                        int levelDown = nodePath.split(NODEPATH_SEPARATOR).length - parentNodeLevel;
                        double boostedNumber = Math.pow(0.5, levelDown);
                        StringBuilder boostedSynonym = new StringBuilder();
                        for (String eachToken : ontologyTermSynonym.split(" +")) {
                            if (eachToken.length() != 0) {
                                boostedSynonym.append(" ");
                            }
                            boostedSynonym.append(eachToken).append('^').append(boostedNumber);
                        }
                        ontologyTermSynonym = boostedSynonym.toString();
                    }
                    if (StringUtils.isEmpty((CharSequence)ontologyTermSynonym)) continue;
                    subQueryRules.add(new QueryRule(FIELD_DESCRIPTION_STOPWORDS, QueryRule.Operator.EQUALS, ontologyTermSynonym));
                    subQueryRules.add(new QueryRule("description", QueryRule.Operator.EQUALS, ontologyTermSynonym));
                }
                if (finalIndexPosition == locationNotFound) {
                    if (disJunctQuery.getNestedRules().size() <= 0) continue;
                    queryRules.add(disJunctQuery);
                    continue;
                }
                if (disJunctQuery.getNestedRules().size() <= 0) continue;
                shouldQueryRules.add(disJunctQuery);
            }
        }
        if (shouldQueryRules.size() > 0) {
            if (shouldQueryRules.size() != 1) {
                QueryRule combinedQuery = new QueryRule(shouldQueryRules);
                combinedQuery.setOperator(QueryRule.Operator.SHOULD);
                queryRules.add(combinedQuery);
            } else {
                queryRules.add((QueryRule)shouldQueryRules.get(0));
            }
        }
        return queryRules;
    }

    private List<QueryRule> getAlternativeOTs(String description, Collection<OntologyTermContainer> ontologyTermContainers, PorterStemmer stemmer) {
        ArrayList<QueryRule> queryRules = new ArrayList<QueryRule>();
        for (OntologyTermContainer ontologyTermContainer : ontologyTermContainers) {
            for (Map.Entry<String, String> entry : ontologyTermContainer.getAlternativeDefinitions().entrySet()) {
                String alternativeDefinitions = entry.getValue();
                if (StringUtils.isEmpty((CharSequence)alternativeDefinitions)) continue;
                String nodePath = entry.getKey();
                boolean isBoosted = ontologyTermContainer.getAllPaths().get(nodePath);
                for (String definition : alternativeDefinitions.split(ALTERNATIVE_DEFINITION_SEPERATOR)) {
                    List<String> ontologyTermUris = Arrays.asList(definition.split(COMMON_SEPERATOR));
                    queryRules.addAll(this.createQueryRules(description, this.collectOntologyTermInfo(ontologyTermUris, isBoosted ? ontologyTermUris : Collections.emptyList()), stemmer));
                }
            }
        }
        return queryRules;
    }

    private String removeStopWords(String originalTerm) {
        LinkedHashSet<String> tokens = new LinkedHashSet<String>(Arrays.asList(originalTerm.trim().toLowerCase().split(" +")));
        tokens.removeAll(NGramMatchingModel.STOPWORDSLIST);
        return StringUtils.join((Object[])tokens.toArray(), (String)" ");
    }

    private Integer locateTermInDescription(List<String> uniqueSets, String ontologyTermSynonym, PorterStemmer stemmer) {
        int finalIndex = -1;
        List<String> termsFromDescription = this.stemMembers(Arrays.asList(ontologyTermSynonym.split(" +")), stemmer);
        for (String eachTerm : termsFromDescription) {
            if (!uniqueSets.contains(eachTerm)) {
                return -1;
            }
            int currentIndex = uniqueSets.indexOf(eachTerm);
            if (finalIndex == -1) {
                finalIndex = currentIndex;
                continue;
            }
            finalIndex = finalIndex < currentIndex ? finalIndex : currentIndex;
        }
        return finalIndex;
    }

    private List<String> stemMembers(List<String> originalList, PorterStemmer stemmer) {
        ArrayList<String> newList = new ArrayList<String>();
        for (String eachTerm : originalList) {
            if (NGramMatchingModel.STOPWORDSLIST.contains(eachTerm = eachTerm.toLowerCase().trim())) continue;
            try {
                stemmer.setCurrent(eachTerm);
                stemmer.stem();
                eachTerm = stemmer.getCurrent().toLowerCase();
            }
            catch (RuntimeException e) {
                logger.error((Object)("Could not stem word : " + eachTerm), (Throwable)e);
            }
            newList.add(eachTerm);
        }
        return newList;
    }

    private void createMappingStore(String userName, Integer selectedDataSet, List<Integer> dataSetsToMatch) {
        ObservableFeature f = (ObservableFeature)this.dataService.findOne("ObservableFeature", new QueryImpl().eq("Identifier", (Object)STORE_MAPPING_FEATURE), ObservableFeature.class);
        if (f == null) {
            ArrayList<ObservableFeature> features = new ArrayList<ObservableFeature>();
            ObservableFeature feature = new ObservableFeature();
            feature.setIdentifier(STORE_MAPPING_FEATURE);
            feature.setDataType(MolgenisFieldTypes.FieldTypeEnum.INT.toString().toLowerCase());
            feature.setName("Features");
            features.add(feature);
            ObservableFeature mappedFeature = new ObservableFeature();
            mappedFeature.setIdentifier(STORE_MAPPING_MAPPED_FEATURE);
            mappedFeature.setDataType(MolgenisFieldTypes.FieldTypeEnum.STRING.toString().toLowerCase());
            mappedFeature.setName("Mapped features");
            features.add(mappedFeature);
            ObservableFeature mappedFeatureScore = new ObservableFeature();
            mappedFeatureScore.setIdentifier(STORE_MAPPING_SCORE);
            mappedFeatureScore.setDataType(MolgenisFieldTypes.FieldTypeEnum.DECIMAL.toString().toLowerCase());
            mappedFeatureScore.setName(STORE_MAPPING_SCORE);
            features.add(mappedFeatureScore);
            ObservableFeature observationSetFeature = new ObservableFeature();
            observationSetFeature.setIdentifier(OBSERVATION_SET);
            observationSetFeature.setDataType(MolgenisFieldTypes.FieldTypeEnum.INT.toString().toLowerCase());
            observationSetFeature.setName(OBSERVATION_SET);
            features.add(observationSetFeature);
            ObservableFeature algorithmScriptFeature = new ObservableFeature();
            algorithmScriptFeature.setIdentifier(STORE_MAPPING_ALGORITHM_SCRIPT);
            algorithmScriptFeature.setDataType(MolgenisFieldTypes.FieldTypeEnum.STRING.toString().toLowerCase());
            algorithmScriptFeature.setName(STORE_MAPPING_ALGORITHM_SCRIPT);
            features.add(algorithmScriptFeature);
            ObservableFeature confirmMapping = new ObservableFeature();
            confirmMapping.setIdentifier(STORE_MAPPING_CONFIRM_MAPPING);
            confirmMapping.setDataType(MolgenisFieldTypes.FieldTypeEnum.BOOL.toString().toLowerCase());
            confirmMapping.setName("Mapping confirmed");
            features.add(confirmMapping);
            this.dataService.add("ObservableFeature", features);
            Protocol protocol = new Protocol();
            protocol.setIdentifier(PROTOCOL_IDENTIFIER);
            protocol.setName(PROTOCOL_IDENTIFIER);
            protocol.setFeatures(features);
            this.dataService.add("Protocol", (Entity)protocol);
            this.dataService.getCrudRepository("ObservableFeature").flush();
        }
        for (Integer dataSetId : dataSetsToMatch) {
            String identifier = AsyncOntologyMatcher.createMappingDataSetIdentifier(userName, selectedDataSet, dataSetId);
            DataSet existing = (DataSet)this.dataService.findOne("DataSet", new QueryImpl().eq("Identifier", (Object)identifier), DataSet.class);
            if (existing != null) continue;
            DataSet dataSet = new DataSet();
            dataSet.setIdentifier(identifier);
            dataSet.setName(identifier);
            Protocol protocol = (Protocol)this.dataService.findOne("Protocol", new QueryImpl().eq("Identifier", (Object)PROTOCOL_IDENTIFIER), Protocol.class);
            dataSet.setProtocolUsed(protocol);
            this.dataService.add("DataSet", (Entity)dataSet);
            this.dataService.getCrudRepository("DataSet").flush();
            this.dataService.addRepository((Repository)new OmxRepository(this.dataService, this.searchService, identifier, (EntityValidator)new DefaultEntityValidator(this.dataService, new EntityAttributesValidator())));
        }
        this.dataService.getCrudRepository("Protocol").flush();
    }

    @Override
    @RunAsSystem
    public boolean checkExistingMappings(String dataSetIdentifier, DataService dataService) {
        DataSet dataSet = (DataSet)dataService.findOne("DataSet", new QueryImpl().eq("Identifier", (Object)dataSetIdentifier), DataSet.class);
        if (dataSet == null) {
            throw new MolgenisDataException("Unknown DataSet [" + dataSetIdentifier + "]");
        }
        Iterable listOfObservationSets = dataService.findAll("ObservationSet", new QueryImpl().eq("partOfDataSet", (Object)dataSet), ObservationSet.class);
        return Iterables.size((Iterable)listOfObservationSets) > 0;
    }

    @Override
    @RunAsSystem
    @Transactional
    public Map<String, String> updateScript(String userName, OntologyMatcherRequest request) {
        HashMap<String, String> updateResult = new HashMap<String, String>();
        List<Integer> selectedDataSetIds = request.getSelectedDataSetIds();
        Integer targetDataSetId = request.getTargetDataSetId();
        this.createMappingStore(userName, targetDataSetId, selectedDataSetIds);
        boolean toUpdate = false;
        for (Integer selectedDataSetId : selectedDataSetIds) {
            String mappingDataSetIdentifier = AsyncOntologyMatcher.createMappingDataSetIdentifier(userName, targetDataSetId, selectedDataSetId);
            toUpdate = this.updateExistingMapping(mappingDataSetIdentifier, request);
            if (toUpdate) continue;
            this.addNewMappingToDatabase(mappingDataSetIdentifier, request);
        }
        updateResult.put("message", toUpdate ? "the script has been updated!" : "the script has been added to the database!");
        return updateResult;
    }

    private void addNewMappingToDatabase(String mappingDataSetIdentifier, OntologyMatcherRequest request) {
        ArrayList<ObservedValue> listOfNewObservedValues = new ArrayList<ObservedValue>();
        DataSet storingMappingDataSet = (DataSet)this.dataService.findOne("DataSet", new QueryImpl().eq("Identifier", (Object)mappingDataSetIdentifier), DataSet.class);
        ObservationSet observationSet = new ObservationSet();
        observationSet.setIdentifier(mappingDataSetIdentifier + "-" + request.getFeatureId());
        observationSet.setPartOfDataSet(storingMappingDataSet);
        this.dataService.add("ObservationSet", (Entity)observationSet);
        IntValue xrefForFeature = new IntValue();
        xrefForFeature.setValue(request.getFeatureId());
        this.dataService.add("IntValue", (Entity)xrefForFeature);
        ObservedValue valueForFeature = new ObservedValue();
        valueForFeature.setObservationSet(observationSet);
        ObservableFeature smf = (ObservableFeature)this.dataService.findOne("ObservableFeature", new QueryImpl().eq("Identifier", (Object)STORE_MAPPING_FEATURE), ObservableFeature.class);
        valueForFeature.setFeature(smf);
        valueForFeature.setValue((Value)xrefForFeature);
        listOfNewObservedValues.add(valueForFeature);
        StringValue algorithmScriptValue = new StringValue();
        algorithmScriptValue.setValue(request.getAlgorithmScript() == null ? "" : request.getAlgorithmScript());
        this.dataService.add("StringValue", (Entity)algorithmScriptValue);
        ObservedValue algorithmScriptObservedValue = new ObservedValue();
        algorithmScriptObservedValue.setObservationSet(observationSet);
        ObservableFeature algorithmScriptFeature = (ObservableFeature)this.dataService.findOne("ObservableFeature", new QueryImpl().eq("Identifier", (Object)STORE_MAPPING_ALGORITHM_SCRIPT), ObservableFeature.class);
        algorithmScriptObservedValue.setFeature(algorithmScriptFeature);
        algorithmScriptObservedValue.setValue((Value)algorithmScriptValue);
        listOfNewObservedValues.add(algorithmScriptObservedValue);
        IntValue observationSetIntValue = new IntValue();
        observationSetIntValue.setValue(observationSet.getId());
        this.dataService.add("IntValue", (Entity)observationSetIntValue);
        ObservedValue valueForObservationSet = new ObservedValue();
        ObservableFeature observationSetFeature = (ObservableFeature)this.dataService.findOne("ObservableFeature", new QueryImpl().eq("Identifier", (Object)OBSERVATION_SET), ObservableFeature.class);
        valueForObservationSet.setFeature(observationSetFeature);
        valueForObservationSet.setObservationSet(observationSet);
        valueForObservationSet.setValue((Value)observationSetIntValue);
        listOfNewObservedValues.add(valueForObservationSet);
        ObservedValue valueForMappedFeatures = new ObservedValue();
        ObservableFeature SMMF = (ObservableFeature)this.dataService.findOne("ObservableFeature", new QueryImpl().eq("Identifier", (Object)STORE_MAPPING_MAPPED_FEATURE), ObservableFeature.class);
        StringValue mappedFeatureValues = new StringValue();
        mappedFeatureValues.setValue(this.convertToFeatureIds(request));
        this.dataService.add("StringValue", (Entity)mappedFeatureValues);
        valueForMappedFeatures.setFeature(SMMF);
        valueForMappedFeatures.setValue((Value)mappedFeatureValues);
        valueForMappedFeatures.setObservationSet(observationSet);
        listOfNewObservedValues.add(valueForMappedFeatures);
        this.dataService.add("ObservedValue", listOfNewObservedValues);
        this.dataService.getCrudRepository("ObservedValue").flush();
        this.searchService.updateRepositoryIndex((Repository)new StoreMappingRepository(storingMappingDataSet, listOfNewObservedValues, this.dataService));
    }

    private boolean updateExistingMapping(String mappingDataSetIdentifier, OntologyMatcherRequest request) {
        QueryImpl query = new QueryImpl();
        query.pageSize(Integer.MAX_VALUE);
        query.addRule(new QueryRule(STORE_MAPPING_FEATURE, QueryRule.Operator.EQUALS, (Object)request.getFeatureId()));
        SearchResult result = this.searchService.search(new SearchRequest(mappingDataSetIdentifier, (Query)query, null));
        if (result.getTotalHitCount() > 0L) {
            Hit hit = (Hit)result.getSearchHits().get(0);
            Map columnValueMap = hit.getColumnValueMap();
            ObservationSet observationSet = (ObservationSet)this.dataService.findOne("ObservationSet", (Object)Integer.parseInt(columnValueMap.get(OBSERVATION_SET).toString()), ObservationSet.class);
            if (observationSet == null) {
                return false;
            }
            Object existingScript = columnValueMap.get(STORE_MAPPING_ALGORITHM_SCRIPT);
            String algorithmScript = request.getAlgorithmScript();
            if (algorithmScript != null && !existingScript.toString().trim().equalsIgnoreCase(algorithmScript.trim())) {
                ObservableFeature storeMappingAlgorithmScriptFeature = (ObservableFeature)this.dataService.findOne("ObservableFeature", new QueryImpl().eq("Identifier", (Object)STORE_MAPPING_ALGORITHM_SCRIPT), ObservableFeature.class);
                ObservedValue algorithmScriptObservedValue = (ObservedValue)this.dataService.findOne("ObservedValue", new QueryImpl().eq("ObservationSet", (Object)observationSet).and().eq("Feature", (Object)storeMappingAlgorithmScriptFeature), ObservedValue.class);
                if (algorithmScriptObservedValue != null && algorithmScriptObservedValue.getValue() instanceof StringValue) {
                    StringValue algorithmScriptValue = (StringValue)algorithmScriptObservedValue.getValue();
                    algorithmScriptValue.setValue(algorithmScript);
                    this.dataService.update("StringValue", (Entity)algorithmScriptValue);
                    this.dataService.getCrudRepository("StringValue").flush();
                    this.searchService.updateDocumentById(mappingDataSetIdentifier, hit.getId(), this.constructIndexUpdateScript(STORE_MAPPING_ALGORITHM_SCRIPT, algorithmScript));
                }
            }
            Object existingMappedFeature = columnValueMap.get(STORE_MAPPING_MAPPED_FEATURE);
            String convertToFeatureIds = this.convertToFeatureIds(request);
            if (!existingMappedFeature.toString().equalsIgnoreCase(convertToFeatureIds)) {
                ObservableFeature SMMF = (ObservableFeature)this.dataService.findOne("ObservableFeature", new QueryImpl().eq("Identifier", (Object)STORE_MAPPING_MAPPED_FEATURE), ObservableFeature.class);
                ObservedValue mappedFeaturesObservedValue = (ObservedValue)this.dataService.findOne("ObservedValue", new QueryImpl().eq("ObservationSet", (Object)observationSet).and().eq("Feature", (Object)SMMF), ObservedValue.class);
                if (mappedFeaturesObservedValue != null && mappedFeaturesObservedValue.getValue() instanceof StringValue) {
                    StringValue mappedFeaturesValue = (StringValue)mappedFeaturesObservedValue.getValue();
                    mappedFeaturesValue.setValue(convertToFeatureIds);
                    this.dataService.update("StringValue", (Entity)mappedFeaturesValue);
                    this.dataService.getCrudRepository("StringValue").flush();
                    this.searchService.updateDocumentById(mappingDataSetIdentifier, hit.getId(), this.constructIndexUpdateScript(STORE_MAPPING_MAPPED_FEATURE, convertToFeatureIds.toString()));
                }
            }
        }
        return result.getTotalHitCount() > 0L;
    }

    private String constructIndexUpdateScript(String field, String newValue) {
        StringBuilder updateScriptSyntax = new StringBuilder();
        updateScriptSyntax.append(field).append('=').append("\"").append(newValue).append("\"");
        return updateScriptSyntax.toString();
    }

    private String convertToFeatureIds(OntologyMatcherRequest request) {
        ArrayList<Integer> featureIds = new ArrayList<Integer>();
        if (request.getMappedFeatureIds() != null && request.getMappedFeatureIds().size() > 0) {
            return request.getMappedFeatureIds().toString();
        }
        if (!StringUtils.isEmpty((CharSequence)request.getAlgorithmScript())) {
            ArrayList<String> selectedFeatureNames = new ArrayList<String>();
            for (String standardFeatureName : ApplyAlgorithms.extractFeatureName(request.getAlgorithmScript())) {
                selectedFeatureNames.add(standardFeatureName);
            }
            if (selectedFeatureNames.size() > 0) {
                Iterable iterators = this.dataService.findAll("ObservableFeature", new QueryImpl().in("Name", selectedFeatureNames), ObservableFeature.class);
                for (ObservableFeature feature : iterators) {
                    featureIds.add(feature.getId());
                }
            }
        }
        return featureIds.size() == 0 ? "" : ((Object)featureIds).toString();
    }

    public static String createMappingDataSetIdentifier(String userName, Integer targetDataSetId, Integer sourceDataSetId) {
        StringBuilder dataSetIdentifier = new StringBuilder();
        dataSetIdentifier.append(userName).append('-').append(targetDataSetId).append('-').append(sourceDataSetId);
        return dataSetIdentifier.toString();
    }

    public class OntologyTermContainer {
        private final String ontologyIRI;
        private final HashMap<String, String> alternativeDefinitions;
        private final Map<String, Boolean> allPaths;
        private final Set<String> selectedOntologyTerms;

        public OntologyTermContainer(String ontologyIRI) {
            this.ontologyIRI = ontologyIRI;
            this.alternativeDefinitions = new HashMap();
            this.allPaths = new HashMap<String, Boolean>();
            this.selectedOntologyTerms = new HashSet<String>();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.ontologyIRI == null ? 0 : this.ontologyIRI.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OntologyTermContainer other = (OntologyTermContainer)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.ontologyIRI == null ? other.ontologyIRI != null : !this.ontologyIRI.equals(other.ontologyIRI));
        }

        private AsyncOntologyMatcher getOuterType() {
            return AsyncOntologyMatcher.this;
        }

        public String getOntologyIRI() {
            return this.ontologyIRI;
        }

        public Map<String, Boolean> getAllPaths() {
            return this.allPaths;
        }

        public HashMap<String, String> getAlternativeDefinitions() {
            return this.alternativeDefinitions;
        }

        public Set<String> getSelectedOntologyTerms() {
            return this.selectedOntologyTerms;
        }
    }
}

