/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.ontologytree;

import java.util.ArrayList;
import java.util.Map;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Query;
import org.molgenis.data.elasticsearch.SearchService;
import org.molgenis.data.elasticsearch.util.Hit;
import org.molgenis.data.elasticsearch.util.SearchRequest;
import org.molgenis.data.elasticsearch.util.SearchResult;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.omx.biobankconnect.ontologyindexer.AsyncOntologyIndexer;
import org.molgenis.omx.biobankconnect.ontologyservice.OntologyService;
import org.molgenis.omx.biobankconnect.ontologytree.AbstractOntologyEntity;
import org.molgenis.omx.biobankconnect.ontologytree.OntologyTermEntity;

public class OntologyEntity
extends AbstractOntologyEntity {
    private static final long serialVersionUID = 1L;
    private final OntologyService ontologyService;

    public OntologyEntity(Hit hit, EntityMetaData entityMetaData, OntologyService ontologyService, SearchService searchService) {
        super(hit, entityMetaData, searchService);
        this.ontologyService = ontologyService;
    }

    public Object get(String attributeName) {
        Map columnValueMap = this.hit.getColumnValueMap();
        if (attributeName.equalsIgnoreCase("id")) {
            return this.hit.getId();
        }
        if (attributeName.equalsIgnoreCase("fieldType")) {
            String documentType = AsyncOntologyIndexer.createOntologyDocumentType(columnValueMap.get("ontologyIRI").toString());
            SearchResult result = this.searchService.search(new SearchRequest(documentType, (Query)new QueryImpl(), null));
            return result.getTotalHitCount() == 0L ? MolgenisFieldTypes.STRING.toString().toUpperCase() : MolgenisFieldTypes.COMPOUND.toString().toUpperCase();
        }
        if (attributeName.equalsIgnoreCase("isLast")) {
            String documentType = AsyncOntologyIndexer.createOntologyDocumentType(columnValueMap.get("ontologyIRI").toString());
            SearchResult result = this.searchService.search(new SearchRequest(documentType, (Query)new QueryImpl(), null));
            return result.getTotalHitCount() == 0L;
        }
        if (attributeName.equalsIgnoreCase("root")) {
            return true;
        }
        if (attributeName.equalsIgnoreCase("attributes")) {
            ArrayList<OntologyTermEntity> refEntities = new ArrayList<OntologyTermEntity>();
            for (Hit hit : this.ontologyService.getRootOntologyTerms(this.hit.getColumnValueMap().get("ontologyIRI").toString())) {
                refEntities.add(new OntologyTermEntity(hit, this.getEntityMetaData(), this.searchService));
            }
            return refEntities;
        }
        return columnValueMap.containsKey(attributeName) ? columnValueMap.get(attributeName) : null;
    }
}

