/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.ontologytree;

import java.util.ArrayList;
import java.util.Map;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Query;
import org.molgenis.data.elasticsearch.SearchService;
import org.molgenis.data.elasticsearch.util.Hit;
import org.molgenis.data.elasticsearch.util.SearchRequest;
import org.molgenis.data.elasticsearch.util.SearchResult;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.omx.biobankconnect.ontologyindexer.AsyncOntologyIndexer;
import org.molgenis.omx.biobankconnect.ontologytree.AbstractOntologyEntity;

public class OntologyTermEntity
extends AbstractOntologyEntity {
    private static final long serialVersionUID = 1L;

    public OntologyTermEntity(Hit hit, EntityMetaData entityMetaData, SearchService searchService) {
        super(hit, entityMetaData, searchService);
    }

    public Object get(String attributeName) {
        Map columnValueMap = this.hit.getColumnValueMap();
        if (attributeName.equalsIgnoreCase("id")) {
            return this.hit.getId();
        }
        if (attributeName.equalsIgnoreCase("fieldType")) {
            return Boolean.parseBoolean(columnValueMap.get("isLast").toString()) ? MolgenisFieldTypes.STRING.toString().toUpperCase() : MolgenisFieldTypes.COMPOUND.toString().toUpperCase();
        }
        if (attributeName.equalsIgnoreCase("attributes")) {
            ArrayList<OntologyTermEntity> refEntities = new ArrayList<OntologyTermEntity>();
            if (!Boolean.parseBoolean(columnValueMap.get("isLast").toString())) {
                String currentNodePath = columnValueMap.get("nodePath").toString();
                String currentOntologyTermIri = columnValueMap.get("ontologyTermIRI").toString();
                String ontologyIri = columnValueMap.get("ontologyIRI").toString();
                Query q = new QueryImpl().eq("parentNodePath", (Object)currentNodePath).and().eq("parentOntologyTermIRI", (Object)currentOntologyTermIri).pageSize(Integer.MAX_VALUE);
                String documentType = AsyncOntologyIndexer.createOntologyTermDocumentType(ontologyIri);
                SearchRequest searchRequest = new SearchRequest(documentType, q, null);
                SearchResult result = this.searchService.search(searchRequest);
                for (Hit hit : result.getSearchHits()) {
                    refEntities.add(new OntologyTermEntity(hit, this.getEntityMetaData(), this.searchService));
                }
            }
            return refEntities;
        }
        return columnValueMap.containsKey(attributeName) ? columnValueMap.get(attributeName) : null;
    }
}

