/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.tartarus.snowball.ext.PorterStemmer;

public class NGramMatchingModel {
    private static int nGrams = 2;
    private static PorterStemmer stemmer = new PorterStemmer();
    public static final Set<String> STOPWORDSLIST = new HashSet<String>(Arrays.asList("a", "you", "about", "above", "after", "again", "against", "all", "am", "an", "and", "any", "are", "aren't", "as", "at", "be", "because", "been", "before", "being", "below", "between", "both", "but", "by", "can't", "cannot", "could", "couldn't", "did", "didn't", "do", "does", "doesn't", "doing", "don't", "down", "during", "each", "few", "for", "from", "further", "had", "hadn't", "has", "hasn't", "have", "haven't", "having", "he", "he'd", "he'll", "he's", "her", "here", "here's", "hers", "herself", "him", "himself", "his", "how", "how's", "i", "i'd", "i'll", "i'm", "i've", "if", "in", "into", "is", "isn't", "it", "it's", "its", "itself", "let's", "me", "more", "most", "mustn't", "my", "myself", "no", "nor", "not", "of", "off", "on", "once", "only", "or", "other", "ought", "our", "ours ", " ourselves", "out", "over", "own", "same", "shan't", "she", "she'd", "she'll", "she's", "should", "shouldn't", "so", "some", "such", "than", "that", "that's", "the", "their", "theirs", "them", "themselves", "then", "there", "there's", "these", "they", "they'd", "they'll", "they're", "they've", "this", "those", "through", "to", "too", "under", "until", "up", "very", "was", "wasn't", "we", "we'd", "we'll", "we're", "we've", "were", "weren't", "what", "what's", "when", "when's", "where", "where's", "which", "while", "who", "who's", "whom", "why", "why's", "with", "won't", "would", "wouldn't", "you", "you'd", "you'll", "you're", "you've", "your", "yours", "yourself", "yourselves", "many", ")", "("));

    public static double stringMatching(String queryOne, String queryTwo) {
        double similarityScore = NGramMatchingModel.calculateScore(NGramMatchingModel.createNGrams(queryOne.toLowerCase().trim(), true), NGramMatchingModel.createNGrams(queryTwo.toLowerCase().trim(), true));
        return similarityScore;
    }

    public static double stringMatching(String queryOne, String queryTwo, boolean removeStopWords) {
        double similarityScore = NGramMatchingModel.calculateScore(NGramMatchingModel.createNGrams(queryOne.toLowerCase().trim(), removeStopWords), NGramMatchingModel.createNGrams(queryTwo.toLowerCase().trim(), removeStopWords));
        return similarityScore;
    }

    private static Set<String> createNGrams(String inputQuery, boolean removeStopWords) {
        HashSet<String> wordsInString = new HashSet<String>(Arrays.asList(inputQuery.trim().split(" ")));
        HashSet<String> tokens = new HashSet<String>();
        if (removeStopWords) {
            wordsInString.removeAll(STOPWORDSLIST);
        }
        for (String singleWord : wordsInString) {
            singleWord = NGramMatchingModel.stemmerString(singleWord);
            StringBuilder singleString = new StringBuilder(singleWord.length() + 2);
            singleString.append('^').append(singleWord.toLowerCase()).append('$');
            int length = singleString.length();
            for (int i = 0; i < length; ++i) {
                if (i + nGrams < length) {
                    tokens.add(singleString.substring(i, i + nGrams));
                    continue;
                }
                tokens.add(singleString.substring(length - 2));
            }
        }
        return tokens;
    }

    private static double calculateScore(Set<String> inputStringTokens, Set<String> ontologyTermTokens) {
        int matchedTokens = 0;
        double totalToken = Math.max(inputStringTokens.size(), ontologyTermTokens.size());
        inputStringTokens.retainAll(ontologyTermTokens);
        matchedTokens = inputStringTokens.size();
        DecimalFormat df = new DecimalFormat("##.###", new DecimalFormatSymbols(Locale.ENGLISH));
        return Double.parseDouble(df.format((double)matchedTokens / totalToken * 100.0));
    }

    private static String stemmerString(String originalString) {
        stemmer.setCurrent(originalString.trim());
        stemmer.stem();
        return stemmer.getCurrent();
    }
}

