/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.omx.biobankconnect.utils.AbstractOmxConvertor;

public class PhenoToOmxConvertor
extends AbstractOmxConvertor {
    public PhenoToOmxConvertor(String studyName, String filePath) throws IOException, InvalidFormatException {
        super(studyName, filePath);
    }

    @Override
    public void collectProtocolInfo(RepositoryCollection repositoryCollection) throws IOException {
        try {
            Repository repo = repositoryCollection.getRepositoryByEntityName("Protocol");
            for (Entity entity : repo) {
                String name = entity.getString("name");
                if (!this.protocolFeatureLinks.containsKey(name)) {
                    this.protocolFeatureLinks.put(name, new ArrayList());
                }
                if (entity.getString("Features_name").isEmpty()) continue;
                for (String featureName : entity.getString("Features_name").split(",")) {
                    ((List)this.protocolFeatureLinks.get(name)).add(this.createFeatureIdentifier(featureName));
                }
            }
        }
        catch (UnknownEntityException e) {
            System.out.println("Missing Protocol");
        }
    }

    @Override
    public void collectVariableInfo(RepositoryCollection repositoryCollection) throws IOException {
        Repository repo = repositoryCollection.getRepositoryByEntityName("Measurement");
        for (Entity entity : repo) {
            String featureName = entity.getString("name");
            String description = entity.getString("description");
            String dataType = "string";
            if (!entity.getString("categories_name").isEmpty()) {
                dataType = "categorical";
                if (!this.featureCategoryLinks.containsKey(featureName)) {
                    this.featureCategoryLinks.put(featureName, new ArrayList());
                }
                List listOfCategories = (List)this.featureCategoryLinks.get(featureName);
                for (String categoryName : entity.getString("categories_name").split(",")) {
                    AbstractOmxConvertor.UniqueCategory category = this.copyCategoryContent((AbstractOmxConvertor.UniqueCategory)this.categoryInfo.get(categoryName));
                    category.setIdentifier(this.createCategoryIdentifier(featureName + "_" + category.getCode()));
                    if (listOfCategories.contains(category)) continue;
                    listOfCategories.add(category);
                }
                this.featureCategoryLinks.put(featureName, listOfCategories);
            }
            if (this.variableInfo.containsKey(featureName)) continue;
            AbstractOmxConvertor.UniqueVariable newVariable = new AbstractOmxConvertor.UniqueVariable(featureName, description, dataType);
            this.variableInfo.put(featureName, newVariable);
        }
    }

    @Override
    public void collectCategoryInfo(RepositoryCollection repositoryCollection) throws IOException {
        Repository repo = repositoryCollection.getRepositoryByEntityName("Category");
        for (Entity entity : repo) {
            String name = entity.getString("name");
            String description = entity.getString("description");
            String code = entity.getString("code_string");
            this.categoryInfo.put(name, new AbstractOmxConvertor.UniqueCategory(name, code, description));
        }
    }

    public AbstractOmxConvertor.UniqueCategory copyCategoryContent(AbstractOmxConvertor.UniqueCategory category) {
        return new AbstractOmxConvertor.UniqueCategory(category.getName(), category.getCode(), category.getLabel());
    }

    public static void main(String[] args) throws IOException, InvalidFormatException {
        new PhenoToOmxConvertor(args[0], args[1]);
    }
}

