/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.utils;

import java.util.Map;
import org.molgenis.data.elasticsearch.util.Hit;

public class TermComparison
implements Comparable<TermComparison> {
    private final Hit hit;
    private final Integer synonymLength;
    private final Integer termLength;

    public TermComparison(Hit hit) {
        Map data = hit.getColumnValueMap();
        String ontologyTermSynonym = data.get("ontologyTermSynonym").toString().toLowerCase();
        String ontologyTerm = data.get("ontologyTerm").toString().toLowerCase();
        this.hit = hit;
        this.synonymLength = ontologyTermSynonym.split(" +").length;
        this.termLength = ontologyTerm.split(" +").length;
    }

    private Integer getSynonymLength() {
        return this.synonymLength;
    }

    private Integer getTermLength() {
        return this.termLength;
    }

    public Hit getHit() {
        return this.hit;
    }

    @Override
    public int compareTo(TermComparison other) {
        if (this.synonymLength.compareTo(other.getSynonymLength()) == 0) {
            return this.termLength.compareTo(other.getTermLength());
        }
        return this.synonymLength.compareTo(other.getSynonymLength()) * -1;
    }
}

