/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.wizard;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.csv.CsvWriter;
import org.molgenis.data.elasticsearch.SearchService;
import org.molgenis.data.elasticsearch.util.Hit;
import org.molgenis.data.elasticsearch.util.SearchRequest;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.omx.biobankconnect.algorithm.ApplyAlgorithms;
import org.molgenis.omx.biobankconnect.ontologyannotator.OntologyAnnotator;
import org.molgenis.omx.biobankconnect.ontologyannotator.UpdateIndexRequest;
import org.molgenis.omx.biobankconnect.ontologyindexer.AsyncOntologyIndexer;
import org.molgenis.omx.biobankconnect.ontologymatcher.AlgorithmGenerateResponse;
import org.molgenis.omx.biobankconnect.ontologymatcher.AsyncOntologyMatcher;
import org.molgenis.omx.biobankconnect.ontologymatcher.OntologyMatcher;
import org.molgenis.omx.biobankconnect.ontologymatcher.OntologyMatcherRequest;
import org.molgenis.omx.biobankconnect.wizard.AlgorithmReportPage;
import org.molgenis.omx.biobankconnect.wizard.BiobankConnectWizard;
import org.molgenis.omx.biobankconnect.wizard.ChooseCataloguePage;
import org.molgenis.omx.biobankconnect.wizard.CurrentUserStatus;
import org.molgenis.omx.biobankconnect.wizard.MappingManagerPage;
import org.molgenis.omx.biobankconnect.wizard.OntologyAnnotatorPage;
import org.molgenis.omx.biobankconnect.wizard.OntologyMatcherPage;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.security.user.UserAccountService;
import org.molgenis.ui.wizard.AbstractWizardController;
import org.molgenis.ui.wizard.Wizard;
import org.molgenis.ui.wizard.WizardPage;
import org.molgenis.util.FileUploadUtils;
import org.molgenis.util.GsonHttpMessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/plugin/biobankconnect"})
public class BiobankConnectController
extends AbstractWizardController {
    public static final String ID = "biobankconnect";
    public static final String URI = "/plugin/biobankconnect";
    private final ChooseCataloguePage chooseCataloguePager;
    private final OntologyAnnotatorPage ontologyAnnotatorPager;
    private final OntologyMatcherPage ontologyMatcherPager;
    private final MappingManagerPage mappingManagerPager;
    private final AlgorithmReportPage algorithmReportPager;
    private BiobankConnectWizard wizard;
    @Autowired
    private DataService dataService;
    @Autowired
    private UserAccountService userAccountService;
    @Autowired
    private OntologyAnnotator ontologyAnnotator;
    @Autowired
    private OntologyMatcher ontologyMatcher;
    @Autowired
    private SearchService searchService;
    @Autowired
    private CurrentUserStatus currentUserStatus;

    @Autowired
    public BiobankConnectController(ChooseCataloguePage chooseCataloguePager, OntologyAnnotatorPage ontologyAnnotatorPager, OntologyMatcherPage ontologyMatcherPager, MappingManagerPage mappingManagerPager, AlgorithmReportPage algorithmReportPager) {
        super(URI, ID);
        if (chooseCataloguePager == null) {
            throw new IllegalArgumentException("ChooseCataloguePager is null");
        }
        if (ontologyAnnotatorPager == null) {
            throw new IllegalArgumentException("OntologyAnnotatorPager is null");
        }
        if (ontologyMatcherPager == null) {
            throw new IllegalArgumentException("OntologyMatcherPager is null");
        }
        if (mappingManagerPager == null) {
            throw new IllegalArgumentException("MappingManagerPager is null");
        }
        if (algorithmReportPager == null) {
            throw new IllegalArgumentException("AlgorithmGeneratorPage is null");
        }
        this.chooseCataloguePager = chooseCataloguePager;
        this.ontologyAnnotatorPager = ontologyAnnotatorPager;
        this.ontologyMatcherPager = ontologyMatcherPager;
        this.mappingManagerPager = mappingManagerPager;
        this.algorithmReportPager = algorithmReportPager;
        this.wizard = new BiobankConnectWizard();
    }

    public void onInit(HttpServletRequest request) {
        this.wizard.setDataSets(this.getBiobankDataSets());
        this.currentUserStatus.setUserLoggedIn(this.userAccountService.getCurrentUser().getUsername(), request.getRequestedSessionId());
    }

    protected Wizard createWizard() {
        this.wizard = new BiobankConnectWizard();
        this.wizard.setDataSets(this.getBiobankDataSets());
        this.wizard.setUserName(this.userAccountService.getCurrentUser().getUsername());
        this.wizard.addPage((WizardPage)this.chooseCataloguePager);
        this.wizard.addPage((WizardPage)this.ontologyAnnotatorPager);
        this.wizard.addPage((WizardPage)this.ontologyMatcherPager);
        this.wizard.addPage((WizardPage)this.mappingManagerPager);
        this.wizard.addPage((WizardPage)this.algorithmReportPager);
        return this.wizard;
    }

    private List<DataSet> getBiobankDataSets() {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        Iterable allDataSets = this.dataService.findAll("DataSet", DataSet.class);
        for (DataSet dataSet : allDataSets) {
            if (dataSet.getProtocolUsed().getIdentifier().equals("store_mapping") || dataSet.getIdentifier().matches("^" + this.userAccountService.getCurrentUser().getUsername() + ".*derived$")) continue;
            dataSets.add(dataSet);
        }
        return dataSets;
    }

    @RequestMapping(value={"/uploadfeatures"}, method={RequestMethod.POST}, headers={"Content-Type=multipart/form-data"})
    public String importFeatures(@RequestParam String dataSetName, @RequestParam Part file, @ModelAttribute(value="wizard") BiobankConnectWizard biobankConnectWizard, HttpServletRequest request, Model model) throws IOException {
        File uploadFile = FileUploadUtils.saveToTempFolder((Part)file);
        String message = this.ontologyAnnotator.uploadFeatures(uploadFile, dataSetName);
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        Iterable allDataSets = this.dataService.findAll("DataSet", DataSet.class);
        for (DataSet dataSet : allDataSets) {
            if (dataSet.getProtocolUsed().getIdentifier().equals("store_mapping")) continue;
            dataSets.add(dataSet);
        }
        biobankConnectWizard.setDataSets(dataSets);
        if (message.length() > 0) {
            model.addAttribute("message", (Object)message);
        }
        return this.init(request);
    }

    @RequestMapping(value={"/annotate"}, method={RequestMethod.POST})
    public String annotate(HttpServletRequest request) {
        this.ontologyAnnotator.removeAnnotations(this.wizard.getSelectedDataSet().getId());
        if (request.getParameter("selectedOntologies") != null) {
            ArrayList<String> documentTypes = new ArrayList<String>();
            for (String ontologyUri : request.getParameter("selectedOntologies").split(",")) {
                documentTypes.add(AsyncOntologyIndexer.createOntologyTermDocumentType(ontologyUri));
            }
            this.ontologyAnnotator.annotate(this.wizard.getSelectedDataSet().getId(), documentTypes);
        }
        return this.init(request);
    }

    @RequestMapping(value={"/annotate/remove"}, method={RequestMethod.POST})
    public String removeAnnotations(HttpServletRequest request) throws Exception {
        this.ontologyAnnotator.removeAnnotations(this.wizard.getSelectedDataSet().getId());
        return this.init(request);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/annotate/update"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDocument(@RequestBody UpdateIndexRequest request) {
        this.ontologyAnnotator.updateIndex(request);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/rematch"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public AlgorithmGenerateResponse rematch(@RequestBody OntologyMatcherRequest request) {
        String userName = this.userAccountService.getCurrentUser().getUsername();
        this.ontologyMatcher.match(userName, request.getTargetDataSetId(), request.getSelectedDataSetIds(), request.getFeatureId());
        AlgorithmGenerateResponse response = new AlgorithmGenerateResponse(null, this.ontologyMatcher.isRunning(), this.ontologyMatcher.matchPercentage(userName), null, null, null, null);
        return response;
    }

    @RequestMapping(value={"/running"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, Boolean> isRunning(HttpServletRequest request) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("isRunning", this.currentUserStatus.isUserLoggedIn(this.userAccountService.getCurrentUser().getUsername(), request.getRequestedSessionId()));
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/progress"}, produces={"application/json"})
    @ResponseBody
    public AlgorithmGenerateResponse checkMatch() {
        String userName = this.userAccountService.getCurrentUser().getUsername();
        DataSet derivedDataSet = null;
        if (!this.currentUserStatus.isUserMatching(userName).booleanValue()) {
            String deriveDataSetIdentifier = ApplyAlgorithms.createDerivedDataSetIdentifier(userName, this.wizard.getSelectedDataSet().getId().toString(), this.wizard.getSelectedBiobanks());
            derivedDataSet = (DataSet)this.dataService.findOne("DataSet", new QueryImpl().eq("Identifier", (Object)deriveDataSetIdentifier), DataSet.class);
        }
        AlgorithmGenerateResponse response = new AlgorithmGenerateResponse(this.currentUserStatus.getUserCurrentStage(userName), this.currentUserStatus.isUserMatching(userName), this.ontologyMatcher.matchPercentage(userName), this.currentUserStatus.getTotalNumberOfUsers(), this.wizard.getSelectedDataSet().getId(), this.wizard.getSelectedBiobanks(), derivedDataSet != null ? derivedDataSet.getId() : null);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/download"}, method={RequestMethod.POST})
    public void download(@RequestParam(value="request") String requestString, HttpServletResponse response) throws IOException {
        requestString = URLDecoder.decode(requestString, "UTF-8");
        UpdateIndexRequest request = (UpdateIndexRequest)new GsonHttpMessageConverter().getGson().fromJson(requestString, UpdateIndexRequest.class);
        response.setContentType("text/csv");
        response.addHeader("Content-Disposition", "attachment; filename=" + this.getCsvFileName(request.getDocumentType()));
        CsvWriter writer = null;
        try {
            Integer selectedDataSetId = request.getDataSetId();
            DataSet selectedDataSet = (DataSet)this.dataService.findOne("DataSet", (Object)selectedDataSetId, DataSet.class);
            ArrayList<String> mappingIdentifiers = new ArrayList<String>();
            for (Integer mappedDataSetId : request.getMatchedDataSetIds()) {
                mappingIdentifiers.add(AsyncOntologyMatcher.createMappingDataSetIdentifier(this.userAccountService.getCurrentUser().getUsername(), selectedDataSetId, mappedDataSetId));
            }
            Iterable dataSetsStoringMappings = this.dataService.findAll("DataSet", new QueryImpl().in("Identifier", mappingIdentifiers), DataSet.class);
            ArrayList<String> dataSetNames = new ArrayList<String>();
            dataSetNames.add(selectedDataSet.getName());
            HashMap dataSetMappings = new HashMap();
            if (Iterables.size((Iterable)dataSetsStoringMappings) > 0) {
                for (DataSet dataSet : dataSetsStoringMappings) {
                    Integer mappedDataSetId = Integer.parseInt(dataSet.getIdentifier().split("-")[2]);
                    if (mappedDataSetId.equals(selectedDataSetId)) continue;
                    DataSet mappedDataSet = (DataSet)this.dataService.findOne("DataSet", (Object)mappedDataSetId, DataSet.class);
                    dataSetNames.add(mappedDataSet.getName());
                    SearchRequest searchRequest = new SearchRequest(dataSet.getIdentifier(), new QueryImpl().pageSize(Integer.MAX_VALUE), null);
                    HashMap<String, String> storeMappings = new HashMap<String, String>();
                    for (Hit hit : this.searchService.search(searchRequest).getSearchHits()) {
                        Map columnValueMap = hit.getColumnValueMap();
                        String featureId = columnValueMap.get("store_mapping_feature").toString();
                        String mappedFeatureIdsString = columnValueMap.get("store_mapping_mapped_feature").toString();
                        StringBuilder mappedFeatureNames = new StringBuilder();
                        if (mappedFeatureIdsString.length() > 2) {
                            List<String> mappedFeatureIds = Arrays.asList(mappedFeatureIdsString.substring(1, mappedFeatureIdsString.length() - 1).split("\\s*,\\s*"));
                            Iterable mappedFeatures = this.dataService.findAll("ObservableFeature", new QueryImpl().in("id", mappedFeatureIds), ObservableFeature.class);
                            for (ObservableFeature feature : mappedFeatures) {
                                if (mappedFeatureNames.length() > 0) {
                                    mappedFeatureNames.append(";");
                                }
                                mappedFeatureNames.append(feature.getName()).append(':').append(feature.getDescription());
                            }
                        }
                        storeMappings.put(featureId, mappedFeatureNames.toString());
                    }
                    dataSetMappings.put(mappedDataSetId, storeMappings);
                }
                writer = new CsvWriter((Writer)response.getWriter(), dataSetNames);
                SearchRequest searchRequest = new SearchRequest("protocolTree-" + selectedDataSet.getProtocolUsed().getId(), new QueryImpl().eq("type", (Object)ObservableFeature.class.getSimpleName().toLowerCase()).pageSize(Integer.MAX_VALUE), null);
                for (Hit hit : this.searchService.search(searchRequest).getSearchHits()) {
                    MapEntity entity = new MapEntity();
                    Map columnValueMap = hit.getColumnValueMap();
                    String featureName = columnValueMap.get("Name".toLowerCase()).toString();
                    String featureId = columnValueMap.get("id".toLowerCase()).toString();
                    entity.set((String)dataSetNames.get(0), (Object)featureName);
                    int i = 1;
                    for (DataSet dataSet : dataSetsStoringMappings) {
                        Integer mappedDataSetId = Integer.parseInt(dataSet.getIdentifier().split("-")[2]);
                        if (mappedDataSetId.equals(selectedDataSetId)) continue;
                        StringBuilder value = new StringBuilder();
                        Map storeMappings = (Map)dataSetMappings.get(mappedDataSetId);
                        if (storeMappings != null && storeMappings.containsKey(featureId)) {
                            value.append((String)storeMappings.get(featureId));
                        }
                        entity.set((String)dataSetNames.get(i++), (Object)value.toString());
                    }
                    writer.add((Entity)entity);
                }
            }
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    private String getCsvFileName(String dataSetName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dataSetName + "_" + dateFormat.format(new Date()) + ".csv";
    }
}

