/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.algorithm;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.DataService;
import org.molgenis.data.Query;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.framework.ui.MolgenisPluginController;
import org.molgenis.omx.biobankconnect.algorithm.AlgorithmGenerator;
import org.molgenis.omx.biobankconnect.algorithm.ApplyAlgorithms;
import org.molgenis.omx.biobankconnect.ontologymatcher.OntologyMatcher;
import org.molgenis.omx.biobankconnect.ontologymatcher.OntologyMatcherRequest;
import org.molgenis.omx.biobankconnect.ontologyservice.OntologyService;
import org.molgenis.omx.biobankconnect.ontologyservice.OntologyServiceRequest;
import org.molgenis.omx.biobankconnect.wizard.CurrentUserStatus;
import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.search.SearchRequest;
import org.molgenis.search.SearchResult;
import org.molgenis.search.SearchService;
import org.molgenis.security.user.UserAccountService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/plugin/algorithm"})
public class AlgorithmEditorController
extends MolgenisPluginController {
    public static final String ID = "algorithm";
    public static final String URI = "/plugin/algorithm";
    @Autowired
    private OntologyService ontologyService;
    @Autowired
    private OntologyMatcher ontologyMatcher;
    @Autowired
    private UserAccountService userAccountService;
    @Autowired
    private CurrentUserStatus currentUserStatus;
    @Autowired
    private AlgorithmGenerator algorithmGenerator;
    @Autowired
    private ApplyAlgorithms applyAlgorithms;
    @Autowired
    private SearchService searchService;
    @Autowired
    private DataService dataService;

    public AlgorithmEditorController() {
        super(URI);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/createmapping"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public SearchResult createMappings(@RequestBody OntologyMatcherRequest request) {
        String userName = this.userAccountService.getCurrentUser().getUsername();
        List<Integer> selectedDataSetIds = request.getSelectedDataSetIds();
        if (selectedDataSetIds.size() > 0) {
            return this.ontologyMatcher.generateMapping(userName, request.getFeatureId(), request.getTargetDataSetId(), selectedDataSetIds.get(0));
        }
        return new SearchResult(0L, Collections.emptyList());
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/suggestscript"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> suggestScript(@RequestBody OntologyMatcherRequest request) {
        HashMap<String, Object> jsonResults = new HashMap<String, Object>();
        String userName = this.userAccountService.getCurrentUser().getUsername();
        String suggestedScript = this.algorithmGenerator.generateAlgorithm(userName, request);
        jsonResults.put("suggestedScript", suggestedScript);
        return jsonResults;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/testscript"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> testScrpit(@RequestBody OntologyMatcherRequest request) {
        HashMap<String, Object> jsonResults = new HashMap<String, Object>();
        String algorithm = request.getAlgorithmScript();
        List<Integer> selectedDataSetIds = request.getSelectedDataSetIds();
        if (selectedDataSetIds.size() != 0 && !StringUtils.isEmpty((CharSequence)algorithm)) {
            Integer sourceDataSetId = selectedDataSetIds.get(0);
            ObservableFeature feature = (ObservableFeature)this.dataService.findOne("ObservableFeature", (Object)request.getFeatureId(), ObservableFeature.class);
            String message = this.applyAlgorithms.validateAlgorithmInputs(sourceDataSetId, algorithm);
            List results = StringUtils.isEmpty((CharSequence)message) ? this.applyAlgorithms.createValueFromAlgorithm(feature.getDataType(), sourceDataSetId, algorithm).values() : Collections.emptyList();
            jsonResults.put("results", results);
            jsonResults.put("message", message);
            jsonResults.put("totalCounts", this.countRowsByDataSet(sourceDataSetId));
        }
        return jsonResults;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/savescript"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public Map<String, String> saveScript(@RequestBody OntologyMatcherRequest request) {
        Integer targetDataSetId = request.getTargetDataSetId();
        List<Integer> selectedDataSetIds = request.getSelectedDataSetIds();
        if (targetDataSetId == null || selectedDataSetIds == null || request.getFeatureId() == null) {
            return Collections.emptyMap();
        }
        if (request.getAlgorithmScript() == null && request.getMappedFeatureIds() == null) {
            return Collections.emptyMap();
        }
        if (selectedDataSetIds.size() > 0) {
            return this.ontologyMatcher.updateScript(this.userAccountService.getCurrentUser().getUsername(), request);
        }
        return Collections.emptyMap();
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/allattributes"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public SearchResult getAllAttributes(@RequestBody Map<String, Object> request) {
        if (request.get("dataSetId") == null) {
            return new SearchResult("dataSetId cannot be null!");
        }
        Object dataSetId = request.get("dataSetId");
        Object queryString = request.get("queryString");
        Object approximate = request.get("approximate") == null ? Boolean.valueOf(false) : request.get("approximate");
        DataSet dataSet = (DataSet)this.dataService.findOne("DataSet", dataSetId, DataSet.class);
        QueryImpl query = new QueryImpl();
        if (request.get("query") != null) {
            query = (Query)new Gson().fromJson(request.get("query").toString(), QueryImpl.class);
        }
        query.eq("type", (Object)"observablefeature");
        if (queryString != null && !queryString.toString().isEmpty()) {
            if (((Boolean)approximate).booleanValue()) {
                query.and().like("Name".toLowerCase(), (Object)queryString.toString());
            } else {
                query.and().search(queryString.toString());
            }
        }
        return this.searchService.search(new SearchRequest("protocolTree-" + dataSet.getProtocolUsed().getId(), (Query)query, null));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/attribute"}, produces={"application/json"})
    @ResponseBody
    public SearchResult getOneAttribute(@RequestBody String featureId) {
        return this.searchService.search(new SearchRequest(null, new QueryImpl().eq("id", (Object)featureId).and().eq("type", (Object)"observablefeature"), null));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/ontologyterm"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public SearchResult query(@RequestBody OntologyServiceRequest ontologyTermRequest) {
        String ontologyIri = ontologyTermRequest.getOntologyIri();
        String queryString = ontologyTermRequest.getQueryString();
        if (queryString == null) {
            return new SearchResult(0L, Collections.emptyList());
        }
        return this.ontologyService.search(ontologyIri, queryString);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/getmapping"}, produces={"application/json"})
    @ResponseBody
    public SearchResult getMappings(@RequestBody Map<String, Object> request) {
        if (request.get("dataSetIdentifier") == null) {
            return new SearchResult("dataSetId cannot be null!");
        }
        Object dataSetIdentifier = request.get("dataSetIdentifier");
        Object featureIds = request.get("featureIds");
        QueryImpl query = new QueryImpl();
        if (featureIds != null && !featureIds.toString().isEmpty()) {
            if (query.getRules().size() > 0) {
                query.or();
            }
            for (Object featureId : (List)featureIds) {
                query.eq("store_mapping_feature", (Object)featureId.toString());
            }
        }
        return this.searchService.search(new SearchRequest(dataSetIdentifier.toString(), (Query)query, null));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/getstores"}, produces={"application/json"})
    @ResponseBody
    public Map<String, List<DataSet>> getDataSetsForMappings(@RequestBody String dataSetId) {
        HashMap<String, List<DataSet>> results = new HashMap<String, List<DataSet>>();
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        if (dataSetId != null) {
            StringBuilder prefixForStoreIdentifiers = new StringBuilder();
            prefixForStoreIdentifiers.append(this.userAccountService.getCurrentUser().getUsername()).append('-').append(dataSetId);
            Iterable allDataSets = this.dataService.findAll("DataSet", new QueryImpl().like("Identifier", (Object)prefixForStoreIdentifiers.toString()), DataSet.class);
            for (DataSet dataSet : allDataSets) {
                if (!dataSet.getProtocolUsed().getIdentifier().equals("store_mapping")) continue;
                dataSets.add(dataSet);
            }
        }
        results.put("results", dataSets);
        return results;
    }

    private long countRowsByDataSet(Integer sourceDataSetId) {
        DataSet sourceDataSet = (DataSet)this.dataService.findOne("DataSet", (Object)sourceDataSetId, DataSet.class);
        return this.dataService.count("ObservationSet", new QueryImpl().eq("partOfDataSet", (Object)sourceDataSet));
    }
}

