/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.DataService;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.omx.biobankconnect.algorithm.AlgorithmScriptLibrary;
import org.molgenis.omx.biobankconnect.algorithm.AlgorithmUnitConverter;
import org.molgenis.omx.biobankconnect.algorithm.ApplyAlgorithms;
import org.molgenis.omx.biobankconnect.ontologymatcher.OntologyMatcher;
import org.molgenis.omx.biobankconnect.ontologymatcher.OntologyMatcherRequest;
import org.molgenis.omx.biobankconnect.utils.NGramMatchingModel;
import org.molgenis.omx.observ.Category;
import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.omx.observ.target.OntologyTerm;
import org.molgenis.search.Hit;
import org.molgenis.search.SearchRequest;
import org.molgenis.search.SearchResult;
import org.molgenis.search.SearchService;
import org.molgenis.security.runas.RunAsSystem;
import org.springframework.beans.factory.annotation.Autowired;

public class AlgorithmGenerator {
    @Autowired
    private OntologyMatcher ontologyMatcher;
    @Autowired
    private AlgorithmScriptLibrary algorithmScriptLibrary;
    @Autowired
    private AlgorithmUnitConverter algorithmUnitConverter;
    @Autowired
    private DataService dataService;
    @Autowired
    private SearchService searchService;
    private static final String NODE_PATH = "nodePath";
    private static final String ONTOLOGY_TERM_IRI = "ontologyTermIRI";

    @RunAsSystem
    public String generateAlgorithm(String userName, OntologyMatcherRequest request) {
        StringBuilder suggestedScript = new StringBuilder();
        List<Integer> selectedDataSetIds = request.getSelectedDataSetIds();
        if (selectedDataSetIds.size() > 0) {
            SearchResult searchResult = this.ontologyMatcher.generateMapping(userName, request.getFeatureId(), request.getTargetDataSetId(), selectedDataSetIds.get(0));
            ObservableFeature standardFeature = (ObservableFeature)this.dataService.findOne("ObservableFeature", (Object)request.getFeatureId(), ObservableFeature.class);
            String scriptTemplate = this.algorithmScriptLibrary.findScriptTemplate(standardFeature);
            if (searchResult.getTotalHitCount() > 0L) {
                if (StringUtils.isEmpty((CharSequence)scriptTemplate)) {
                    suggestedScript.append(this.convertToJavascript(standardFeature, searchResult));
                } else {
                    suggestedScript.append(this.convertToJavascriptByFormula(scriptTemplate, standardFeature, searchResult));
                }
            }
        }
        return suggestedScript.toString();
    }

    private String convertToJavascript(ObservableFeature standardFeature, SearchResult searchResult) {
        Hit hit = (Hit)searchResult.getSearchHits().get(0);
        ObservableFeature customFeature = (ObservableFeature)this.dataService.findOne("ObservableFeature", (Object)Integer.parseInt(hit.getColumnValueMap().get("id".toLowerCase()).toString()), ObservableFeature.class);
        String conversionScript = this.algorithmUnitConverter.convert(standardFeature.getUnit(), customFeature.getUnit());
        StringBuilder javaScript = new StringBuilder();
        javaScript.append(this.createJavascriptName(customFeature.getName(), conversionScript, false));
        if (standardFeature.getDataType().equalsIgnoreCase(MolgenisFieldTypes.FieldTypeEnum.CATEGORICAL.toString()) && customFeature.getDataType().equalsIgnoreCase(MolgenisFieldTypes.FieldTypeEnum.CATEGORICAL.toString())) {
            Iterable categoriesForStandardFeature = this.dataService.findAll("Category", new QueryImpl().eq("observableFeature", (Object)standardFeature), Category.class);
            Iterable categoriesForCustomFeature = this.dataService.findAll("Category", new QueryImpl().eq("observableFeature", (Object)customFeature), Category.class);
            HashMap<String, String> valueCodeMapping = new HashMap<String, String>();
            for (Category category : categoriesForCustomFeature) {
                double similarityScore = 0.0;
                String mappedValueCode = null;
                for (Category standardCategory : categoriesForStandardFeature) {
                    double score = NGramMatchingModel.stringMatching(category.getName(), standardCategory.getName(), false);
                    if (!(score > similarityScore)) continue;
                    similarityScore = score;
                    mappedValueCode = standardCategory.getValueCode();
                }
                if (mappedValueCode == null) continue;
                valueCodeMapping.put(category.getValueCode(), mappedValueCode);
            }
            if (valueCodeMapping.size() > 0) {
                javaScript.append(".map({");
                for (Map.Entry entry : valueCodeMapping.entrySet()) {
                    javaScript.append("'").append((String)entry.getKey()).append("'").append(" : ").append("'").append((String)entry.getValue()).append("',");
                }
                javaScript.delete(javaScript.length() - 1, javaScript.length());
                javaScript.append("})");
            }
        }
        return javaScript.toString();
    }

    private String convertToJavascriptByFormula(String scriptTemplate, ObservableFeature standardFeature, SearchResult searchResult) {
        for (String standardFeatureName : ApplyAlgorithms.extractFeatureName(scriptTemplate)) {
            SearchResult result = this.algorithmScriptLibrary.findOntologyTerm(Arrays.asList(standardFeatureName));
            if (result.getTotalHitCount() <= 0L) continue;
            Hit bestMatchedFeature = null;
            int miniDistance = 1000000;
            for (Hit candidateFeature : searchResult.getSearchHits()) {
                int distance = this.compareOntologyTermDistance((Hit)result.getSearchHits().get(0), this.findOntologyTerms(candidateFeature));
                if (distance < 0 || distance >= miniDistance) continue;
                miniDistance = distance;
                bestMatchedFeature = candidateFeature;
            }
            if (bestMatchedFeature == null) continue;
            ObservableFeature mappedFeature = (ObservableFeature)this.dataService.findOne("ObservableFeature", (Object)Integer.parseInt(bestMatchedFeature.getColumnValueMap().get("id".toLowerCase()).toString()), ObservableFeature.class);
            String conversionScript = this.algorithmUnitConverter.convert(standardFeature.getUnit(), mappedFeature.getUnit());
            String mappedFeatureJavaScriptName = this.createJavascriptName(bestMatchedFeature.getColumnValueMap().get("Name".toLowerCase()).toString(), conversionScript, true);
            String standardJavaScriptName = this.createJavascriptName(standardFeatureName, null, true);
            scriptTemplate = scriptTemplate.replaceAll(standardJavaScriptName, mappedFeatureJavaScriptName);
        }
        return scriptTemplate;
    }

    private String createJavascriptName(String mappedFeatureName, String suffix, boolean escaped) {
        StringBuilder javaScriptName = new StringBuilder();
        javaScriptName.append(escaped ? "\\$\\('" : "$('").append(mappedFeatureName).append(escaped ? "'\\)" : "')");
        if (!StringUtils.isEmpty((CharSequence)suffix)) {
            javaScriptName.append(suffix);
        }
        return javaScriptName.toString();
    }

    private List<Hit> findOntologyTerms(Hit candidateFeature) {
        Integer featureId = Integer.parseInt(candidateFeature.getColumnValueMap().get("id".toLowerCase()).toString());
        ObservableFeature feature = (ObservableFeature)this.dataService.findOne("ObservableFeature", (Object)featureId, ObservableFeature.class);
        QueryImpl query = new QueryImpl();
        for (OntologyTerm ot : feature.getDefinitions()) {
            if (query.getRules().size() > 0) {
                query.addRule(new QueryRule(QueryRule.Operator.OR));
            }
            query.addRule(new QueryRule(ONTOLOGY_TERM_IRI, QueryRule.Operator.EQUALS, ot.getTermAccession()));
        }
        return this.searchService.search(new SearchRequest(null, (Query)query, null)).getSearchHits();
    }

    private int compareOntologyTermDistance(Hit targetOntologyTerm, List<Hit> sourceOntologyTerms) {
        int miniDistance = 1000000;
        List<String> totTermPathParts = Arrays.asList(targetOntologyTerm.getColumnValueMap().get(NODE_PATH).toString().split("\\."));
        HashSet<String> uniquePaths = new HashSet<String>();
        for (Hit sourceOntologyTerm : sourceOntologyTerms) {
            if (!sourceOntologyTerm.getColumnValueMap().containsKey(NODE_PATH)) continue;
            uniquePaths.add(sourceOntologyTerm.getColumnValueMap().get(NODE_PATH).toString());
        }
        for (String uniquePath : uniquePaths) {
            ArrayList<String> sosPathParts = new ArrayList<String>(Arrays.asList(uniquePath.split("\\.")));
            int beforeRemove = sosPathParts.size();
            sosPathParts.removeAll(totTermPathParts);
            int afterRemove = sosPathParts.size();
            int distance = beforeRemove + totTermPathParts.size() - 2 * (beforeRemove - afterRemove);
            if (distance == 0) {
                return distance;
            }
            if (distance <= 0 || distance >= miniDistance) continue;
            miniDistance = distance;
        }
        return miniDistance;
    }
}

