/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.ontology.repository;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Repository;
import org.molgenis.data.support.DefaultAttributeMetaData;
import org.molgenis.data.support.DefaultEntityMetaData;
import org.molgenis.search.SearchService;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractOntologyRepository
implements Repository {
    protected DefaultEntityMetaData entityMetaData = null;
    protected final SearchService searchService;
    protected final String entityName;
    public static final String ID = "id";
    public static final String NODE_PATH = "nodePath";
    public static final String PARENT_NODE_PATH = "parentNodePath";
    public static final String PARENT_ONTOLOGY_TERM_IRI = "parentOntologyTermIRI";
    public static final String FIELDTYPE = "fieldType";
    public static final String ROOT = "root";
    public static final String LAST = "isLast";
    public static final String ONTOLOGY_IRI = "ontologyIRI";
    public static final String ONTOLOGY_NAME = "ontologyName";
    public static final String ONTOLOGY_TERM = "ontologyTerm";
    public static final String ONTOLOGY_TERM_DEFINITION = "definition";
    public static final String ONTOLOGY_TERM_IRI = "ontologyTermIRI";
    public static final String SYNONYMS = "ontologyTermSynonym";
    public static final String ALTERNATIVE_DEFINITION = "alternativeDefinition";
    public static final String ENTITY_TYPE = "entity_type";
    public static final String TYPE_ONTOLOGYTERM = "ontologyTerm";
    public static final String CHIDLREN = "children";
    public static final String ILLEGAL_CHARACTERS_PATTERN = "[^(a-zA-Z0-9 )]";
    public static final String ILLEGAL_CHARACTERS_REPLACEMENT = "\\s";
    public static final String NODE_PATH_REPLACEMENT_PATTERN = "\\.[0-9]+$";
    public static final String MULTI_WHITESPACES = " +";
    public static final String SINGLE_WHITESPACE = " ";

    @Autowired
    public AbstractOntologyRepository(String entityName, SearchService searchService) {
        if (searchService == null) {
            throw new IllegalArgumentException("SearchService is null!");
        }
        if (StringUtils.isEmpty((CharSequence)entityName)) {
            throw new IllegalArgumentException("The ontology entityName is null!");
        }
        this.entityName = entityName;
        this.searchService = searchService;
    }

    public EntityMetaData getEntityMetaData() {
        if (this.entityMetaData == null) {
            this.entityMetaData = new DefaultEntityMetaData(this.entityName);
            DefaultAttributeMetaData attributeId = new DefaultAttributeMetaData(ID);
            attributeId.setIdAttribute(true);
            this.entityMetaData.addAttributeMetaData((AttributeMetaData)attributeId);
            this.entityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(ONTOLOGY_TERM_IRI, MolgenisFieldTypes.FieldTypeEnum.HYPERLINK));
            DefaultAttributeMetaData attributeMetaData = new DefaultAttributeMetaData("ontologyTerm");
            attributeMetaData.setLabelAttribute(true);
            this.entityMetaData.addAttributeMetaData((AttributeMetaData)attributeMetaData);
            this.entityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(SYNONYMS));
            this.entityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(ENTITY_TYPE));
            this.entityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(NODE_PATH));
            this.entityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(PARENT_NODE_PATH));
            this.entityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(PARENT_ONTOLOGY_TERM_IRI));
            this.entityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(FIELDTYPE));
            this.entityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(LAST, MolgenisFieldTypes.FieldTypeEnum.BOOL));
            this.entityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(ROOT, MolgenisFieldTypes.FieldTypeEnum.BOOL));
            this.entityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(ONTOLOGY_TERM_DEFINITION));
            this.entityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(ONTOLOGY_NAME));
            this.entityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(ONTOLOGY_IRI, MolgenisFieldTypes.FieldTypeEnum.HYPERLINK));
            DefaultAttributeMetaData childrenAttributeMetatData = new DefaultAttributeMetaData("attributes", MolgenisFieldTypes.FieldTypeEnum.MREF);
            childrenAttributeMetatData.setRefEntity((EntityMetaData)this.entityMetaData);
            this.entityMetaData.addAttributeMetaData((AttributeMetaData)childrenAttributeMetatData);
            this.entityMetaData.setIdAttribute(ID);
            this.entityMetaData.setIdAttribute("ontologyTerm");
        }
        return this.entityMetaData;
    }

    public String getName() {
        return this.getEntityMetaData().getName();
    }

    public void close() throws IOException {
    }

    public abstract <E extends Entity> Iterable<E> iterator(Class<E> var1);

    public abstract String getUrl();
}

