/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.ontology.repository;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.molgenis.data.Countable;
import org.molgenis.data.Entity;
import org.molgenis.data.support.MapEntity;
import org.molgenis.omx.biobankconnect.ontology.repository.AbstractOntologyRepository;
import org.molgenis.omx.biobankconnect.utils.OntologyLoader;
import org.molgenis.search.SearchService;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.springframework.beans.factory.annotation.Autowired;

public class OntologyTermIndexRepository
extends AbstractOntologyRepository
implements Countable {
    private final OntologyLoader ontologyLoader;
    private final Set<String> dynamaticFields;

    @Autowired
    public OntologyTermIndexRepository(OntologyLoader loader, String entityName, SearchService searchService) {
        super(entityName, searchService);
        if (loader == null) {
            throw new IllegalArgumentException("OntologyLoader is null!");
        }
        this.ontologyLoader = loader;
        this.dynamaticFields = new HashSet<String>();
    }

    public long count() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        this.createOntologyTable(entities, this.ontologyLoader);
        return entities.size();
    }

    public Iterator<Entity> iterator() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        this.createOntologyTable(entities, this.ontologyLoader);
        return entities.iterator();
    }

    private void createOntologyTable(List<Entity> entities, OntologyLoader model) {
        int count = 0;
        for (OWLClass subClass : model.getRootClasses()) {
            this.recursiveAddEntity("0[0]." + count, null, subClass, entities, true);
            ++count;
        }
    }

    private void recursiveAddEntity(String parentNodePath, String parentTermIri, OWLClass cls, List<Entity> entities, boolean root) {
        String ontologyTermLabel = this.ontologyLoader.getLabel((OWLEntity)cls).replaceAll("[^(a-zA-Z0-9 )]", "\\s");
        String definition = this.ontologyLoader.getDefinition(cls);
        Set<OWLClass> listOfChildren = this.ontologyLoader.getChildClass(cls);
        HashSet<String> synonyms = new HashSet<String>();
        synonyms.add(ontologyTermLabel);
        synonyms.addAll(this.ontologyLoader.getSynonyms(cls));
        StringBuilder alternativeDefinitions = new StringBuilder();
        for (Set<OWLClass> alternativeDefinition : this.ontologyLoader.getAssociatedClasses(cls)) {
            StringBuilder newDefinition = new StringBuilder();
            for (OWLClass associatedClass : alternativeDefinition) {
                if (newDefinition.length() != 0) {
                    newDefinition.append(',');
                }
                newDefinition.append(associatedClass.getIRI().toString());
            }
            if (alternativeDefinitions.length() != 0 && newDefinition.length() != 0) {
                alternativeDefinitions.append("&&&");
            }
            alternativeDefinitions.append((CharSequence)newDefinition);
        }
        Map<String, Set<String>> allDatabaseIds = this.ontologyLoader.getAllDatabaseIds(cls);
        for (String synonym : synonyms) {
            MapEntity entity = new MapEntity();
            entity.set("id", (Object)this.ontologyLoader.getId(cls));
            entity.set("nodePath", (Object)this.constructNodePath(parentNodePath));
            entity.set("parentNodePath", (Object)parentNodePath.replaceAll("\\.[0-9]+$", ""));
            entity.set("parentOntologyTermIRI", (Object)parentTermIri);
            entity.set("root", (Object)root);
            entity.set("isLast", (Object)(listOfChildren.size() == 0 ? 1 : 0));
            entity.set("ontologyIRI", (Object)this.ontologyLoader.getOntologyIRI());
            entity.set("ontologyName", (Object)this.ontologyLoader.getOntologyName());
            entity.set("ontologyTerm", (Object)ontologyTermLabel);
            entity.set("definition", (Object)definition);
            entity.set("ontologyTermIRI", (Object)cls.getIRI().toString());
            entity.set("entity_type", (Object)"ontologyTerm");
            entity.set("ontologyTermSynonym", (Object)synonym.replaceAll("[^(a-zA-Z0-9 )]", "\\s"));
            entity.set("alternativeDefinition", (Object)alternativeDefinitions.toString());
            for (Map.Entry<String, Set<String>> entry : allDatabaseIds.entrySet()) {
                entity.set(entry.getKey(), entry.getValue());
                if (this.dynamaticFields.contains(entry.getKey())) continue;
                this.dynamaticFields.add(entry.getKey());
            }
            entities.add((Entity)entity);
        }
        if (listOfChildren.size() > 0) {
            int i = 0;
            for (OWLClass childClass : listOfChildren) {
                String childTermPath = this.constructNodePath(parentNodePath) + "." + i;
                this.recursiveAddEntity(childTermPath, cls.getIRI().toString(), childClass, entities, false);
                ++i;
            }
        }
    }

    private String constructNodePath(String parentNodePath) {
        StringBuilder nodePathStringBuilder = new StringBuilder();
        nodePathStringBuilder.append(parentNodePath).append('[').append(parentNodePath.split("\\.").length - 1).append(']');
        return nodePathStringBuilder.toString();
    }

    public Set<String> getDynamaticFields() {
        return this.dynamaticFields;
    }

    @Override
    public <E extends Entity> Iterable<E> iterator(Class<E> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getUrl() {
        throw new UnsupportedOperationException();
    }
}

