/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.ontology.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Query;
import org.molgenis.data.Queryable;
import org.molgenis.data.support.DefaultAttributeMetaData;
import org.molgenis.data.support.DefaultEntityMetaData;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.omx.biobankconnect.ontology.repository.AbstractOntologyQueryRepository;
import org.molgenis.omx.biobankconnect.ontologyindexer.AsyncOntologyIndexer;
import org.molgenis.omx.biobankconnect.ontologytree.OntologyTermEntity;
import org.molgenis.search.Hit;
import org.molgenis.search.SearchRequest;
import org.molgenis.search.SearchResult;
import org.molgenis.search.SearchService;
import org.springframework.beans.factory.annotation.Autowired;

public class OntologyTermQueryRepository
extends AbstractOntologyQueryRepository {
    public static final String DEFAULT_ONTOLOGY_TERM_REPO = "ontologytermindex";
    private static final String BASE_URL = "ontologytermindex://";
    private static final List<String> reservedAttributeName = Arrays.asList("score");
    private final String ontologyIri;

    @Autowired
    public OntologyTermQueryRepository(String entityName, String ontologyIri, SearchService searchService) {
        super(entityName, searchService);
        this.ontologyIri = ontologyIri;
        this.dynamicEntityMetaData();
    }

    private void dynamicEntityMetaData() {
        EntityMetaData entityMetaData = this.getEntityMetaData();
        if (entityMetaData instanceof DefaultEntityMetaData) {
            DefaultEntityMetaData defaultEntityMetaData = (DefaultEntityMetaData)entityMetaData;
            HashSet<String> availableAttributes = new HashSet<String>();
            for (AttributeMetaData attributeMetaData : entityMetaData.getAttributes()) {
                availableAttributes.add(attributeMetaData.getName().toLowerCase());
            }
            SearchResult resultResult = this.searchService.search(new SearchRequest(AsyncOntologyIndexer.createOntologyTermDocumentType(this.ontologyIri), new QueryImpl().eq("entity_type", (Object)"ontologyTerm").pageSize(1), null));
            if (resultResult.getTotalHitCount() > 0L) {
                Hit hit = (Hit)resultResult.getSearchHits().get(0);
                for (String attributeName : hit.getColumnValueMap().keySet()) {
                    if (availableAttributes.contains(attributeName.toLowerCase()) || reservedAttributeName.contains(attributeName)) continue;
                    defaultEntityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(attributeName));
                }
            }
        }
    }

    public Iterable<Entity> findAll(Query q) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        if (q.getRules().size() > 0) {
            q.and();
        }
        q.eq("entity_type", (Object)"ontologyTerm");
        for (Hit hit : this.searchService.search(new SearchRequest(AsyncOntologyIndexer.createOntologyTermDocumentType(this.ontologyIri), q, null)).getSearchHits()) {
            entities.add((Entity)new OntologyTermEntity(hit, this.getEntityMetaData(), this.searchService));
        }
        return entities;
    }

    public Entity findOne(Query q) {
        if (q.getRules().size() > 0) {
            q.and();
        }
        q.eq("entity_type", (Object)"ontologyTerm");
        Hit hit = this.findOneInternal(AsyncOntologyIndexer.createOntologyTermDocumentType(this.ontologyIri), q);
        return hit != null ? new OntologyTermEntity(hit, this.getEntityMetaData(), this.searchService) : null;
    }

    public Entity findOne(Object id) {
        Hit hit = this.searchService.searchById(AsyncOntologyIndexer.createOntologyTermDocumentType(this.ontologyIri), id.toString());
        return hit != null ? new OntologyTermEntity(hit, this.getEntityMetaData(), this.searchService) : null;
    }

    public Query query() {
        return new QueryImpl((Queryable)this);
    }

    public long count(Query q) {
        return this.searchService.count(AsyncOntologyIndexer.createOntologyTermDocumentType(this.ontologyIri), q.pageSize(Integer.MAX_VALUE).offset(Integer.MIN_VALUE));
    }

    @Override
    public String getUrl() {
        return BASE_URL + this.getName();
    }
}

