/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.ontologyindexer;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.elasticsearch.index.MappingsBuilder;
import org.molgenis.elasticsearch.util.MapperTypeSanitizer;
import org.molgenis.framework.server.MolgenisSettings;
import org.molgenis.omx.biobankconnect.ontology.repository.OntologyIndexRepository;
import org.molgenis.omx.biobankconnect.ontology.repository.OntologyTermIndexRepository;
import org.molgenis.omx.biobankconnect.ontology.repository.OntologyTermQueryRepository;
import org.molgenis.omx.biobankconnect.ontologyindexer.OntologyIndexer;
import org.molgenis.omx.biobankconnect.utils.OntologyLoader;
import org.molgenis.omx.observ.target.Ontology;
import org.molgenis.omx.observ.target.OntologyTerm;
import org.molgenis.search.Hit;
import org.molgenis.search.SearchRequest;
import org.molgenis.search.SearchResult;
import org.molgenis.search.SearchService;
import org.molgenis.security.runas.RunAsSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;

public class AsyncOntologyIndexer
implements OntologyIndexer {
    @Autowired
    private MolgenisSettings molgenisSettings;
    private final DataService dataService;
    private final SearchService searchService;
    private String indexingOntologyIri = null;
    private boolean isCorrectOntology = true;
    private static int BATCH_SIZE = 10000;
    private static final String SYNONYM_FIELDS = "plugin.ontology.synonym.field";
    private static final Logger logger = Logger.getLogger(AsyncOntologyIndexer.class);
    private final AtomicInteger runningIndexProcesses = new AtomicInteger();

    @Autowired
    public AsyncOntologyIndexer(SearchService searchService, DataService dataService) {
        if (searchService == null) {
            throw new IllegalArgumentException("SearchService is null!");
        }
        if (dataService == null) {
            throw new IllegalArgumentException("DataService is null!");
        }
        this.searchService = searchService;
        this.dataService = dataService;
    }

    @Override
    public boolean isIndexingRunning() {
        return this.runningIndexProcesses.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async
    @RunAsSystem
    public void index(OntologyLoader ontologyLoader) {
        this.isCorrectOntology = true;
        this.runningIndexProcesses.incrementAndGet();
        try {
            String property = this.molgenisSettings.getProperty(SYNONYM_FIELDS);
            if (!StringUtils.isBlank((CharSequence)property)) {
                ontologyLoader.addSynonymsProperties(new HashSet<String>(Arrays.asList(property.split(","))));
            }
            this.indexingOntologyIri = ontologyLoader.getOntologyIRI() == null ? "" : ontologyLoader.getOntologyIRI();
            this.searchService.indexRepository((Repository)new OntologyIndexRepository(ontologyLoader, AsyncOntologyIndexer.createOntologyDocumentType(this.indexingOntologyIri), this.searchService));
            this.internalIndex(ontologyLoader);
        }
        catch (Exception e) {
            this.isCorrectOntology = false;
            logger.error((Object)"Exception imported file is not a valid ontology", (Throwable)e);
        }
        finally {
            String ontologyName = ontologyLoader.getOntologyName();
            if (!this.dataService.hasRepository(ontologyName)) {
                this.dataService.addRepository((Repository)new OntologyTermQueryRepository(ontologyName, this.indexingOntologyIri, this.searchService));
            }
            this.runningIndexProcesses.decrementAndGet();
            this.indexingOntologyIri = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalIndex(OntologyLoader ontologyLoader) throws IOException {
        ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder().loadFromClasspath("elasticsearch.yml");
        Settings settings = builder.build();
        Node node = NodeBuilder.nodeBuilder().settings(settings).local(true).node();
        Client client = node.client();
        try (OntologyTermIndexRepository ontologyTermIndexRepository = new OntologyTermIndexRepository(ontologyLoader, AsyncOntologyIndexer.createOntologyTermDocumentType(this.indexingOntologyIri), this.searchService);){
            String documentType = MapperTypeSanitizer.sanitizeMapperType((String)ontologyTermIndexRepository.getName());
            this.createMappings(client, ontologyTermIndexRepository);
            Iterator<Entity> iterator = ontologyTermIndexRepository.iterator();
            Set<String> dynamaticFields = ontologyTermIndexRepository.getDynamaticFields();
            long count = 0L;
            long start = 0L;
            long t0 = System.currentTimeMillis();
            BulkRequestBuilder bulkRequest = null;
            while (iterator.hasNext()) {
                if (count % (long)BATCH_SIZE == 0L) {
                    start = count;
                    bulkRequest = client.prepareBulk();
                }
                Entity entity = iterator.next();
                HashMap<String, Object> docs = new HashMap<String, Object>();
                Iterable attributeNames = entity.getAttributeNames();
                for (String attributeName : attributeNames) {
                    docs.put(attributeName, entity.get(attributeName));
                }
                for (String dynamaticField : dynamaticFields) {
                    if (docs.containsKey(dynamaticField)) continue;
                    docs.put(dynamaticField, "");
                }
                bulkRequest.add(client.prepareIndex("molgenis", documentType).setSource(docs));
                if (++count != start + (long)BATCH_SIZE) continue;
                BulkResponse bulkResponse = (BulkResponse)bulkRequest.execute().actionGet();
                if (bulkResponse.hasFailures()) {
                    throw new RuntimeException("error while indexing row [" + count + "]: " + bulkResponse);
                }
                long t = (System.currentTimeMillis() - t0) / 1000L;
                logger.info((Object)("Imported [" + count + "] rows in [" + t + "] sec."));
            }
            BulkResponse bulkResponse = (BulkResponse)bulkRequest.execute().actionGet();
            if (bulkResponse.hasFailures()) {
                throw new RuntimeException("error while indexing row [" + count + "]: " + bulkResponse);
            }
            long t = (System.currentTimeMillis() - t0) / 1000L;
            logger.info((Object)("Import of ontology term from ontology [" + documentType + "] completed in " + t + " sec. Added [" + count + "] rows."));
        }
    }

    private void createMappings(Client client, OntologyTermIndexRepository ontologyTermIndexRepository) throws IOException {
        String documentType = MapperTypeSanitizer.sanitizeMapperType((String)ontologyTermIndexRepository.getName());
        XContentBuilder jsonBuilder = MappingsBuilder.buildMapping((Repository)ontologyTermIndexRepository);
        logger.info((Object)("Going to create mapping [" + jsonBuilder.string() + "]"));
        PutMappingResponse response = (PutMappingResponse)client.admin().indices().preparePutMapping(new String[]{"molgenis"}).setType(documentType).setSource(jsonBuilder).execute().actionGet();
        if (!response.isAcknowledged()) {
            throw new ElasticsearchException("Creation of mapping for documentType [PalgaSample] failed. Response=" + response);
        }
        logger.info((Object)("Mapping for documentType [" + documentType + "] created"));
    }

    @Override
    @RunAsSystem
    public void removeOntology(String ontologyIri) {
        Hit hit;
        String ontologyEntityName;
        SearchRequest request;
        SearchResult result;
        Iterable ontologies = this.dataService.findAll("Ontology", new QueryImpl().eq("Identifier", (Object)ontologyIri), Ontology.class);
        if (Iterables.size((Iterable)ontologies) > 0) {
            for (Ontology ontology : ontologies) {
                Iterable ontologyTerms = this.dataService.findAll("OntologyTerm", new QueryImpl().eq("ontology", (Object)ontology), OntologyTerm.class);
                if (Iterables.size((Iterable)ontologyTerms) <= 0) continue;
                this.dataService.delete("OntologyTerm", ontologyTerms);
            }
            this.dataService.delete("Ontology", ontologies);
        }
        if ((result = this.searchService.search(request = new SearchRequest(AsyncOntologyIndexer.createOntologyDocumentType(ontologyIri), new QueryImpl().eq("ontologyIRI", (Object)ontologyIri), null))).getTotalHitCount() > 0L && this.dataService.hasRepository(ontologyEntityName = (hit = (Hit)result.getSearchHits().get(0)).getColumnValueMap().get("ontologyName").toString())) {
            this.dataService.removeRepository(ontologyEntityName);
        }
        this.searchService.deleteDocumentsByType(AsyncOntologyIndexer.createOntologyDocumentType(ontologyIri));
        this.searchService.deleteDocumentsByType(AsyncOntologyIndexer.createOntologyTermDocumentType(ontologyIri));
    }

    @Override
    public String getOntologyUri() {
        return this.indexingOntologyIri;
    }

    @Override
    public boolean isCorrectOntology() {
        return this.isCorrectOntology;
    }

    public static String createOntologyDocumentType(String ontologyIri) {
        if (StringUtils.isEmpty((CharSequence)ontologyIri)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ontology-").append(ontologyIri);
        return stringBuilder.toString();
    }

    public static String createOntologyTermDocumentType(String ontologyIri) {
        if (StringUtils.isEmpty((CharSequence)ontologyIri)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ontologyTerm-").append(ontologyIri);
        return stringBuilder.toString();
    }
}

