/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.ontologyservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.omx.biobankconnect.ontologyindexer.AsyncOntologyIndexer;
import org.molgenis.omx.biobankconnect.utils.NGramMatchingModel;
import org.molgenis.omx.observ.target.Ontology;
import org.molgenis.search.Hit;
import org.molgenis.search.SearchRequest;
import org.molgenis.search.SearchResult;
import org.molgenis.search.SearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.tartarus.snowball.ext.PorterStemmer;

public class OntologyService {
    private final SearchService searchService;
    private static final String COMBINED_SCORE = "combinedScore";
    private static final String FUZZY_MATCH_SIMILARITY = "~0.8";
    private static final String SCORE = "score";
    private static final String NON_WORD_SEPARATOR = "[^a-zA-Z0-9]";
    private static final int MAX_NUMBER_MATCHES = 100;
    private static final PorterStemmer stemmer = new PorterStemmer();
    public static final Character DEFAULT_SEPARATOR = Character.valueOf('|');

    @Autowired
    public OntologyService(SearchService searchService) {
        if (searchService == null) {
            throw new IllegalArgumentException("SearchService is null");
        }
        this.searchService = searchService;
    }

    public Hit getOntologyByIri(String ontologyIri) {
        QueryImpl q = new QueryImpl();
        q.pageSize(Integer.MAX_VALUE);
        q.addRule(new QueryRule("entity_type", QueryRule.Operator.EQUALS, "indexedOntology"));
        q.addRule(new QueryRule(QueryRule.Operator.AND));
        q.addRule(new QueryRule("ontologyIRI", QueryRule.Operator.EQUALS, ontologyIri));
        SearchRequest searchRequest = new SearchRequest(AsyncOntologyIndexer.createOntologyDocumentType(ontologyIri), (Query)q, null);
        List searchHits = this.searchService.search(searchRequest).getSearchHits();
        if (searchHits.size() > 0) {
            return (Hit)searchHits.get(0);
        }
        return new Hit(null, AsyncOntologyIndexer.createOntologyDocumentType(ontologyIri), Collections.emptyMap());
    }

    public Hit findOntologyTerm(String ontologyIri, String ontologyTermIri, String nodePath) {
        Query q = new QueryImpl().eq("nodePath", (Object)nodePath).and().eq("ontologyTermIRI", (Object)ontologyTermIri).pageSize(5000);
        String documentType = AsyncOntologyIndexer.createOntologyTermDocumentType(ontologyIri);
        SearchResult result = this.searchService.search(new SearchRequest(documentType, q, null));
        for (Hit hit : result.getSearchHits()) {
            if (!hit.getColumnValueMap().get("nodePath").toString().equals(nodePath)) continue;
            return hit;
        }
        return new Hit(null, documentType, Collections.emptyMap());
    }

    public List<Hit> getChildren(String ontologyIri, String parentOntologyTermIri, String parentNodePath) {
        Query q = new QueryImpl().eq("parentNodePath", (Object)parentNodePath).and().eq("parentOntologyTermIRI", (Object)parentOntologyTermIri).pageSize(5000);
        String documentType = AsyncOntologyIndexer.createOntologyTermDocumentType(ontologyIri);
        ArrayList<Hit> listOfHits = new ArrayList<Hit>();
        HashSet<String> processedOntologyTerms = new HashSet<String>();
        for (Hit hit : this.searchService.search(new SearchRequest(documentType, q, null)).getSearchHits()) {
            String ontologyTermIri = hit.getColumnValueMap().get("ontologyTermIRI").toString();
            if (processedOntologyTerms.contains(ontologyTermIri)) continue;
            listOfHits.add(hit);
            processedOntologyTerms.add(ontologyTermIri);
        }
        return listOfHits;
    }

    public List<Hit> getRootOntologyTerms(String ontologyIri) {
        SearchRequest searchRequest = new SearchRequest(AsyncOntologyIndexer.createOntologyTermDocumentType(ontologyIri), new QueryImpl().pageSize(Integer.MAX_VALUE).eq("root", (Object)true), null);
        ArrayList<Hit> listOfHits = new ArrayList<Hit>();
        HashSet<String> processedOntologyTerms = new HashSet<String>();
        for (Hit hit : this.searchService.search(searchRequest)) {
            String ontologyTermIri = hit.getColumnValueMap().get("ontologyTermIRI").toString();
            if (processedOntologyTerms.contains(ontologyTermIri)) continue;
            listOfHits.add(hit);
            processedOntologyTerms.add(ontologyTermIri);
        }
        return listOfHits;
    }

    public List<Ontology> getAllOntologies() {
        ArrayList<Ontology> ontologies = new ArrayList<Ontology>();
        QueryImpl q = new QueryImpl();
        q.pageSize(Integer.MAX_VALUE);
        q.addRule(new QueryRule("entity_type", QueryRule.Operator.EQUALS, "indexedOntology"));
        SearchRequest searchRequest = new SearchRequest(null, (Query)q, null);
        for (Hit hit : this.searchService.search(searchRequest).getSearchHits()) {
            Ontology ontology = new Ontology();
            ontology.setIdentifier(hit.getColumnValueMap().get("ontologyIRI").toString());
            ontology.setOntologyURI(hit.getColumnValueMap().get("ontologyIRI").toString());
            ontology.setName(hit.getColumnValueMap().get("ontologyName").toString());
            ontologies.add(ontology);
        }
        return ontologies;
    }

    public SearchResult search(String ontologyIri, String queryString) {
        HashSet<String> uniqueTerms = new HashSet<String>(Arrays.asList(queryString.toLowerCase().trim().split(NON_WORD_SEPARATOR)));
        uniqueTerms.removeAll(NGramMatchingModel.STOPWORDSLIST);
        ArrayList<QueryRule> rules = new ArrayList<QueryRule>();
        for (String term : uniqueTerms) {
            if (StringUtils.isEmpty((CharSequence)term) || term.matches(" +")) continue;
            stemmer.setCurrent(term.replaceAll("[^(a-zA-Z0-9 )]", ""));
            stemmer.stem();
            rules.add(new QueryRule("ontologyTermSynonym", QueryRule.Operator.EQUALS, stemmer.getCurrent() + FUZZY_MATCH_SIMILARITY));
        }
        QueryRule finalQuery = new QueryRule(rules);
        finalQuery.setOperator(QueryRule.Operator.SHOULD);
        SearchRequest request = new SearchRequest(AsyncOntologyIndexer.createOntologyTermDocumentType(ontologyIri), new QueryImpl(finalQuery).pageSize(100), null);
        Iterator iterator = this.searchService.search(request).getSearchHits().iterator();
        ArrayList<ComparableHit> comparableHits = new ArrayList<ComparableHit>();
        while (iterator.hasNext()) {
            Hit hit = (Hit)iterator.next();
            String ontologySynonym = hit.getColumnValueMap().get("ontologyTermSynonym").toString();
            BigDecimal luceneScore = new BigDecimal(hit.getColumnValueMap().get(SCORE).toString());
            BigDecimal ngramScore = new BigDecimal(NGramMatchingModel.stringMatching(StringUtils.join(uniqueTerms, (String)"\\s"), ontologySynonym));
            comparableHits.add(new ComparableHit(hit, luceneScore.multiply(ngramScore)));
        }
        Collections.sort(comparableHits);
        return this.convertResults(comparableHits);
    }

    private SearchResult convertResults(List<ComparableHit> comparableHits) {
        ArrayList<Hit> hits = new ArrayList<Hit>();
        HashSet<String> uniqueIdentifiers = new HashSet<String>();
        for (ComparableHit comparableHit : comparableHits) {
            Hit hit = comparableHit.getHit();
            String identifier = hit.getColumnValueMap().get("ontologyTermIRI").toString();
            if (uniqueIdentifiers.contains(identifier)) continue;
            uniqueIdentifiers.add(identifier);
            HashMap<String, Double> columnValueMap = new HashMap<String, Double>();
            columnValueMap.putAll(hit.getColumnValueMap());
            columnValueMap.put(COMBINED_SCORE, comparableHit.getSimilarityScore().doubleValue());
            Hit copyHit = new Hit(hit.getId(), hit.getDocumentType(), columnValueMap);
            hits.add(copyHit);
        }
        return new SearchResult((long)hits.size(), hits);
    }

    class ComparableHit
    implements Comparable<ComparableHit> {
        private final Hit hit;
        private final BigDecimal similarityScore;

        public ComparableHit(Hit hit, BigDecimal similarityScore) {
            this.hit = hit;
            this.similarityScore = similarityScore;
        }

        private BigDecimal getSimilarityScore() {
            return this.similarityScore;
        }

        public Hit getHit() {
            return this.hit;
        }

        @Override
        public int compareTo(ComparableHit other) {
            return this.similarityScore.compareTo(other.getSimilarityScore()) * -1;
        }
    }
}

