/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.ontologyservice;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.Entity;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.excel.ExcelSheetWriter;
import org.molgenis.data.excel.ExcelWriter;
import org.molgenis.data.processor.CellProcessor;
import org.molgenis.data.processor.LowerCaseProcessor;
import org.molgenis.data.rest.EntityCollectionResponse;
import org.molgenis.data.rest.EntityPager;
import org.molgenis.data.support.MapEntity;
import org.molgenis.framework.ui.MolgenisPluginController;
import org.molgenis.omx.biobankconnect.ontologyservice.OntologyService;
import org.molgenis.omx.biobankconnect.ontologyservice.OntologyServiceRequest;
import org.molgenis.search.Hit;
import org.molgenis.search.SearchResult;
import org.molgenis.util.FileStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/plugin/ontologyservice"})
public class OntologyServiceController
extends MolgenisPluginController {
    @Autowired
    private OntologyService ontologyService;
    @Autowired
    private FileStore fileStore;
    public static final String ID = "ontologyservice";
    public static final String URI = "/plugin/ontologyservice";
    private String ontologyUrl = null;
    private List<String> inputLines = new ArrayList<String>();

    public OntologyServiceController() {
        super(URI);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String init(Model model) {
        model.addAttribute("ontologies", this.ontologyService.getAllOntologies());
        return "ontology-match-view";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/match"})
    public String match(@RequestParam(value="selectOntologies", required=true) String ontologyUrl, @RequestParam(value="inputTerms", required=true) String inputTerms, Model model) {
        if (StringUtils.isEmpty((CharSequence)ontologyUrl) || StringUtils.isEmpty((CharSequence)inputTerms)) {
            return this.init(model);
        }
        this.ontologyUrl = ontologyUrl;
        this.inputLines = Arrays.asList(inputTerms.split("\n"));
        model.addAttribute("total", (Object)inputTerms.split("\n").length);
        model.addAttribute("ontologyUrl", (Object)this.ontologyUrl);
        return "ontology-match-view-result";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.POST}, value={"/match/upload"}, headers={"Content-Type=multipart/form-data"})
    public String upload(@RequestParam(value="selectOntologies", required=true) String ontologyUrl, @RequestParam(value="file", required=true) Part file, Model model) throws IOException {
        if (StringUtils.isEmpty((CharSequence)ontologyUrl) || file == null) {
            return this.init(model);
        }
        this.ontologyUrl = ontologyUrl;
        Closeable reader = null;
        try {
            File uploadFile = this.fileStore.store(file.getInputStream(), file.getName() + "_input.txt");
            this.inputLines = this.collectAllLinesFromFile(uploadFile);
            model.addAttribute("total", (Object)this.inputLines.size());
        }
        finally {
            if (reader != null) {
                IOUtils.closeQuietly(reader);
            }
        }
        return "ontology-match-view-result";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(method={RequestMethod.GET}, value={"/match/download"})
    public void download(HttpServletResponse response, Model model) throws IOException {
        if (this.ontologyUrl == null || this.inputLines == null) return;
        ExcelWriter excelWriter = null;
        try {
            response.setContentType("application/vnd.ms-excel");
            response.addHeader("Content-Disposition", "attachment; filename=" + this.getCsvFileName("match-result"));
            excelWriter = new ExcelWriter((OutputStream)response.getOutputStream());
            excelWriter.addCellProcessor((CellProcessor)new LowerCaseProcessor(true, false));
            int iteration = this.inputLines.size() / 1000 + 1;
            List<String> columnHeaders = Arrays.asList("InputTerm", "OntologyTerm", "Synonym used for matching", "OntologyTermUrl", "OntologyUrl", "CombinedScore", "LuceneScore");
            for (int i = 0; i < iteration; ++i) {
                ExcelSheetWriter sheetWriter = excelWriter.createWritable("result" + (i + 1), columnHeaders);
                int lowerBound = i * 1000;
                int upperBound = (i + 1) * 1000 < this.inputLines.size() ? (i + 1) * 1000 : this.inputLines.size();
                for (String term : this.inputLines.subList(lowerBound, upperBound)) {
                    for (Hit hit : this.ontologyService.search(this.ontologyUrl, term).getSearchHits()) {
                        MapEntity row = new MapEntity();
                        row.set("InputTerm", (Object)term);
                        row.set("OntologyTerm", hit.getColumnValueMap().get("ontologyTerm"));
                        row.set("Synonym used for matching", hit.getColumnValueMap().get("ontologyTermSynonym"));
                        row.set("OntologyTermUrl", hit.getColumnValueMap().get("ontologyTermIRI"));
                        row.set("OntologyUrl", hit.getColumnValueMap().get("ontologyIRI"));
                        row.set("CombinedScore", hit.getColumnValueMap().get("combinedScore"));
                        row.set("LuceneScore", hit.getColumnValueMap().get("score"));
                        sheetWriter.add((Entity)row);
                    }
                }
            }
            if (excelWriter == null) return;
        }
        catch (Throwable throwable) {
            if (excelWriter == null) throw throwable;
            IOUtils.closeQuietly(excelWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)excelWriter);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/match/retrieve"})
    @ResponseBody
    public EntityCollectionResponse matchResult(@RequestBody EntityPager entityPager) {
        int num;
        int start;
        if (this.inputLines == null || this.inputLines.isEmpty()) {
            throw new UnknownEntityException("The inputTerms is empty!");
        }
        if (StringUtils.isEmpty((CharSequence)this.ontologyUrl)) {
            throw new UnknownEntityException("The ontologyUrl is empty!");
        }
        ArrayList entities = new ArrayList();
        int count = this.inputLines.size();
        int toIndex = (start = entityPager.getStart()) + (num = entityPager.getNum());
        for (String eachLine : this.inputLines.subList(start, toIndex > count ? count : toIndex)) {
            HashMap<String, String> entity = new HashMap<String, String>();
            entity.put("term", eachLine);
            entity.put("results", (String)this.ontologyService.search(this.ontologyUrl, eachLine));
            entities.add(entity);
        }
        EntityPager pager = new EntityPager(start, num, Long.valueOf(count), null);
        return new EntityCollectionResponse(pager, entities, "/match/retrieve");
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public SearchResult query(@RequestBody OntologyServiceRequest ontologyTermRequest) {
        String ontologyUrl = ontologyTermRequest.getOntologyIri();
        String queryString = ontologyTermRequest.getQueryString();
        if (ontologyUrl == null || queryString == null) {
            return new SearchResult(0L, Collections.emptyList());
        }
        return this.ontologyService.search(ontologyUrl, queryString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> collectAllLinesFromFile(File uploadFile) throws IOException {
        ArrayList<String> terms = new ArrayList<String>();
        FileInputStream inputStream = null;
        String line = null;
        try (BufferedReader bufferedReader = null;){
            inputStream = new FileInputStream(uploadFile);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, Charset.forName("UTF-8")));
            while ((line = bufferedReader.readLine()) != null) {
                if (StringUtils.isEmpty((CharSequence)line)) continue;
                terms.add(line.trim());
            }
        }
        return terms;
    }

    private String getCsvFileName(String dataSetName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dataSetName + "_" + dateFormat.format(new Date()) + ".xls";
    }
}

