/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.ontologytree;

import java.util.Map;
import org.molgenis.data.DataService;
import org.molgenis.data.Repository;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.omx.biobankconnect.ontology.repository.OntologyQueryRepository;
import org.molgenis.omx.biobankconnect.ontology.repository.OntologyTermQueryRepository;
import org.molgenis.omx.biobankconnect.ontologyservice.OntologyService;
import org.molgenis.search.Hit;
import org.molgenis.search.SearchRequest;
import org.molgenis.search.SearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class OntologyRepositoryRegistrator
implements ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private final DataService dataService;
    private final SearchService searchService;
    private final OntologyService ontologyService;

    @Autowired
    public OntologyRepositoryRegistrator(SearchService searchService, DataService dataService, OntologyService ontologyService) {
        this.searchService = searchService;
        this.dataService = dataService;
        this.ontologyService = ontologyService;
    }

    public int getOrder() {
        return -2147483646;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.dataService.addRepository((Repository)new OntologyQueryRepository("ontologyindex", this.ontologyService, this.searchService));
        for (Hit hit : this.searchService.search(new SearchRequest(null, new QueryImpl().eq("entity_type", (Object)"indexedOntology"), null)).getSearchHits()) {
            Map columnValueMap = hit.getColumnValueMap();
            String ontologyTermEntityName = columnValueMap.containsKey("ontologyName") ? columnValueMap.get("ontologyName").toString() : "ontologytermindex";
            String ontologyIri = columnValueMap.containsKey("ontologyName") ? columnValueMap.get("ontologyIRI").toString() : "ontologytermindex";
            this.dataService.addRepository((Repository)new OntologyTermQueryRepository(ontologyTermEntityName, ontologyIri, this.searchService));
        }
    }
}

