/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.molgenis.data.Entity;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.Writable;
import org.molgenis.data.WritableFactory;
import org.molgenis.data.excel.ExcelRepositoryCollection;
import org.molgenis.data.excel.ExcelWriter;
import org.molgenis.data.processor.CellProcessor;
import org.molgenis.data.processor.TrimProcessor;
import org.molgenis.data.support.MapEntity;

abstract class AbstractOmxConvertor {
    public Map<String, List<UniqueCategory>> featureCategoryLinks = new LinkedHashMap<String, List<UniqueCategory>>();
    public Map<String, List<String>> protocolFeatureLinks = new LinkedHashMap<String, List<String>>();
    public Map<String, UniqueVariable> variableInfo = new LinkedHashMap<String, UniqueVariable>();
    public Map<String, UniqueCategory> categoryInfo = new LinkedHashMap<String, UniqueCategory>();
    public String studyName = null;

    public AbstractOmxConvertor(String studyName, String filePath) throws IOException, InvalidFormatException {
        this.studyName = studyName;
        this.start(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String fileString) throws IOException, InvalidFormatException {
        File file = new File(fileString);
        if (file.exists()) {
            ExcelRepositoryCollection repositoryCollection = new ExcelRepositoryCollection(file, new CellProcessor[]{new TrimProcessor()});
            this.collectCategoryInfo((RepositoryCollection)repositoryCollection);
            this.collectVariableInfo((RepositoryCollection)repositoryCollection);
            this.collectProtocolInfo((RepositoryCollection)repositoryCollection);
            try (ExcelWriter writer = null;){
                writer = new ExcelWriter(new File(file.getAbsolutePath() + "_OMX.xls"));
                this.writeToPhenoFormat((WritableFactory)writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToPhenoFormat(WritableFactory writer) throws IOException {
        String protocolIdentifier = this.studyName + "_protocol";
        StringBuilder listOfFeatureIdentifier = new StringBuilder();
        try (Writable dataSet = null;){
            dataSet = writer.createWritable("dataset", Arrays.asList("identifier", "name", "protocolUsed_identifier"));
            MapEntity entity = new MapEntity();
            entity.set("identifier", (Object)this.studyName);
            entity.set("name", (Object)this.studyName);
            entity.set("protocolUsed_identifier", (Object)protocolIdentifier);
            dataSet.add((Entity)entity);
        }
        try (Writable categorySheet = null;){
            categorySheet = writer.createWritable("category", Arrays.asList("identifier", "name", "valueCode", "observablefeature_identifier"));
            for (Map.Entry<String, List<UniqueCategory>> entry : this.featureCategoryLinks.entrySet()) {
                String featureIdentifier = this.createFeatureIdentifier(entry.getKey());
                List<UniqueCategory> categoriesPerFeature = entry.getValue();
                for (UniqueCategory uniqueCategory : categoriesPerFeature) {
                    MapEntity entity = new MapEntity();
                    entity.set("identifier", (Object)uniqueCategory.getIdentifier());
                    entity.set("name", (Object)uniqueCategory.getLabel());
                    entity.set("valueCode", (Object)uniqueCategory.getCode());
                    entity.set("observablefeature_identifier", (Object)featureIdentifier);
                    categorySheet.add((Entity)entity);
                }
            }
        }
        try (Writable featureWriter = null;){
            featureWriter = writer.createWritable("observablefeature", Arrays.asList("identifier", "name", "description", "dataType", "unit_Identifier"));
            int count = 0;
            for (UniqueVariable eachVariable : this.variableInfo.values()) {
                MapEntity eachRow = new MapEntity();
                String string = eachVariable.getVariable();
                String dataType = eachVariable.getDataType();
                String identifier = eachVariable.getIdentifier();
                StringBuilder categoriesName = new StringBuilder();
                if (this.featureCategoryLinks.containsKey(string)) {
                    for (UniqueCategory eachCategory : this.featureCategoryLinks.get(string)) {
                        categoriesName.append(eachCategory.getName()).append(',');
                    }
                    dataType = "categorical";
                } else {
                    dataType = dataType != null && dataType.equals("integer") ? "int" : (dataType != null && dataType.equals("decimal") ? "decimal" : "string");
                }
                listOfFeatureIdentifier.append(identifier).append(',');
                eachRow.set("identifier", (Object)identifier);
                eachRow.set("name", (Object)string);
                eachRow.set("description", (Object)eachVariable.getLabel());
                eachRow.set("dataType", (Object)dataType);
                featureWriter.add((Entity)eachRow);
                System.out.println(++count);
            }
        }
        try (Writable protocolSheet = null;){
            protocolSheet = writer.createWritable("protocol", Arrays.asList("identifier", "name", "features_identifier", "subprotocols_identifier"));
            MapEntity protocol = new MapEntity();
            protocol.set("identifier", (Object)protocolIdentifier);
            protocol.set("name", (Object)protocolIdentifier);
            ArrayList<String> subProtocolIdentifiers = new ArrayList<String>();
            if (this.protocolFeatureLinks.size() == 0) {
                protocol.set("features_identifier", (Object)listOfFeatureIdentifier.substring(0, listOfFeatureIdentifier.length() - 1).toString());
                System.out.println(listOfFeatureIdentifier.substring(0, listOfFeatureIdentifier.length() - 1).toString());
            } else {
                for (Map.Entry entry : this.protocolFeatureLinks.entrySet()) {
                    String subProtocolName = (String)entry.getKey();
                    String subProtocolIdentifier = this.createProtocolIdentifier(subProtocolName);
                    MapEntity subProtocol = new MapEntity();
                    subProtocol.set("identifier", (Object)subProtocolIdentifier);
                    subProtocol.set("name", (Object)subProtocolName);
                    subProtocol.set("features_identifier", (Object)StringUtils.join((Iterable)((Iterable)entry.getValue()), (char)','));
                    protocolSheet.add((Entity)subProtocol);
                    subProtocolIdentifiers.add(subProtocolIdentifier);
                }
            }
            protocol.set("subprotocols_identifier", (Object)StringUtils.join(subProtocolIdentifiers, (char)','));
            protocolSheet.add((Entity)protocol);
        }
    }

    public abstract void collectProtocolInfo(RepositoryCollection var1) throws IOException;

    public abstract void collectVariableInfo(RepositoryCollection var1) throws IOException;

    public abstract void collectCategoryInfo(RepositoryCollection var1) throws IOException;

    public String createFeatureIdentifier(String featureName) {
        return this.studyName + "_feature_" + featureName;
    }

    public String createProtocolIdentifier(String protocolTname) {
        return this.studyName + "_protocol_" + protocolTname;
    }

    public String createCategoryIdentifier(String categoryName) {
        return this.studyName + "_category_" + categoryName;
    }

    public class UniqueCategory {
        private final String code;
        private final String label;
        private final String name;
        private String identifier;

        public UniqueCategory(String code, String label) {
            this.code = code.trim();
            this.label = label != null ? label.trim() : "";
            StringBuilder name = new StringBuilder();
            this.name = name.append(code).append('_').append(label).toString().replaceAll("[^a-zA-Z0-9_]", "_").toLowerCase();
            this.identifier = AbstractOmxConvertor.this.createCategoryIdentifier(this.name);
        }

        public UniqueCategory(String name, String code, String label) {
            this.code = code.trim();
            this.label = label != null ? label.trim() : "";
            this.name = name.replaceAll("[^a-zA-Z0-9_]", "_");
            this.identifier = AbstractOmxConvertor.this.createCategoryIdentifier(this.name);
        }

        public String getName() {
            return this.name;
        }

        public String getCode() {
            return this.code;
        }

        public String getLabel() {
            return this.label;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UniqueCategory other = (UniqueCategory)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
                return false;
            }
            return !(this.label == null ? other.label != null : !this.label.equals(other.label));
        }

        private AbstractOmxConvertor getOuterType() {
            return AbstractOmxConvertor.this;
        }
    }

    public class UniqueVariable {
        private String identifier;
        private final String variable;
        private final String label;
        private final String dataType;

        public UniqueVariable(String variable, String label, String dataType) {
            this.variable = variable;
            this.label = label;
            this.dataType = dataType;
            this.identifier = AbstractOmxConvertor.this.createFeatureIdentifier(variable);
        }

        public String getVariable() {
            return this.variable;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDataType() {
            return this.dataType;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }
    }
}

