/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.molgenis.omx.biobankconnect.utils.OntologyLoader;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OntologyCreator {
    private OWLOntology ontology = null;
    private OWLOntologyManager manager = null;
    private OWLDataFactory factory = null;
    private Set<String> termsFound = null;
    private Set<String> termsNotFound = null;

    public OntologyCreator(String prefix) throws OWLOntologyCreationException {
        this.manager = OWLManager.createOWLOntologyManager();
        this.factory = this.manager.getOWLDataFactory();
        this.createOntology(prefix);
    }

    public OntologyCreator(OWLOntologyManager manager, OWLDataFactory factory, OntologyLoader ontologyLoader) {
        this.manager = manager;
        this.factory = factory;
        this.termsFound = new HashSet<String>();
        this.termsNotFound = new HashSet<String>();
    }

    public void addClass(OWLClass cls, OWLClass parentClass) {
        if (parentClass == null) {
            parentClass = this.factory.getOWLThing();
        }
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.factory.getOWLSubClassOfAxiom((OWLClassExpression)cls, (OWLClassExpression)parentClass)));
    }

    public void addSynonym(OWLClass cls, String synonym) {
        OWLAnnotationProperty property = this.factory.getOWLAnnotationProperty(IRI.create((String)"http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#FULL_SYN"));
        OWLAnnotation commentAnno = this.factory.getOWLAnnotation(property, (OWLAnnotationValue)this.factory.getOWLLiteral(synonym, "en"));
        OWLAnnotationAssertionAxiom ax = this.factory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)cls.getIRI(), commentAnno);
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)ax));
    }

    public void addLabel(OWLClass cls, String label) {
        OWLAnnotationProperty property = this.factory.getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_LABEL.getIRI());
        OWLAnnotation commentAnno = this.factory.getOWLAnnotation(property, (OWLAnnotationValue)this.factory.getOWLLiteral(label, "en"));
        OWLAnnotationAssertionAxiom ax = this.factory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)cls.getIRI(), commentAnno);
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)ax));
    }

    public OWLClass createOWLClass(String URI2) {
        OWLClass cls = this.factory.getOWLClass(IRI.create((String)URI2));
        return cls;
    }

    public OWLAnnotation createLabelAnnotation(String label) {
        return this.createAnnotation(label, OWLRDFVocabulary.RDFS_LABEL.toString());
    }

    public OWLAnnotation createDefinitionAnnotation(String definition) {
        return this.createAnnotation(definition, OWLRDFVocabulary.RDFS_COMMENT.toString());
    }

    public OWLAnnotation createAnnotation(String text, String property) {
        OWLAnnotationProperty annotationProperty = this.factory.getOWLAnnotationProperty(IRI.create((String)property));
        OWLLiteral value = this.factory.getOWLLiteral(text, "en");
        return this.factory.getOWLAnnotation(annotationProperty, (OWLAnnotationValue)value);
    }

    public void addAnnotations(OWLClass cls, Set<OWLAnnotation> annotations) {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLAnnotation annotation : annotations) {
            changes.add(new AddAxiom(this.ontology, (OWLAxiom)this.factory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)cls.getIRI(), annotation)));
        }
        this.manager.applyChanges(changes);
    }

    public void createOntology(String ontologyIRI) throws OWLOntologyCreationException {
        this.ontology = this.manager.createOntology(IRI.create((String)ontologyIRI));
    }

    public void saveOntology(File file) throws OWLOntologyStorageException {
        this.manager.saveOntology(this.ontology, IRI.create((File)file));
    }

    public void copyClass(OWLClass cls, OWLClass parentClass, OntologyLoader ontologyLoader) {
        this.manager.applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)this.factory.getOWLSubClassOfAxiom((OWLClassExpression)cls, (OWLClassExpression)parentClass)));
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLAnnotationAssertionAxiom axiom : ontologyLoader.getAllAnnotationAxiom(cls)) {
            changes.add(new AddAxiom(this.ontology, (OWLAxiom)axiom));
        }
        this.manager.applyChanges(changes);
    }

    public void copySubclass(OWLClass cls, OntologyLoader ontologyLoader) {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLSubClassOfAxiom axiom : ontologyLoader.getSubClassAxiomsForSuperClass(cls)) {
            for (OWLClass subClass : axiom.getClassesInSignature()) {
                if (subClass == cls || subClass.isAnonymous()) continue;
                this.copyClass(subClass, cls, ontologyLoader);
                this.copySubclass(subClass, ontologyLoader);
            }
            changes.add(new AddAxiom(this.ontology, (OWLAxiom)axiom));
        }
        this.manager.applyChanges(changes);
    }

    private void copySuperClasse(OWLClass cls, OntologyLoader ontologyLoader) {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLSubClassOfAxiom axiom : ontologyLoader.getSubClassAxiomsForSubClass(cls)) {
            OWLClassExpression expression = axiom.getSuperClass();
            if (expression.isAnonymous()) continue;
            this.copyClass(cls, expression.asOWLClass(), ontologyLoader);
            this.copySuperClasse(expression.asOWLClass(), ontologyLoader);
            changes.add(new AddAxiom(this.ontology, (OWLAxiom)axiom));
        }
        if (changes.size() == 0) {
            this.copyClass(cls, this.factory.getOWLThing(), ontologyLoader);
        } else {
            this.manager.applyChanges(changes);
        }
    }

    public void parseOntologyTerms(Set<String> terms, OntologyLoader ontologyLoader) {
        Map<String, OWLClass> hashRetrieveClass = ontologyLoader.getHashToRetrieveClass();
        for (String term : terms) {
            if (hashRetrieveClass.containsKey(term = term.trim().toLowerCase())) {
                OWLClass cls = hashRetrieveClass.get(term);
                this.copySubclass(cls, ontologyLoader);
                this.copySuperClasse(cls, ontologyLoader);
                this.termsFound.add(term);
                continue;
            }
            this.termsNotFound.add(term);
        }
    }
}

