/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OntologyLoader {
    private static String DB_ID_PATTERN = "(\\w*):(\\d*)";
    private String ontologyIRI = null;
    private String ontologyName = null;
    private File ontologyFile = null;
    private OWLDataFactory factory = null;
    private OWLOntology ontology = null;
    private OWLOntologyManager manager = null;
    private Set<String> synonymsProperties = new HashSet<String>(Arrays.asList("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#FULL_SYN", "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#P90", "http://www.geneontology.org/formats/oboInOwl#hasExactSynonym", "http://www.ebi.ac.uk/efo/alternative_term"));
    private Set<String> owlObjectProperties = new HashSet<String>(Arrays.asList("http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#is_associated_with"));
    private Set<String> ontologyTermDefinitions = new HashSet<String>(Arrays.asList("http://purl.obolibrary.org/obo/", "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#DEFINITION"));
    private Map<String, OWLClass> hashToRetrieveClass = new HashMap<String, OWLClass>();

    public OntologyLoader(OWLOntologyManager manager, OWLDataFactory factory) {
        this.manager = manager;
        this.factory = factory;
    }

    public OntologyLoader(String ontologyName, File ontologyFile) throws OWLOntologyCreationException {
        this.ontologyFile = ontologyFile;
        this.manager = OWLManager.createOWLOntologyManager();
        this.factory = this.manager.getOWLDataFactory();
        this.ontologyName = ontologyName;
        this.ontology = this.manager.loadOntologyFromOntologyDocument(ontologyFile);
        this.ontologyIRI = this.ontology.getOntologyID().getOntologyIRI().toString();
    }

    public void loadOntology(String ontologyName, File ontologyFile) throws OWLOntologyCreationException {
        this.ontologyName = ontologyName;
        this.ontologyFile = ontologyFile;
        this.ontology = this.manager.loadOntologyFromOntologyDocument(ontologyFile);
        this.ontologyIRI = this.ontology.getOntologyID().getOntologyIRI().toString();
    }

    public void preProcessing() {
        for (OWLClass cls : this.ontology.getClassesInSignature()) {
            this.hashToRetrieveClass.put(this.getLabel((OWLEntity)cls).trim().toLowerCase(), cls);
        }
    }

    public Set<OWLAnnotationAssertionAxiom> getAllAnnotationAxiom(OWLClass cls) {
        HashSet<OWLAnnotationAssertionAxiom> axioms = new HashSet<OWLAnnotationAssertionAxiom>();
        for (OWLAnnotation annotation : cls.getAnnotations(this.ontology)) {
            axioms.add(this.factory.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)cls.getIRI(), annotation));
        }
        return axioms;
    }

    public Set<OWLClass> getRootClasses() {
        HashSet<OWLClass> listOfTopClasses = new HashSet<OWLClass>();
        for (OWLClass cls : this.ontology.getClassesInSignature()) {
            if (this.ontology.getSubClassAxiomsForSubClass(cls).size() != 0 || this.ontology.getEquivalentClassesAxioms(cls).size() != 0) continue;
            listOfTopClasses.add(cls);
        }
        return listOfTopClasses;
    }

    public List<Set<OWLClass>> getAssociatedClasses(OWLClass cls) {
        ArrayList<Set<OWLClass>> alternativeDefinitions = new ArrayList<Set<OWLClass>>();
        for (OWLSubClassOfAxiom axiom : this.ontology.getSubClassAxiomsForSubClass(cls)) {
            HashSet<OWLClass> associatedTerms = new HashSet<OWLClass>();
            OWLClassExpression expression = axiom.getSuperClass();
            if (expression.isAnonymous()) {
                for (OWLObjectProperty property : expression.getObjectPropertiesInSignature()) {
                    if (!this.owlObjectProperties.contains(property.getIRI().toString())) continue;
                    for (OWLClass associatedClass : expression.getClassesInSignature()) {
                        associatedTerms.add(associatedClass);
                    }
                }
            }
            alternativeDefinitions.add(associatedTerms);
        }
        return alternativeDefinitions;
    }

    public Set<OWLClass> getChildClass(OWLClass cls) {
        HashSet<OWLClass> listOfClasses = new HashSet<OWLClass>();
        for (OWLSubClassOfAxiom axiom : this.ontology.getSubClassAxiomsForSuperClass(cls)) {
            OWLClassExpression expression = axiom.getSubClass();
            if (expression.isAnonymous()) continue;
            listOfClasses.add(expression.asOWLClass());
        }
        return listOfClasses;
    }

    public String getId(OWLClass entity) {
        for (OWLAnnotationProperty owlObjectProperty : this.ontology.getAnnotationPropertiesInSignature()) {
            Iterator<String> i$;
            if (!this.ifExistsAnnotation(owlObjectProperty.toString(), "id") || !(i$ = this.getAnnotation((OWLEntity)entity, owlObjectProperty.getIRI().toString()).iterator()).hasNext()) continue;
            String annotation = i$.next();
            return annotation;
        }
        return "";
    }

    private boolean ifExistsAnnotation(String propertyUrl, String keyword) {
        String pattern = "[\\W_]*" + keyword + "[\\W_]*";
        String[] urlFragments = propertyUrl.split("[#/]");
        if (urlFragments.length > 1) {
            String label = urlFragments[urlFragments.length - 1].replaceAll("[\\W]", "_");
            for (String token : label.split("_")) {
                if (!token.matches(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<String> getSynonyms(OWLClass cls) {
        HashSet<String> listOfSynonyms = new HashSet<String>();
        for (String eachSynonymProperty : this.synonymsProperties) {
            listOfSynonyms.addAll(this.getAnnotation((OWLEntity)cls, eachSynonymProperty));
        }
        return listOfSynonyms;
    }

    public String getDefinition(OWLClass cls) {
        for (String definitionProperty : this.ontologyTermDefinitions) {
            Iterator<String> i$ = this.getAnnotation((OWLEntity)cls, definitionProperty).iterator();
            if (!i$.hasNext()) continue;
            String definition = i$.next();
            return definition;
        }
        return "";
    }

    public String getLabel(OWLEntity entity) {
        Iterator<String> i$ = this.getAnnotation(entity, OWLRDFVocabulary.RDFS_LABEL.toString()).iterator();
        if (i$.hasNext()) {
            String annotation = i$.next();
            return annotation;
        }
        return "";
    }

    private Set<String> getAnnotation(OWLEntity entity, String property) {
        HashSet<String> annotations = new HashSet<String>();
        try {
            OWLAnnotationProperty owlAnnotationProperty = this.factory.getOWLAnnotationProperty(IRI.create((String)property));
            for (OWLAnnotation annotation : entity.getAnnotations(this.ontology, owlAnnotationProperty)) {
                if (!(annotation.getValue() instanceof OWLLiteral)) continue;
                OWLLiteral val = (OWLLiteral)annotation.getValue();
                annotations.add(val.getLiteral().toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get label for OWLClass " + entity);
        }
        return annotations;
    }

    public Map<String, Set<String>> getAllDatabaseIds(OWLClass entity) {
        HashMap<String, Set<String>> dbAnnotations = new HashMap<String, Set<String>>();
        for (OWLAnnotation annotation : entity.getAnnotations(this.ontology)) {
            OWLLiteral val;
            String value;
            if (!(annotation.getValue() instanceof OWLLiteral) || !(value = (val = (OWLLiteral)annotation.getValue()).getLiteral().toString()).matches(DB_ID_PATTERN)) continue;
            String databaseName = value.replaceAll(DB_ID_PATTERN, "$1");
            if (!dbAnnotations.containsKey(databaseName)) {
                dbAnnotations.put(databaseName, new HashSet());
            }
            ((Set)dbAnnotations.get(databaseName)).add(value.replaceAll(DB_ID_PATTERN, "$2"));
        }
        return dbAnnotations;
    }

    public String getOntologyLabel() {
        OWLAnnotationProperty labelProperty = this.factory.getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_LABEL.getIRI());
        String ontologyLabel = "";
        for (OWLAnnotation annotation : this.ontology.getAnnotations()) {
            if (!annotation.getProperty().equals(labelProperty) || !(annotation.getValue() instanceof OWLLiteral)) continue;
            OWLLiteral val = (OWLLiteral)annotation.getValue();
            ontologyLabel = val.getLiteral();
        }
        return ontologyLabel;
    }

    public String getOntologyIRI() {
        return this.ontologyIRI;
    }

    public String getOntologyName() {
        return this.ontologyName;
    }

    public String getOntologyFilePath() {
        return this.ontologyFile.getAbsolutePath();
    }

    public Map<String, OWLClass> getHashToRetrieveClass() {
        return this.hashToRetrieveClass;
    }

    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSuperClass(OWLClass cls) {
        return this.ontology.getSubClassAxiomsForSuperClass(cls);
    }

    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSubClass(OWLClass cls) {
        return this.ontology.getSubClassAxiomsForSubClass(cls);
    }

    public void addSynonymsProperties(Set<String> synonymsProperties) {
        this.synonymsProperties.addAll(synonymsProperties);
    }
}

