/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.utils;

import java.io.File;
import java.util.Set;
import org.molgenis.omx.biobankconnect.utils.OntologyCreator;
import org.molgenis.omx.biobankconnect.utils.OntologyLoader;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;

public class OntologyManager {
    private OWLDataFactory factory = null;
    private OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    private OntologyLoader ontologyLoader = null;
    private OntologyCreator ontologyCreator = null;

    public OntologyManager() {
        this.factory = this.manager.getOWLDataFactory();
        this.ontologyLoader = new OntologyLoader(this.manager, this.factory);
        this.ontologyCreator = new OntologyCreator(this.manager, this.factory, this.ontologyLoader);
    }

    public void loadExistingOntology(File ontologyFile) throws OWLOntologyCreationException {
        this.ontologyLoader.loadOntology(null, ontologyFile);
        this.ontologyLoader.preProcessing();
    }

    public void copyOntologyContent(Set<String> terms) throws OWLOntologyCreationException {
        if (terms != null) {
            this.ontologyCreator.createOntology(this.ontologyLoader.getOntologyIRI() + ".copy");
            this.ontologyCreator.parseOntologyTerms(terms, this.ontologyLoader);
        }
    }

    public void saveOntology(File file) throws OWLOntologyStorageException {
        this.ontologyCreator.saveOntology(file);
    }
}

