/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.omx.biobankconnect.utils.AbstractOmxConvertor;

public class OpalToOmxConvertor
extends AbstractOmxConvertor {
    public OpalToOmxConvertor(String studyName, String filePath) throws IOException, InvalidFormatException {
        super(studyName, filePath);
    }

    @Override
    public void collectProtocolInfo(RepositoryCollection repositoryCollection) throws IOException {
        System.out.println("No protocol involved in OPAL format!");
    }

    @Override
    public void collectVariableInfo(RepositoryCollection repositoryCollection) throws IOException {
        Repository repo = repositoryCollection.getRepositoryByEntityName("Variables");
        for (Entity entity : repo) {
            String variableName = entity.getString("name");
            String label = entity.getString("label:en");
            String dataType = entity.getString("valueType");
            if (variableName != null) {
                variableName = variableName.trim();
            }
            if (label != null) {
                label = label.trim();
            }
            if (this.variableInfo.containsKey(variableName)) continue;
            AbstractOmxConvertor.UniqueVariable newVariable = new AbstractOmxConvertor.UniqueVariable(this, variableName, label, dataType);
            newVariable.setIdentifier(this.createFeatureIdentifier(variableName));
            this.variableInfo.put(variableName, newVariable);
        }
    }

    @Override
    public void collectCategoryInfo(RepositoryCollection repositoryCollection) throws IOException {
        Repository repo = repositoryCollection.getRepositoryByEntityName("Categories");
        for (Entity entity : repo) {
            String featureID = entity.getString("variable");
            if (featureID == null) continue;
            featureID = featureID.trim();
            String code = entity.getString("name");
            String categoryDescription = entity.getString("label:en");
            List<AbstractOmxConvertor.UniqueCategory> listOfCategoriesPerVariable = null;
            listOfCategoriesPerVariable = this.featureCategoryLinks.containsKey(featureID) ? (List)this.featureCategoryLinks.get(featureID) : new ArrayList<AbstractOmxConvertor.UniqueCategory>();
            listOfCategoriesPerVariable.add(new AbstractOmxConvertor.UniqueCategory(this, featureID + "_" + code, code, categoryDescription));
            this.featureCategoryLinks.put(featureID, listOfCategoriesPerVariable);
        }
    }

    public static void main(String[] args) throws IOException, InvalidFormatException {
        new OpalToOmxConvertor(args[0], args[1]);
    }
}

