/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.omx.biobankconnect.wizard;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CurrentUserStatus {
    private final Map<String, String> currentUsers = new HashMap<String, String>();
    private final Map<String, STAGE> userCurrentStage = new HashMap<String, STAGE>();
    private final Map<String, Boolean> userCurrentMatching = new HashMap<String, Boolean>();
    private final Map<String, Long> totalNumberOfQueriesForUser = new HashMap<String, Long>();
    private final Map<String, Integer> finishedNumberOfQueriesForUser = new HashMap<String, Integer>();

    public void setUserCurrentStage(String userName, STAGE stage) {
        this.totalNumberOfQueriesForUser.remove(userName);
        this.finishedNumberOfQueriesForUser.remove(userName);
        this.userCurrentStage.put(userName, stage);
    }

    public void setUserTotalNumberOfQueries(String userName, Long totalNumberOfQueries) {
        this.totalNumberOfQueriesForUser.put(userName, totalNumberOfQueries);
    }

    public void incrementFinishedNumbersByOne(String userName) {
        Integer finishedNumber = null;
        finishedNumber = !this.finishedNumberOfQueriesForUser.containsKey(userName) ? Integer.valueOf(0) : this.finishedNumberOfQueriesForUser.get(userName);
        finishedNumber = finishedNumber + 1;
        this.finishedNumberOfQueriesForUser.put(userName, finishedNumber);
    }

    public void incrementFinishedNumbers(String userName, int size) {
        Integer finishedNumber = null;
        finishedNumber = !this.finishedNumberOfQueriesForUser.containsKey(userName) ? Integer.valueOf(0) : this.finishedNumberOfQueriesForUser.get(userName);
        this.finishedNumberOfQueriesForUser.put(userName, finishedNumber + size);
    }

    public int getPercentageOfProcessForUser(String userName) {
        if (!this.isUserMatching(userName).booleanValue()) {
            return 100;
        }
        if (!this.totalNumberOfQueriesForUser.containsKey(userName) || !this.finishedNumberOfQueriesForUser.containsKey(userName)) {
            return 0;
        }
        long totalNumber = this.totalNumberOfQueriesForUser.get(userName);
        int finishedNumber = this.finishedNumberOfQueriesForUser.get(userName);
        DecimalFormat df = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.ENGLISH));
        Double percentage = totalNumber == 0L ? new Double(0.0) : (double)finishedNumber / (double)totalNumber;
        percentage = Double.parseDouble(df.format(percentage * 100.0));
        return percentage.intValue();
    }

    public String getUserCurrentStage(String userName) {
        return this.userCurrentStage.containsKey(userName) ? this.userCurrentStage.get(userName).toString() : null;
    }

    public Boolean isUserLoggedIn(String userName, String requestSessionId) {
        this.setUserLoggedIn(userName, requestSessionId);
        return this.currentUsers.containsKey(userName) && !this.currentUsers.get(userName).equalsIgnoreCase(requestSessionId);
    }

    public Boolean isUserMatching(String userName) {
        return this.userCurrentMatching.containsKey(userName) && this.userCurrentMatching.get(userName) != false;
    }

    public void setUserIsRunning(String userName, Boolean status) {
        if (status.booleanValue()) {
            this.userCurrentMatching.put(userName, status);
        } else {
            if (this.userCurrentMatching.containsKey(userName)) {
                this.userCurrentMatching.remove(userName);
            }
            if (this.totalNumberOfQueriesForUser.containsKey(userName)) {
                this.totalNumberOfQueriesForUser.remove(userName);
            }
            if (this.finishedNumberOfQueriesForUser.containsKey(userName)) {
                this.finishedNumberOfQueriesForUser.remove(userName);
            }
            if (this.userCurrentStage.containsKey(userName)) {
                this.userCurrentStage.remove(userName);
            }
        }
    }

    public void setUserLoggedIn(String userName, String requestSessionId) {
        if (!this.currentUsers.containsKey(userName)) {
            this.currentUsers.put(userName, requestSessionId);
        }
    }

    public void removeCurrentUserBySessionId(String sessionId) {
        String keyToRemove = null;
        for (Map.Entry<String, String> entry : this.currentUsers.entrySet()) {
            if (!entry.getValue().equals(sessionId)) continue;
            keyToRemove = entry.getKey();
            break;
        }
        if (keyToRemove != null) {
            this.currentUsers.remove(keyToRemove);
        }
    }

    public Integer getTotalNumberOfUsers() {
        return this.userCurrentMatching.size();
    }

    public Map<String, String> getCurrentUsers() {
        return this.currentUsers;
    }

    public static enum STAGE {
        DeleteMapping,
        CreateMapping,
        StoreMapping;

    }
}

