
/* File:        org.molgenis.omx/model/Characteristic.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        August 21, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.Characteristic;


/**
 * Reads Characteristic from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class CharacteristicEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(CharacteristicEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
			
	/**
	 * Imports Characteristic from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Characteristic> characteristicsMissingRefs = new ArrayList<Characteristic>();
	
		//cache for objects to be imported from file (in batch)
		final List<Characteristic> characteristicList = new ArrayList<Characteristic>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			Characteristic object = new Characteristic();
			object.set(tuple, false);				
			characteristicList.add(object);		
			
			//add to db when batch size is reached
			if(characteristicList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				characteristicsMissingRefs.addAll(resolveForeignKeys(db, characteristicList));
				characteristicList.removeAll(characteristicsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(characteristicList,dbAction, "Identifier");
				
				//clear for next batch						
				characteristicList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!characteristicList.isEmpty())
		{
			total.set(total.get() + characteristicList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			characteristicsMissingRefs.addAll(resolveForeignKeys(db, characteristicList));
			characteristicList.removeAll(characteristicsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(characteristicList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Characteristic> characteristics = new ArrayList<Characteristic>(characteristicsMissingRefs);

		int iterationCount = 0;

		do
		{
			characteristicsMissingRefs = resolveForeignKeys(db, characteristicsMissingRefs);
			
			LinkedHashSet<Characteristic> differenceSet = new LinkedHashSet<Characteristic>();
			Sets.symmetricDifference(new LinkedHashSet<Characteristic>(characteristics), new LinkedHashSet<Characteristic>(characteristicsMissingRefs)).copyInto(differenceSet);
			List<Characteristic> resolvablecharacteristics = new ArrayList<Characteristic>(differenceSet);
			
			characteristics.removeAll(resolvablecharacteristics);
			
			db.update(resolvablecharacteristics,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Characteristic blaat : characteristicsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'characteristic' entity failed:"
								+ "This is probably caused by a(n) 'characteristic' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (characteristicsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " characteristic from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param characteristicList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Characteristic> resolveForeignKeys(Database db, List<Characteristic> characteristicList) throws Exception
	{
		//keep a list of Characteristic instances that miss a reference which might be resolvable later
		List<Characteristic> characteristicsMissingRefs = new ArrayList<Characteristic>();
	
		//update objects with foreign key values
		for(Characteristic o:  characteristicList)
		{
			while(true){
				break;
			}
		}
		
		
		return characteristicsMissingRefs;
	}
}

