package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.value.Value;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ValueService
{
	private static final Logger logger = Logger.getLogger(ValueService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	public Value create(Value value) throws DatabaseException
	{
		logger.debug("creating Value");
		db.add(value);
		return value;
	}

	public Value read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Value");
		return db.findById(Value.class, id);
	}

	public void update(Value value) throws DatabaseException
	{
		logger.debug("updating Value");
		db.update(value);
	}

	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Value");
		Value value = db.findById(Value.class, id);
		return db.remove(value) == 1;
	}
	
	public Iterable<Value> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Value instances");
		return db.find(Value.class);
	}
	
	public EntityPager<Value> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Value instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Value.class, queryRules.toArray(new QueryRule[0]));
		List<Value> valueCollection = db.find(Value.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Value>(start, num, count, valueCollection);
	}
	
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Value");
	}
}