
/* File:        org.molgenis.omx/model/Individual.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        August 21, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.target.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.target.Individual;


/**
 * Reads Individual from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class IndividualEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(IndividualEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'mother' (maps individual.Identifier -> individual.id)			
	final Map<String,Integer> motherKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'father' (maps individual.Identifier -> individual.id)			
	final Map<String,Integer> fatherKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports Individual from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Individual> individualsMissingRefs = new ArrayList<Individual>();
	
		//cache for objects to be imported from file (in batch)
		final List<Individual> individualList = new ArrayList<Individual>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			Individual object = new Individual();
			object.set(tuple, false);				
			individualList.add(object);		
			
			//add to db when batch size is reached
			if(individualList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				individualsMissingRefs.addAll(resolveForeignKeys(db, individualList));
				individualList.removeAll(individualsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(individualList,dbAction, "Identifier");
				
				//clear for next batch						
				individualList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!individualList.isEmpty())
		{
			total.set(total.get() + individualList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			individualsMissingRefs.addAll(resolveForeignKeys(db, individualList));
			individualList.removeAll(individualsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(individualList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Individual> individuals = new ArrayList<Individual>(individualsMissingRefs);

		int iterationCount = 0;

		do
		{
			individualsMissingRefs = resolveForeignKeys(db, individualsMissingRefs);
			
			LinkedHashSet<Individual> differenceSet = new LinkedHashSet<Individual>();
			Sets.symmetricDifference(new LinkedHashSet<Individual>(individuals), new LinkedHashSet<Individual>(individualsMissingRefs)).copyInto(differenceSet);
			List<Individual> resolvableindividuals = new ArrayList<Individual>(differenceSet);
			
			individuals.removeAll(resolvableindividuals);
			
			db.update(resolvableindividuals,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Individual blaat : individualsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'individual' entity failed:"
								+ "This is probably caused by a(n) 'individual' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (individualsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " individual from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param individualList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Individual> resolveForeignKeys(Database db, List<Individual> individualList) throws Exception
	{
		//keep a list of Individual instances that miss a reference which might be resolvable later
		List<Individual> individualsMissingRefs = new ArrayList<Individual>();
	
		//resolve xref 'mother' from individual.Identifier -> individual.id
		for(Individual o: individualList) 
		{
			if(o.getMother_Identifier() != null) 
				motherKeymap.put(o.getMother_Identifier(), null);
		}
		
		if(motherKeymap.size() > 0) 
		{
			List<Individual> motherList = db.query(Individual.class).in("Identifier",new ArrayList<Object>(motherKeymap.keySet())).find();
			for(Individual xref :  motherList)
			{
				motherKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'father' from individual.Identifier -> individual.id
		for(Individual o: individualList) 
		{
			if(o.getFather_Identifier() != null) 
				fatherKeymap.put(o.getFather_Identifier(), null);
		}
		
		if(fatherKeymap.size() > 0) 
		{
			List<Individual> fatherList = db.query(Individual.class).in("Identifier",new ArrayList<Object>(fatherKeymap.keySet())).find();
			for(Individual xref :  fatherList)
			{
				fatherKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(Individual o:  individualList)
		{
			while(true){
				//update xref Mother
				if(o.getMother_Identifier() != null) 
				{
					String key = o.getMother_Identifier();
					if(motherKeymap.get(key) == null)
					{
						individualsMissingRefs.add(o);
						break;
					}
					o.setMother_Id(motherKeymap.get(key));
				}
				//update xref Father
				if(o.getFather_Identifier() != null) 
				{
					String key = o.getFather_Identifier();
					if(fatherKeymap.get(key) == null)
					{
						individualsMissingRefs.add(o);
						break;
					}
					o.setFather_Id(fatherKeymap.get(key));
				}
				break;
			}
		}
		
		motherKeymap.clear();
		fatherKeymap.clear();
		
		return individualsMissingRefs;
	}
}

