
/* File:        org.molgenis.omx/model/DateTimeValue.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        August 21, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.value.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.value.DateTimeValue;


/**
 * Reads DateTimeValue from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class DateTimeValueEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(DateTimeValueEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
			
	/**
	 * Imports DateTimeValue from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<DateTimeValue> dateTimeValuesMissingRefs = new ArrayList<DateTimeValue>();
	
		//cache for objects to be imported from file (in batch)
		final List<DateTimeValue> dateTimeValueList = new ArrayList<DateTimeValue>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			DateTimeValue object = new DateTimeValue();
			object.set(tuple, false);				
			dateTimeValueList.add(object);		
			
			//add to db when batch size is reached
			if(dateTimeValueList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				dateTimeValuesMissingRefs.addAll(resolveForeignKeys(db, dateTimeValueList));
				dateTimeValueList.removeAll(dateTimeValuesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
				db.update(dateTimeValueList,dbAction, "id");
				
				//clear for next batch						
				dateTimeValueList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!dateTimeValueList.isEmpty())
		{
			total.set(total.get() + dateTimeValueList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			dateTimeValuesMissingRefs.addAll(resolveForeignKeys(db, dateTimeValueList));
			dateTimeValueList.removeAll(dateTimeValuesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
			db.update(dateTimeValueList,dbAction, "id");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<DateTimeValue> dateTimeValues = new ArrayList<DateTimeValue>(dateTimeValuesMissingRefs);

		int iterationCount = 0;

		do
		{
			dateTimeValuesMissingRefs = resolveForeignKeys(db, dateTimeValuesMissingRefs);
			
			LinkedHashSet<DateTimeValue> differenceSet = new LinkedHashSet<DateTimeValue>();
			Sets.symmetricDifference(new LinkedHashSet<DateTimeValue>(dateTimeValues), new LinkedHashSet<DateTimeValue>(dateTimeValuesMissingRefs)).copyInto(differenceSet);
			List<DateTimeValue> resolvabledateTimeValues = new ArrayList<DateTimeValue>(differenceSet);
			
			dateTimeValues.removeAll(resolvabledateTimeValues);
			
			db.update(resolvabledateTimeValues,dbAction, "id");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(DateTimeValue blaat : dateTimeValuesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'dateTimeValue' entity failed:"
								+ "This is probably caused by a(n) 'dateTimeValue' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (dateTimeValuesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " dateTimeValue from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param dateTimeValueList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<DateTimeValue> resolveForeignKeys(Database db, List<DateTimeValue> dateTimeValueList) throws Exception
	{
		//keep a list of DateTimeValue instances that miss a reference which might be resolvable later
		List<DateTimeValue> dateTimeValuesMissingRefs = new ArrayList<DateTimeValue>();
	
		//update objects with foreign key values
		for(DateTimeValue o:  dateTimeValueList)
		{
			while(true){
				break;
			}
		}
		
		
		return dateTimeValuesMissingRefs;
	}
}

