
/* File:        org.molgenis.omx/model/XrefValue.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        August 21, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.value.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.Characteristic;
import org.molgenis.omx.observ.value.XrefValue;


/**
 * Reads XrefValue from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class XrefValueEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(XrefValueEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'value' (maps characteristic.Identifier -> characteristic.id)			
	final Map<String,Integer> valueKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports XrefValue from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<XrefValue> xrefValuesMissingRefs = new ArrayList<XrefValue>();
	
		//cache for objects to be imported from file (in batch)
		final List<XrefValue> xrefValueList = new ArrayList<XrefValue>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			XrefValue object = new XrefValue();
			object.set(tuple, false);				
			xrefValueList.add(object);		
			
			//add to db when batch size is reached
			if(xrefValueList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				xrefValuesMissingRefs.addAll(resolveForeignKeys(db, xrefValueList));
				xrefValueList.removeAll(xrefValuesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
				db.update(xrefValueList,dbAction, "id");
				
				//clear for next batch						
				xrefValueList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!xrefValueList.isEmpty())
		{
			total.set(total.get() + xrefValueList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			xrefValuesMissingRefs.addAll(resolveForeignKeys(db, xrefValueList));
			xrefValueList.removeAll(xrefValuesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
			db.update(xrefValueList,dbAction, "id");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<XrefValue> xrefValues = new ArrayList<XrefValue>(xrefValuesMissingRefs);

		int iterationCount = 0;

		do
		{
			xrefValuesMissingRefs = resolveForeignKeys(db, xrefValuesMissingRefs);
			
			LinkedHashSet<XrefValue> differenceSet = new LinkedHashSet<XrefValue>();
			Sets.symmetricDifference(new LinkedHashSet<XrefValue>(xrefValues), new LinkedHashSet<XrefValue>(xrefValuesMissingRefs)).copyInto(differenceSet);
			List<XrefValue> resolvablexrefValues = new ArrayList<XrefValue>(differenceSet);
			
			xrefValues.removeAll(resolvablexrefValues);
			
			db.update(resolvablexrefValues,dbAction, "id");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(XrefValue blaat : xrefValuesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'xrefValue' entity failed:"
								+ "This is probably caused by a(n) 'xrefValue' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (xrefValuesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " xrefValue from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param xrefValueList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<XrefValue> resolveForeignKeys(Database db, List<XrefValue> xrefValueList) throws Exception
	{
		//keep a list of XrefValue instances that miss a reference which might be resolvable later
		List<XrefValue> xrefValuesMissingRefs = new ArrayList<XrefValue>();
	
		//resolve xref 'value' from characteristic.Identifier -> characteristic.id
		for(XrefValue o: xrefValueList) 
		{
			if(o.getValue_Identifier() != null) 
				valueKeymap.put(o.getValue_Identifier(), null);
		}
		
		if(valueKeymap.size() > 0) 
		{
			List<Characteristic> valueList = db.query(Characteristic.class).in("Identifier",new ArrayList<Object>(valueKeymap.keySet())).find();
			for(Characteristic xref :  valueList)
			{
				valueKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(XrefValue o:  xrefValueList)
		{
			while(true){
				//update xref Value
				if(o.getValue_Identifier() != null) 
				{
					String key = o.getValue_Identifier();
					if(valueKeymap.get(key) == null)
					{
						throw new Exception("Import of 'XrefValue' objects failed: cannot find Characteristic for value_Identifier='"+o.getValue_Identifier()+"'");
					}
					o.setValue_Id(valueKeymap.get(key));
				}
				break;
			}
		}
		
		valueKeymap.clear();
		
		return xrefValuesMissingRefs;
	}
}

