
/* File:        org.molgenis.omx/model/Category.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        September 20, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.ObservableFeature;
import org.molgenis.omx.observ.target.OntologyTerm;
import org.molgenis.omx.observ.Category;


/**
 * Reads Category from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class CategoryEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(CategoryEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'observableFeature' (maps observableFeature.Identifier -> observableFeature.id)			
	final Map<String,Integer> observableFeatureKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'definition' (maps ontologyTerm.Identifier -> ontologyTerm.id)			
	final Map<String,Integer> definitionKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports Category from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Category> categorysMissingRefs = new ArrayList<Category>();
	
		//cache for objects to be imported from file (in batch)
		final List<Category> categoryList = new ArrayList<Category>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			Category object = new Category();
			object.set(tuple, false);				
			categoryList.add(object);		
			
			//add to db when batch size is reached
			if(categoryList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				categorysMissingRefs.addAll(resolveForeignKeys(db, categoryList));
				categoryList.removeAll(categorysMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(categoryList,dbAction, "Identifier");
				
				//clear for next batch						
				categoryList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!categoryList.isEmpty())
		{
			total.set(total.get() + categoryList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			categorysMissingRefs.addAll(resolveForeignKeys(db, categoryList));
			categoryList.removeAll(categorysMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(categoryList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Category> categorys = new ArrayList<Category>(categorysMissingRefs);

		int iterationCount = 0;

		do
		{
			categorysMissingRefs = resolveForeignKeys(db, categorysMissingRefs);
			
			LinkedHashSet<Category> differenceSet = new LinkedHashSet<Category>();
			Sets.symmetricDifference(new LinkedHashSet<Category>(categorys), new LinkedHashSet<Category>(categorysMissingRefs)).copyInto(differenceSet);
			List<Category> resolvablecategorys = new ArrayList<Category>(differenceSet);
			
			categorys.removeAll(resolvablecategorys);
			
			db.update(resolvablecategorys,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Category blaat : categorysMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'category' entity failed:"
								+ "This is probably caused by a(n) 'category' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (categorysMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " category from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param categoryList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Category> resolveForeignKeys(Database db, List<Category> categoryList) throws Exception
	{
		//keep a list of Category instances that miss a reference which might be resolvable later
		List<Category> categorysMissingRefs = new ArrayList<Category>();
	
		//resolve xref 'observableFeature' from observableFeature.Identifier -> observableFeature.id
		for(Category o: categoryList) 
		{
			if(o.getObservableFeature_Identifier() != null) 
				observableFeatureKeymap.put(o.getObservableFeature_Identifier(), null);
		}
		
		if(observableFeatureKeymap.size() > 0) 
		{
			List<ObservableFeature> observableFeatureList = db.query(ObservableFeature.class).in("Identifier",new ArrayList<Object>(observableFeatureKeymap.keySet())).find();
			for(ObservableFeature xref :  observableFeatureList)
			{
				observableFeatureKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'definition' from ontologyTerm.Identifier -> ontologyTerm.id
		for(Category o: categoryList) 
		{
			if(o.getDefinition_Identifier() != null) 
				definitionKeymap.put(o.getDefinition_Identifier(), null);
		}
		
		if(definitionKeymap.size() > 0) 
		{
			List<OntologyTerm> definitionList = db.query(OntologyTerm.class).in("Identifier",new ArrayList<Object>(definitionKeymap.keySet())).find();
			for(OntologyTerm xref :  definitionList)
			{
				definitionKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(Category o:  categoryList)
		{
			while(true){
				//update xref observableFeature
				if(o.getObservableFeature_Identifier() != null) 
				{
					String key = o.getObservableFeature_Identifier();
					if(observableFeatureKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Category' objects failed: cannot find ObservableFeature for observableFeature_Identifier='"+o.getObservableFeature_Identifier()+"'");
					}
					o.setObservableFeature_Id(observableFeatureKeymap.get(key));
				}
				//update xref definition
				if(o.getDefinition_Identifier() != null) 
				{
					String key = o.getDefinition_Identifier();
					if(definitionKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Category' objects failed: cannot find OntologyTerm for definition_Identifier='"+o.getDefinition_Identifier()+"'");
					}
					o.setDefinition_Id(definitionKeymap.get(key));
				}
				break;
			}
		}
		
		observableFeatureKeymap.clear();
		definitionKeymap.clear();
		
		return categorysMissingRefs;
	}
}

