/* File:        org.molgenis.omx/model/ObservableFeature.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        September 20, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class ObservableFeatureJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.observ.ObservableFeature>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(ObservableFeatureJpaMapper.class);

	public ObservableFeatureJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT ObservableFeature.id"
			+", Characteristic.Identifier"
			+", Characteristic.Name"
			+", Characteristic.__Type"
			+", Characteristic.description"
			+", ObservableFeature.unit"
			+", ObservableFeature.definition"
			+", ObservableFeature.dataType"
			+", ObservableFeature.temporal"
			//parent is SimpleTree(name='unit')
			+", xref_unit.Identifier AS unit_Identifier"
			//parent is SimpleTree(name='definition')
			+", xref_definition.Identifier AS definition_Identifier"
			+" FROM ObservableFeature "
			+" INNER JOIN Characteristic ON (ObservableFeature.id = Characteristic.id)"

			
			//label for unit=Identifier
//path==unit. type==xref.
//path==unit_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_unit " 
			+" ON xref_unit.id = ObservableFeature.unit"
			
			//label for definition=Identifier
//path==definition. type==xref.
//path==definition_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_definition " 
			+" ON xref_definition.id = ObservableFeature.definition"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.observ.ObservableFeature entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'unit' is known in the databse
			if(entity.getUnit() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getUnit().getIdValue() == null)
					new org.molgenis.omx.observ.target.db.OntologyTermJpaMapper(getDatabase()).create(entity.getUnit());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getUnit()) && entity.getUnit().getIdValue() != null)
					entity.setUnit(getEntityManager().getReference(org.molgenis.omx.observ.target.OntologyTerm.class, entity.getUnit().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getUnit_Id() != null) {
					entity.setUnit((org.molgenis.omx.observ.target.OntologyTerm)getEntityManager().find(org.molgenis.omx.observ.target.OntologyTerm.class, entity.getUnit_Id()));
				}
			}
			//check if the object refered by 'definition' is known in the databse
			if(entity.getDefinition() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getDefinition().getIdValue() == null)
					new org.molgenis.omx.observ.target.db.OntologyTermJpaMapper(getDatabase()).create(entity.getDefinition());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getDefinition()) && entity.getDefinition().getIdValue() != null)
					entity.setDefinition(getEntityManager().getReference(org.molgenis.omx.observ.target.OntologyTerm.class, entity.getDefinition().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getDefinition_Id() != null) {
					entity.setDefinition((org.molgenis.omx.observ.target.OntologyTerm)getEntityManager().find(org.molgenis.omx.observ.target.OntologyTerm.class, entity.getDefinition_Id()));
				}
			}

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.observ.ObservableFeature observableFeature) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				observableFeature = getEntityManager().getReference(org.molgenis.omx.observ.ObservableFeature.class, observableFeature.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The observableFeature with id " + observableFeature.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(observableFeature);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.observ.ObservableFeature observableFeature) throws org.molgenis.framework.db.DatabaseException {
		try {







			//5
			org.molgenis.omx.observ.target.OntologyTerm unitNew = observableFeature.getUnit();

			if (unitNew == null) { //object is reference by xref		
                            if(observableFeature.getUnit_Id() != null) {
                                observableFeature.setUnit((org.molgenis.omx.observ.target.OntologyTerm)getEntityManager().find(org.molgenis.omx.observ.target.OntologyTerm.class, observableFeature.getUnit_Id()));
                            }
			}


			//5
			org.molgenis.omx.observ.target.OntologyTerm definitionNew = observableFeature.getDefinition();

			if (definitionNew == null) { //object is reference by xref		
                            if(observableFeature.getDefinition_Id() != null) {
                                observableFeature.setDefinition((org.molgenis.omx.observ.target.OntologyTerm)getEntityManager().find(org.molgenis.omx.observ.target.OntologyTerm.class, observableFeature.getDefinition_Id()));
                            }
			}


			if(!getEntityManager().contains(observableFeature)) {
				observableFeature = getEntityManager().merge(observableFeature);
			}
			


		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.observ.ObservableFeature> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.observ.ObservableFeature observableFeature : entities) 
			{
				create(observableFeature);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.observ.ObservableFeature> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.observ.ObservableFeature observableFeature : entities) 
			{
				edit(observableFeature);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.observ.ObservableFeature> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.observ.ObservableFeature observableFeature : entities) 
			{
				destroy(observableFeature);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("ObservableFeature_id".equalsIgnoreCase(fieldName)) return "id";
		if("Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("ObservableFeature_Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Name".equalsIgnoreCase(fieldName)) return "Name";
		if("ObservableFeature_Name".equalsIgnoreCase(fieldName)) return "Name";
		if("__Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("ObservableFeature___Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("description".equalsIgnoreCase(fieldName)) return "description";
		if("ObservableFeature_description".equalsIgnoreCase(fieldName)) return "description";
		if("unit".equalsIgnoreCase(fieldName)) return "unit";
		if("ObservableFeature_unit".equalsIgnoreCase(fieldName)) return "unit";
		if("definition".equalsIgnoreCase(fieldName)) return "definition";
		if("ObservableFeature_definition".equalsIgnoreCase(fieldName)) return "definition";
		if("dataType".equalsIgnoreCase(fieldName)) return "dataType";
		if("ObservableFeature_dataType".equalsIgnoreCase(fieldName)) return "dataType";
		if("temporal".equalsIgnoreCase(fieldName)) return "temporal";
		if("ObservableFeature_temporal".equalsIgnoreCase(fieldName)) return "temporal";
		if("unit_id".equalsIgnoreCase(fieldName)) return "unit";
		if("ObservableFeature_unit_id".equalsIgnoreCase(fieldName)) return "unit";
		if("unit_Identifier".equalsIgnoreCase(fieldName)) return "unit.Identifier";	
		if("ObservableFeature_unit_Identifier".equalsIgnoreCase(fieldName)) return "unit.Identifier";
		if("definition_id".equalsIgnoreCase(fieldName)) return "definition";
		if("ObservableFeature_definition_id".equalsIgnoreCase(fieldName)) return "definition";
		if("definition_Identifier".equalsIgnoreCase(fieldName)) return "definition.Identifier";	
		if("ObservableFeature_definition_Identifier".equalsIgnoreCase(fieldName)) return "definition.Identifier";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.observ.ObservableFeature> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.observ.ObservableFeature>(size);
	}			

	@Override
	public org.molgenis.omx.observ.ObservableFeature create()
	{
		return new org.molgenis.omx.observ.ObservableFeature();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.observ.ObservableFeature> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'unit' to ontologyTerm.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> unitRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'definition' to ontologyTerm.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> definitionRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.observ.ObservableFeature object: entities)
		{
			//create xref/mref rule filtering OntologyTerm on the label Identifier
			if(object.getUnit_Id() == null && object.getUnit_Identifier() != null)
			{
				Object label = object.getUnit_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!unitRules.containsKey(label))
					{
						unitRules.put(""+label, xrefFilter);
						unitRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering OntologyTerm on the label Identifier
			if(object.getDefinition_Id() == null && object.getDefinition_Identifier() != null)
			{
				Object label = object.getDefinition_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!definitionRules.containsKey(label))
					{
						definitionRules.put(""+label, xrefFilter);
						definitionRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'unit' to ontologyTerm.id using Identifier)
		final java.util.Map<String,Integer> unit_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(unitRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.target.OntologyTerm> unitList = null;
			try
			{
				unitList = getDatabase().find(org.molgenis.omx.observ.target.OntologyTerm.class, unitRules.values().toArray(new org.molgenis.framework.db.QueryRule[unitRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.target.OntologyTerm xref :  unitList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				unit_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'definition' to ontologyTerm.id using Identifier)
		final java.util.Map<String,Integer> definition_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(definitionRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.target.OntologyTerm> definitionList = null;
			try
			{
				definitionList = getDatabase().find(org.molgenis.omx.observ.target.OntologyTerm.class, definitionRules.values().toArray(new org.molgenis.framework.db.QueryRule[definitionRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.target.OntologyTerm xref :  definitionList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				definition_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.observ.ObservableFeature object = entities.get(i);		
			//update object using label fields Identifier
			if(object.getUnit_Id() == null )
			{
					String key = "";
					if(object.getUnit_Identifier() != null)
						key += 	object.getUnit_Identifier();
					
					if(!"".equals(key) && unit_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("unit_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setUnit_Id(unit_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields Identifier
			if(object.getDefinition_Id() == null )
			{
					String key = "";
					if(object.getDefinition_Identifier() != null)
						key += 	object.getDefinition_Identifier();
					
					if(!"".equals(key) && definition_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("definition_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setDefinition_Id(definition_Labels_to_IdMap.get(key));
					}
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "observableFeature.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("identifier".equalsIgnoreCase(fieldName) || "characteristic.identifier".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("name".equalsIgnoreCase(fieldName) || "characteristic.name".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("__Type".equalsIgnoreCase(fieldName) || "characteristic.__Type".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("description".equalsIgnoreCase(fieldName) || "characteristic.description".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("unit".equalsIgnoreCase(fieldName) || "observableFeature.unit".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("definition".equalsIgnoreCase(fieldName) || "observableFeature.definition".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("dataType".equalsIgnoreCase(fieldName) || "observableFeature.dataType".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("temporal".equalsIgnoreCase(fieldName) || "observableFeature.temporal".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.BoolField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.observ.ObservableFeature> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.observ.ObservableFeature> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
