
/* File:        org.molgenis.omx/model/ObservationSet.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        September 20, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.observ.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.DataSet;
import org.molgenis.omx.observ.ObservationSet;


/**
 * Reads ObservationSet from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class ObservationSetEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(ObservationSetEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'partOfDataSet' (maps dataSet.Identifier -> dataSet.id)			
	final Map<String,Integer> partOfDataSetKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports ObservationSet from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(TupleReader reader, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		// normalize column headers
		reader.addCellProcessor(new LowerCaseProcessor(true, false));
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<ObservationSet> observationSetsMissingRefs = new ArrayList<ObservationSet>();
	
		//cache for objects to be imported from file (in batch)
		final List<ObservationSet> observationSetList = new ArrayList<ObservationSet>(BATCH_SIZE); // FIXME
		
		for(Tuple tuple : reader)
		{
			// skip empty rows
			if (!hasValues(tuple)) continue;
			
			//parse object, setting defaults and values from file
			ObservationSet object = new ObservationSet();
			object.set(tuple, false);				
			observationSetList.add(object);		
			
			//add to db when batch size is reached
			if(observationSetList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				observationSetsMissingRefs.addAll(resolveForeignKeys(db, observationSetList));
				observationSetList.removeAll(observationSetsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
				db.update(observationSetList,dbAction, "id");
				
				//clear for next batch						
				observationSetList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!observationSetList.isEmpty())
		{
			total.set(total.get() + observationSetList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			observationSetsMissingRefs.addAll(resolveForeignKeys(db, observationSetList));
			observationSetList.removeAll(observationSetsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
			db.update(observationSetList,dbAction, "id");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<ObservationSet> observationSets = new ArrayList<ObservationSet>(observationSetsMissingRefs);

		int iterationCount = 0;

		do
		{
			observationSetsMissingRefs = resolveForeignKeys(db, observationSetsMissingRefs);
			
			LinkedHashSet<ObservationSet> differenceSet = new LinkedHashSet<ObservationSet>();
			Sets.symmetricDifference(new LinkedHashSet<ObservationSet>(observationSets), new LinkedHashSet<ObservationSet>(observationSetsMissingRefs)).copyInto(differenceSet);
			List<ObservationSet> resolvableobservationSets = new ArrayList<ObservationSet>(differenceSet);
			
			observationSets.removeAll(resolvableobservationSets);
			
			db.update(resolvableobservationSets,dbAction, "id");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(ObservationSet blaat : observationSetsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'observationSet' entity failed:"
								+ "This is probably caused by a(n) 'observationSet' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (observationSetsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " observationSet from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Tuple tuple)
	{
		for (String colName : tuple.getColNames())
		{
			if (tuple.get(colName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param observationSetList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<ObservationSet> resolveForeignKeys(Database db, List<ObservationSet> observationSetList) throws Exception
	{
		//keep a list of ObservationSet instances that miss a reference which might be resolvable later
		List<ObservationSet> observationSetsMissingRefs = new ArrayList<ObservationSet>();
	
		//resolve xref 'partOfDataSet' from dataSet.Identifier -> dataSet.id
		for(ObservationSet o: observationSetList) 
		{
			if(o.getPartOfDataSet_Identifier() != null) 
				partOfDataSetKeymap.put(o.getPartOfDataSet_Identifier(), null);
		}
		
		if(partOfDataSetKeymap.size() > 0) 
		{
			List<DataSet> partOfDataSetList = db.query(DataSet.class).in("Identifier",new ArrayList<Object>(partOfDataSetKeymap.keySet())).find();
			for(DataSet xref :  partOfDataSetList)
			{
				partOfDataSetKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(ObservationSet o:  observationSetList)
		{
			while(true){
				//update xref partOfDataSet
				if(o.getPartOfDataSet_Identifier() != null) 
				{
					String key = o.getPartOfDataSet_Identifier();
					if(partOfDataSetKeymap.get(key) == null)
					{
						throw new Exception("Import of 'ObservationSet' objects failed: cannot find DataSet for partOfDataSet_Identifier='"+o.getPartOfDataSet_Identifier()+"'");
					}
					o.setPartOfDataSet_Id(partOfDataSetKeymap.get(key));
				}
				break;
			}
		}
		
		partOfDataSetKeymap.clear();
		
		return observationSetsMissingRefs;
	}
}

